/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.entrybook;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.exceptions.AlreadyExistEntryBookException;
import org.chorem.lima.business.exceptions.UsedEntryBookException;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryBookImpl;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.ui.entrybook.EntryBookForm;
import org.chorem.lima.ui.entrybook.EntryBookImportForm;
import org.chorem.lima.ui.entrybook.EntryBookTable;
import org.chorem.lima.ui.entrybook.EntryBookTableModel;
import org.chorem.lima.ui.entrybook.EntryBookView;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class EntryBookViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(EntryBookViewHandler.class);
    protected EntryBookView view;
    protected EntryBookService entryBookService;
    protected ErrorHelper errorHelper;

    public EntryBookViewHandler(EntryBookView view) {
        this.view = view;
        this.entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());
    }

    public void init() {
        InputMap inputMap = this.view.getInputMap(1);
        ActionMap actionMap = this.view.getActionMap();
        String binding = "new-entryBook";
        inputMap.put(KeyStroke.getKeyStroke(78, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -2195732334248213712L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryBookViewHandler.this.addEntryBook();
            }
        });
        binding = "remove-entryBook";
        inputMap.put(KeyStroke.getKeyStroke(127, 0), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -4932713296274387513L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryBookViewHandler.this.deleteEntryBook();
            }
        });
        binding = "modify-entryBook";
        inputMap.put(KeyStroke.getKeyStroke(77, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -761841876399286500L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryBookViewHandler.this.updateEntryBook();
            }
        });
        EntryBookTable table = this.view.getEntryBooksTable();
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EntryBookViewHandler.this.updateEntryBook();
                }
            }
        });
        this.loadAllEntryBooks();
    }

    protected void loadAllEntryBooks() {
        List entryBooks = this.entryBookService.getAllEntryBooks();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded %d entry books from service", entryBooks.size()));
        }
        EntryBookTableModel model = this.view.getEntryBookTableModel();
        model.setValues(entryBooks);
    }

    public void addEntryBook() {
        EntryBookImpl newEntryBook = new EntryBookImpl();
        final EntryBookForm entryBookForm = new EntryBookForm((JAXXContext)this.view);
        InputMap inputMap = entryBookForm.getRootPane().getInputMap(1);
        ActionMap actionMap = entryBookForm.getRootPane().getActionMap();
        String binding = "dispose";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -8206425963136985592L;

            @Override
            public void actionPerformed(ActionEvent e) {
                entryBookForm.performCancel();
            }
        });
        entryBookForm.setEntryBook((EntryBook)newEntryBook);
        entryBookForm.setLocationRelativeTo(this.view);
        entryBookForm.setVisible(true);
        newEntryBook = entryBookForm.getEntryBook();
        if (newEntryBook != null) {
            try {
                newEntryBook = this.entryBookService.createEntryBook((EntryBook)newEntryBook);
            }
            catch (AlreadyExistEntryBookException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entryBook.alreadyExistEntryBook", (Object[])new Object[]{e.getEntryBook().getCode()}));
            }
            EntryBookTableModel model = this.view.getEntryBookTableModel();
            model.addValue(newEntryBook);
        }
    }

    public void updateEntryBook() {
        EntryBookTable entryBookTable = this.view.getEntryBooksTable();
        EntryBookTableModel entryBookTableModel = this.view.getEntryBookTableModel();
        int selectedRow = entryBookTable.getSelectedRow();
        if (selectedRow >= 0) {
            EntryBook selectedEntryBook = (EntryBook)entryBookTableModel.get(selectedRow);
            final EntryBookForm entryBookForm = new EntryBookForm((JAXXContext)this.view);
            InputMap inputMap = entryBookForm.getRootPane().getInputMap(1);
            ActionMap actionMap = entryBookForm.getRootPane().getActionMap();
            String binding = "dispose";
            inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
            actionMap.put(binding, new AbstractAction(){
                private static final long serialVersionUID = 4869740774851185380L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    entryBookForm.performCancel();
                }
            });
            entryBookForm.setAddState(false);
            entryBookForm.setEntryBook(selectedEntryBook);
            entryBookForm.setLocationRelativeTo(this.view);
            entryBookForm.setVisible(true);
            selectedEntryBook = entryBookForm.getEntryBook();
            if (selectedEntryBook != null) {
                selectedEntryBook = this.entryBookService.updateEntryBook(selectedEntryBook);
                entryBookTableModel.updateEntryBook(selectedEntryBook);
            }
        }
    }

    public void deleteEntryBook() {
        EntryBookTable entryBookTable = this.view.getEntryBooksTable();
        int selectedRow = entryBookTable.getSelectedRow();
        if (selectedRow >= 0) {
            EntryBookTableModel entryBookTableModel = this.view.getEntryBookTableModel();
            EntryBook selectedEntryBook = (EntryBook)entryBookTableModel.get(selectedRow);
            int response = JOptionPane.showConfirmDialog(this.view, I18n.t((String)"lima.entryBook.remove.confirm", (Object[])new Object[]{selectedEntryBook.getLabel()}), I18n.t((String)"lima.entryBook.remove.title", (Object[])new Object[0]), 0, 3);
            if (response == 0) {
                try {
                    this.entryBookService.removeEntryBook(selectedEntryBook);
                    entryBookTableModel.remove(selectedEntryBook);
                }
                catch (UsedEntryBookException e) {
                    this.errorHelper.showErrorMessage(I18n.t((String)"lima.entryBook.delete.used.error", (Object[])new Object[]{e.getEntryBook().getCode(), e.getEntryBook().getLabel()}));
                }
            }
        }
    }

    public void importEntryBooks() {
        final EntryBookImportForm form = new EntryBookImportForm((JAXXContext)this.view);
        InputMap inputMap = form.getRootPane().getInputMap(1);
        ActionMap actionMap = form.getRootPane().getActionMap();
        String binding = "dispose";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -1659538823979223871L;

            @Override
            public void actionPerformed(ActionEvent e) {
                form.performCancel();
            }
        });
        form.setLocationRelativeTo(this.view);
        form.setVisible(true);
        Object value = form.getButtonGroup().getSelectedValue();
        if (value != null) {
            ImportExport importExport = new ImportExport(this.view);
            importExport.importExport(ImportExportEnum.CSV_ENTRYBOOKS_IMPORT, null, null, true);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("importEntryBooks") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.loadAllEntryBooks();
        }
    }
}

