/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.chorem.lima.ui.celleditor.StringTableCellEditor;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

public class AutoCompleteTableCellEditor
extends StringTableCellEditor {
    protected static final Map<String, List<String>> PRECEDING_VALUES_BY_ID = Maps.newHashMap();
    List<String> precedingValues;

    public AutoCompleteTableCellEditor(String id) {
        this.precedingValues = PRECEDING_VALUES_BY_ID.get(id);
        if (this.precedingValues == null) {
            this.precedingValues = Lists.newLinkedList();
            PRECEDING_VALUES_BY_ID.put(id, this.precedingValues);
        }
        AutoCompleteDecorator.decorate((JTextComponent)this.getComponent(), this.precedingValues, (boolean)false);
    }

    @Override
    public String getCellEditorValue() {
        String stringValue = super.getCellEditorValue().toString();
        if (!this.precedingValues.contains(stringValue)) {
            this.precedingValues.add(stringValue);
        }
        return stringValue;
    }
}

