/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.fiscalperiod;

import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import jaxx.runtime.JAXXContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.exceptions.AlreadyLockedFiscalPeriodException;
import org.chorem.lima.business.exceptions.BeginAfterEndFiscalPeriodException;
import org.chorem.lima.business.exceptions.LastUnlockedFiscalPeriodException;
import org.chorem.lima.business.exceptions.MoreOneUnlockFiscalPeriodException;
import org.chorem.lima.business.exceptions.NoEmptyFiscalPeriodException;
import org.chorem.lima.business.exceptions.NotBeginNextDayOfLastFiscalPeriodException;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryBookImpl;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.entity.FiscalPeriodImpl;
import org.chorem.lima.ui.fiscalperiod.AddPeriod;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodTable;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodTableModel;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodView;
import org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm;
import org.chorem.lima.ui.fiscalperiod.RetainedEarningsWait;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;

public class FiscalPeriodViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(FiscalPeriodViewHandler.class);
    protected FiscalPeriodView view;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialTransactionService financialTransactionService;
    protected ErrorHelper errorHelper;

    public FiscalPeriodViewHandler(FiscalPeriodView view) {
        this.view = view;
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
        this.errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());
    }

    public void init() {
        InputMap inputMap = this.view.getInputMap(1);
        ActionMap actionMap = this.view.getActionMap();
        String binding = "new-FiscalPeriod";
        inputMap.put(KeyStroke.getKeyStroke(78, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 3174253799898553603L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FiscalPeriodViewHandler.this.addFiscalPeriod();
            }
        });
        binding = "update-FiscalPeriod";
        inputMap.put(KeyStroke.getKeyStroke(77, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FiscalPeriodViewHandler.this.updateFiscalPeriod();
            }
        });
        binding = "remove-FiscalPeriod";
        inputMap.put(KeyStroke.getKeyStroke(127, 0), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FiscalPeriodViewHandler.this.deleteFiscalPeriod();
            }
        });
        binding = "close-FiscalPeriod";
        inputMap.put(KeyStroke.getKeyStroke(66, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FiscalPeriodViewHandler.this.blockFiscalPeriod();
            }
        });
        this.loadAllFiscalPeriod();
    }

    public void loadAllFiscalPeriod() {
        List periods = this.fiscalPeriodService.getAllFiscalPeriods();
        FiscalPeriodTableModel tableModel = this.view.getFiscalPeriodTableModel();
        tableModel.setValues(periods);
    }

    public void addFiscalPeriod() {
        FiscalPeriodTableModel tableModel = this.view.getFiscalPeriodTableModel();
        Date beginDate = null;
        FiscalPeriod result = this.fiscalPeriodService.getLastFiscalPeriod();
        if (result != null) {
            beginDate = DateUtils.addDays((Date)result.getEndDate(), (int)1);
        }
        if (beginDate == null) {
            Calendar calendarBegin = Calendar.getInstance();
            beginDate = calendarBegin.getTime();
            beginDate = DateUtils.truncate((Date)beginDate, (int)1);
        }
        Date endDate = DateUtils.addYears((Date)beginDate, (int)1);
        endDate = DateUtils.addDays((Date)endDate, (int)-1);
        AddPeriod addPeriodDialog = new AddPeriod((JAXXContext)this.view);
        addPeriodDialog.setTitle(I18n.t((String)"lima.fiscalPeriod.add.form", (Object[])new Object[0]));
        addPeriodDialog.getBeginDatePicker().setDate(beginDate);
        addPeriodDialog.getEndDatePicker().setDate(endDate);
        addPeriodDialog.setLocationRelativeTo(this.view);
        addPeriodDialog.setVisible(true);
        if (this.checkFiscalPeriod(addPeriodDialog)) {
            try {
                FiscalPeriodImpl fiscalPeriod = new FiscalPeriodImpl();
                fiscalPeriod.setBeginDate(addPeriodDialog.getBeginDatePicker().getDate());
                fiscalPeriod.setEndDate(addPeriodDialog.getEndDatePicker().getDate());
                fiscalPeriod = this.fiscalPeriodService.createFiscalPeriod((FiscalPeriod)fiscalPeriod);
                tableModel.addValue(fiscalPeriod);
            }
            catch (BeginAfterEndFiscalPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.fiscalPeriod.add.error.beginAfterEndFiscalPeriod", (Object[])new Object[]{e.getFiscalPeriod().getBeginDate(), e.getFiscalPeriod().getEndDate()}));
            }
            catch (MoreOneUnlockFiscalPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.fiscalPeriod.add.error.moreOneUnlockFiscalPeriod", (Object[])new Object[]{e.getCountUnlockFiscalPeriod()}));
            }
            catch (NotBeginNextDayOfLastFiscalPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.fiscalPeriod.add.error.notBeginNextDayOfLastFiscalPeriod", (Object[])new Object[]{e.getFiscalPeriod().getEndDate()}));
            }
        }
    }

    protected boolean checkFiscalPeriod(AddPeriod addPeriodDialog) {
        Date beginDate = addPeriodDialog.getBeginDatePicker().getDate();
        Date endDate = addPeriodDialog.getEndDatePicker().getDate();
        String title = addPeriodDialog.getTitle();
        if (!addPeriodDialog.isValidate().booleanValue()) {
            return false;
        }
        if (endDate.before(beginDate)) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.fiscalPeriod.add.error.beginAfterEndFiscalPeriod", (Object[])new Object[]{beginDate, endDate}));
            return false;
        }
        int nbMonth = DateUtil.getDifferenceInMonths((Date)beginDate, (Date)endDate);
        int response = 0;
        if (nbMonth != 12) {
            response = JOptionPane.showConfirmDialog(this.view, I18n.t((String)"lima.fiscalPeriod.add.confirm.moreThan12", (Object[])new Object[0]), title, 0, 3);
        }
        return response == 0;
    }

    public void updateFiscalPeriod() {
        FiscalPeriod selectedFiscalPeriod;
        FiscalPeriodTable table = this.view.getFiscalPeriodTable();
        FiscalPeriodTableModel tableModel = this.view.getFiscalPeriodTableModel();
        int selectedRow = table.getSelectedRow();
        if (selectedRow >= 0 && !(selectedFiscalPeriod = (FiscalPeriod)tableModel.get(selectedRow)).isLocked()) {
            AddPeriod addPeriodDialog = new AddPeriod((JAXXContext)this.view);
            addPeriodDialog.setTitle(I18n.t((String)"lima.fiscalPeriod.update.form", (Object[])new Object[0]));
            addPeriodDialog.getBeginDatePicker().setDate(selectedFiscalPeriod.getBeginDate());
            addPeriodDialog.getEndDatePicker().setDate(selectedFiscalPeriod.getEndDate());
            addPeriodDialog.setModifyPeriod(true);
            addPeriodDialog.setLocationRelativeTo(this.view);
            addPeriodDialog.setVisible(true);
            if (this.checkFiscalPeriod(addPeriodDialog)) {
                selectedFiscalPeriod.setEndDate(addPeriodDialog.getEndDatePicker().getDate());
                this.fiscalPeriodService.updateEndDate(selectedFiscalPeriod);
                tableModel.fireTableRowsUpdated(selectedRow, selectedRow);
            }
        }
    }

    public void deleteFiscalPeriod() {
        int response;
        FiscalPeriod selectedFiscalPeriod;
        FiscalPeriodTable table = this.view.getFiscalPeriodTable();
        FiscalPeriodTableModel tableModel = this.view.getFiscalPeriodTableModel();
        int selectedRow = table.getSelectedRow();
        if (selectedRow >= 0 && !(selectedFiscalPeriod = (FiscalPeriod)tableModel.get(selectedRow)).isLocked() && this.financialTransactionService.getAllFinancialTransactions(selectedFiscalPeriod).isEmpty() && (response = JOptionPane.showConfirmDialog(this.view, I18n.t((String)"lima.fiscalPeriod.delete.confirmation", (Object[])new Object[0]), I18n.t((String)"lima.fiscalPeriod.delete.title", (Object[])new Object[0]), 0, 2)) == 0) {
            try {
                this.fiscalPeriodService.deleteFiscalPeriod(selectedFiscalPeriod);
                tableModel.remove(selectedFiscalPeriod);
                this.view.setBlockEnabled(false);
                this.view.setDeleteEnabled(false);
            }
            catch (NoEmptyFiscalPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.fiscalPeriod.delete.error.noEmptyFiscalPeriod", (Object[])new Object[]{e.getFinancialTransactions().size()}));
            }
        }
    }

    public void blockFiscalPeriod() {
        int answerBlock;
        FiscalPeriod selectedFiscalPeriod;
        FiscalPeriodTable table = this.view.getFiscalPeriodTable();
        final FiscalPeriodTableModel tableModel = this.view.getFiscalPeriodTableModel();
        final int selectedRow = table.getSelectedRow();
        if (selectedRow >= 0 && !(selectedFiscalPeriod = (FiscalPeriod)tableModel.get(selectedRow)).isLocked() && (answerBlock = JOptionPane.showConfirmDialog(this.view, I18n.t((String)"lima.fiscalPeriod.block.confirmation", (Object[])new Object[0]), I18n.t((String)"lima.fiscalPeriod.block.title", (Object[])new Object[0]), 0, 2)) == 0) {
            if (this.fiscalPeriodService.isRetainedEarnings(selectedFiscalPeriod)) {
                int answerCreate;
                FiscalPeriod lastFiscalPeriod = this.fiscalPeriodService.getLastFiscalPeriod();
                if (selectedFiscalPeriod.equals(lastFiscalPeriod) && (answerCreate = JOptionPane.showConfirmDialog(this.view, I18n.t((String)"lima.fiscalPeriod.block.newYear", (Object[])new Object[0]), I18n.t((String)"lima.fiscalPeriod.block.title", (Object[])new Object[0]), 0, 3)) == 0) {
                    this.addFiscalPeriod();
                }
                if (selectedFiscalPeriod.equals(lastFiscalPeriod = this.fiscalPeriodService.getLastFiscalPeriod())) {
                    JOptionPane.showMessageDialog(this.view, I18n.t((String)"lima.fiscalPeriod.block.cantBalanceIfNextPeriodNotExist", (Object[])new Object[0]), I18n.t((String)"lima.fiscalPeriod.block.title", (Object[])new Object[0]), 0);
                } else {
                    int answerRetainedEarnings = JOptionPane.showConfirmDialog(this.view, I18n.t((String)"lima.fiscalPeriod.block.addRetainedEarnings", (Object[])new Object[0]), I18n.t((String)"lima.fiscalPeriod.block.title", (Object[])new Object[0]), 0, 3);
                    if (answerRetainedEarnings == 0) {
                        EntryBookImpl newEntryBook = new EntryBookImpl();
                        RetainedEarningsEntryBookForm entryBookForm = new RetainedEarningsEntryBookForm((JAXXContext)this.view);
                        entryBookForm.setEntryBook((EntryBook)newEntryBook);
                        entryBookForm.setLocationRelativeTo(this.view);
                        entryBookForm.setVisible(true);
                        final EntryBook entryBook = entryBookForm.getEntryBook();
                        if (entryBook != null && StringUtils.isNotBlank((String)entryBook.getCode())) {
                            final RetainedEarningsWait retainedEarningsWait = new RetainedEarningsWait((JAXXContext)this.view);
                            retainedEarningsWait.setLocationRelativeTo(this.view);
                            new SwingWorker<FiscalPeriod, Void>(){

                                @Override
                                protected FiscalPeriod doInBackground() throws Exception {
                                    FiscalPeriod fiscalPeriodBlocked = FiscalPeriodViewHandler.this.fiscalPeriodService.retainedEarningsAndBlockFiscalPeriod(selectedFiscalPeriod, entryBook, true);
                                    tableModel.setValue(selectedRow, fiscalPeriodBlocked);
                                    FiscalPeriodViewHandler.this.view.setBlockEnabled(false);
                                    FiscalPeriodViewHandler.this.view.setDeleteEnabled(false);
                                    return fiscalPeriodBlocked;
                                }

                                @Override
                                protected void done() {
                                    retainedEarningsWait.setVisible(false);
                                }
                            }.execute();
                            retainedEarningsWait.setVisible(true);
                        } else {
                            JOptionPane.showMessageDialog(this.view, I18n.t((String)"lima.fiscalPeriod.block.cantBalanceNotBook", (Object[])new Object[0]), I18n.t((String)"lima.fiscalPeriod.block.title", (Object[])new Object[0]), 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.view, I18n.t((String)"lima.fiscalPeriod.block.cantBlockNotBalance", (Object[])new Object[0]), I18n.t((String)"lima.fiscalPeriod.block.title", (Object[])new Object[0]), 0);
                    }
                }
            } else {
                try {
                    FiscalPeriod fiscalPeriodBlocked = this.fiscalPeriodService.blockFiscalPeriod(selectedFiscalPeriod);
                    tableModel.setValue(selectedRow, fiscalPeriodBlocked);
                    this.view.setBlockEnabled(false);
                    this.view.setDeleteEnabled(false);
                }
                catch (LastUnlockedFiscalPeriodException e) {
                    this.errorHelper.showErrorMessage(I18n.t((String)"lima.fiscalPeriod.block.error.lastUnlockedFiscalPeriod", (Object[])new Object[]{e.getFiscalPeriod().getBeginDate(), e.getFiscalPeriod().getEndDate()}));
                }
                catch (AlreadyLockedFiscalPeriodException e) {
                    this.errorHelper.showErrorMessage(I18n.t((String)"lima.fiscalPeriod.block.error.AlreadyLockedFiscalPeriod", (Object[])new Object[0]));
                }
            }
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("importAll")) {
            this.loadAllFiscalPeriod();
        }
    }

    protected void onSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            FiscalPeriodTableModel tableModel;
            int selectedRow;
            DefaultListSelectionModel listSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectedIndex(selectedRow = listSelectionEvent.getFirstIndex())) {
                selectedRow = listSelectionEvent.getLastIndex();
            }
            if ((tableModel = this.view.getFiscalPeriodTableModel()).getRowCount() != selectedRow) {
                FiscalPeriod fiscalPeriodAt = (FiscalPeriod)tableModel.get(selectedRow);
                List financialTransactionList = this.financialTransactionService.getAllFinancialTransactions(fiscalPeriodAt);
                boolean enableBlock = false;
                boolean enableDelete = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"reloadEnablingButton");
                }
                if (selectedRow != -1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"selectedFiscalPeriod != null");
                    }
                    if (!fiscalPeriodAt.isLocked()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"selectedFiscalPeriod not locked");
                        }
                        enableBlock = true;
                        enableDelete = financialTransactionList.size() <= 0;
                    }
                }
                this.view.setBlockEnabled(enableBlock);
                this.view.setDeleteEnabled(enableDelete);
            }
        }
    }
}

