/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.ui.combobox.AccountComboBoxModel;

public class LetterComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AccountComboBoxModel.class);
    protected Object selectedAccount;
    protected List<String> datasCache;
    protected FinancialTransactionService financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);

    public LetterComboBoxModel() {
        LimaServiceFactory.addServiceListener(FinancialTransactionService.class, (ServiceListener)this);
        this.datasCache = this.getDataList();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedAccount;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedAccount = anItem;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getElementAt(int index) {
        return this.datasCache.get(index);
    }

    @Override
    public int getSize() {
        return this.datasCache.size();
    }

    public List<String> getDataList() {
        List result = this.financialTransactionService.getAllLetters();
        return result;
    }

    public void refresh() {
        this.datasCache = this.getDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("Letter") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

