/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.enums;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaTechnicalException;

public enum ImportExportEnum {
    CSV_ALL_EXPORT(false, false),
    CSV_ALL_IMPORT(true, true),
    CSV_ACCOUNTCHARTS_EXPORT(false, true),
    CSV_ACCOUNTCHARTS_IMPORT(true, true),
    CSV_ENTRYBOOKS_EXPORT(false, true),
    CSV_ENTRYBOOKS_IMPORT(true, true),
    CSV_ENTRIES_EXPORT(false, true),
    CSV_ENTRIES_IMPORT(true, true),
    CSV_FINANCIALSTATEMENTS_EXPORT(false, true),
    CSV_FINANCIALSTATEMENTS_IMPORT(true, true),
    CSV_VAT_EXPORT(false, true),
    CSV_VAT_IMPORT(true, true),
    PDF_VAT_EXPORT(false, true),
    PDF_VAT_IMPORT(true, true),
    EBP_ACCOUNTCHARTS_EXPORT(false, false),
    EBP_ENTRIES_EXPORT(false, false),
    EBP_ACCOUNTCHARTS_IMPORT(true, true),
    EBP_ENTRIES_IMPORT(true, true),
    EBP_ENTRYBOOKS_IMPORT(true, true),
    EBP_ENTRYBOOKS_EXPORT(false, false);

    private static final Log log;
    private final Boolean importMode;
    private final Boolean encodingOption;

    private ImportExportEnum(Boolean importMode, Boolean encodingOption) {
        this.importMode = importMode;
        this.encodingOption = encodingOption;
    }

    protected static URL getFileURL(String filePAth) {
        URL result = ImportExportEnum.class.getResource(filePAth);
        if (result == null) {
            File file = new File(filePAth);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Load %s from File path", filePAth));
            }
            try {
                result = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new LimaTechnicalException("Could not get url of file: " + file);
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)String.format("Load %s from resource path", filePAth));
        }
        if (result == null) {
            throw new LimaTechnicalException(String.format("Could not load file: %s", filePAth));
        }
        return result;
    }

    public Boolean getEncodingOption() {
        return this.encodingOption;
    }

    public Boolean getImportMode() {
        return this.importMode;
    }

    static {
        log = LogFactory.getLog(ImportExportEnum.class);
    }
}

