/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.lettering;

import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.LetteringFilter;
import org.chorem.lima.beans.LetteringFilterImpl;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.AccountImpl;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.lettering.LetteringEditModel;
import org.chorem.lima.ui.lettering.LetteringTable;
import org.chorem.lima.ui.lettering.LetteringTableModel;
import org.chorem.lima.ui.lettering.LetteringView;
import org.chorem.lima.ui.lettering.LettringSelectionModel;
import org.chorem.lima.ui.lettering.TypeEntry;
import org.nuiton.i18n.I18n;

public class LetteringViewHandler {
    protected LetteringView view;
    protected LetteringTable table;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialPeriodService financialPeriodService;
    protected AccountService accountService;
    protected FinancialTransactionService financialTransactionService;
    protected EntryBookService entryBookService;
    protected LetteringFilterImpl filter;
    protected BigDecimal debit = BigDecimal.ZERO;
    protected BigDecimal credit = BigDecimal.ZERO;
    protected BigDecimal solde = BigDecimal.ZERO;
    protected LettringSelectionModel lettringSelectionModel;
    protected LetteringEditModel editModel;
    private static final Log log = LogFactory.getLog(LetteringViewHandler.class);

    public LetteringViewHandler(LetteringView view) {
        this.view = view;
        this.initShortCuts();
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
        this.entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);
    }

    public void init() {
        this.filter = new LetteringFilterImpl();
        this.editModel = this.view.getEditModel();
        this.lettringSelectionModel = this.view.getLettringSelectionModel();
        this.loadComboAndRows();
    }

    protected void initShortCuts() {
        InputMap inputMap = this.view.getInputMap(1);
        ActionMap actionMap = this.view.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(65, 2), "none");
        String binding = "lettering";
        inputMap.put(KeyStroke.getKeyStroke(76, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LetteringViewHandler.this.addLetter();
            }
        });
        binding = "un-lettering";
        inputMap.put(KeyStroke.getKeyStroke(127, 0), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LetteringViewHandler.this.removeLetter();
            }
        });
        binding = "balance";
        inputMap.put(KeyStroke.getKeyStroke(66, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LetteringViewHandler.this.roundAndCreateEntry();
            }
        });
        binding = "refresh";
        inputMap.put(KeyStroke.getKeyStroke(116, 0), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LetteringViewHandler.this.updateAllEntries();
            }
        });
    }

    public void balanceAndActions() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"balanceAndActions");
        }
        if (this.view.getTable().getSelectedRows().length == 0) {
            this.onButtonModeChanged(ButtonMode.ALL);
            this.onBalanceChanged(null);
        } else if (!this.letteringNotExist(this.view.getTable().getSelectedRow())) {
            this.onBalanceChanged(null);
            this.setValuesForSelectedEntries();
            this.onButtonModeChanged(ButtonMode.DELETTRED);
        } else {
            int[] selectedRows;
            if (log.isDebugEnabled()) {
                log.debug((Object)"unlettred entries");
            }
            if ((selectedRows = this.view.getTable().getSelectedRows()).length == 2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"2 rows selected");
                }
                LetteringTableModel tableModel = this.view.getTableModel();
                Entry firstSelectedEntry = (Entry)tableModel.get(selectedRows[0]);
                Entry secondSelectedEntry = (Entry)tableModel.get(selectedRows[1]);
                BigDecimal firstSelectedEntryAmount = firstSelectedEntry.getAmount();
                BigDecimal secondSelectedEntryAmount = secondSelectedEntry.getAmount();
                if (secondSelectedEntry.getDebit() != firstSelectedEntry.getDebit() && firstSelectedEntryAmount.subtract(secondSelectedEntryAmount).abs().compareTo(BigDecimal.ZERO) > 0 && firstSelectedEntryAmount.subtract(secondSelectedEntryAmount).abs().compareTo(BigDecimal.ONE) < 0) {
                    this.onButtonModeChanged(ButtonMode.EQUALIZED);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"!2 rows selected");
                }
                this.onButtonModeChanged(ButtonMode.ALL);
            }
            this.onBalanceChanged(null);
            if (!this.view.getLettringSelectionModel().isSelectionEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Rows selected");
                }
                this.setValuesForSelectedEntries();
                this.onButtonModeChanged(ButtonMode.LETTRED);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No Rows selected");
                }
                this.onButtonModeChanged(ButtonMode.ALL);
            }
        }
    }

    public boolean letteringNotExist(int row) {
        boolean emptyOrNull = false;
        if (row != -1) {
            Entry entry = (Entry)this.view.getTableModel().get(row);
            String lettering = entry.getLettering();
            emptyOrNull = lettering == null || lettering.isEmpty();
        }
        return emptyOrNull;
    }

    public void onButtonModeChanged(ButtonMode buttonMode) {
        switch (buttonMode) {
            case DELETTRED: {
                this.editModel.setLettred(false);
                this.editModel.setUnLettred(true);
                break;
            }
            case LETTRED: {
                this.editModel.setUnLettred(false);
                this.editModel.setLettred(true);
                break;
            }
            case EQUALIZED: {
                this.editModel.setEqualized(true);
                break;
            }
            default: {
                this.editModel.setLettred(false);
                this.editModel.setUnLettred(false);
                this.editModel.setEqualized(false);
            }
        }
    }

    public void setValuesForSelectedEntries() {
        LetteringTableModel tableModel = this.view.getTableModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (!this.view.getLettringSelectionModel().isSelectedIndex(i)) continue;
            Entry selectedEntry = (Entry)tableModel.get(i);
            this.onBalanceChanged(selectedEntry);
        }
    }

    public void onBalanceChanged(Entry balance) {
        if (balance == null) {
            this.editModel.setCredit(BigDecimal.ZERO);
            this.editModel.setDebit(BigDecimal.ZERO);
            this.editModel.setSolde(BigDecimal.ZERO, false);
        } else {
            this.balanceCalculation(balance.getAmount(), balance.getDebit());
        }
    }

    public void balanceCalculation(BigDecimal amount, boolean debit) {
        BigDecimal creditVal;
        BigDecimal debitVal = debit ? amount : BigDecimal.ZERO;
        BigDecimal bigDecimal = creditVal = debit ? BigDecimal.ZERO : amount;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Balance calculation");
        }
        if (debitVal.equals(BigDecimal.ZERO)) {
            if (!creditVal.equals(BigDecimal.ZERO)) {
                this.editModel.setCredit(creditVal);
                this.editModel.setSolde(creditVal, true);
            }
        } else if (creditVal.equals(BigDecimal.ZERO)) {
            this.editModel.setDebit(debitVal);
            this.editModel.setSolde(debitVal, false);
        } else {
            this.onBalanceChanged(null);
        }
    }

    public void loadComboAndRows() {
        List allAccounts = this.accountService.getAllAccounts();
        AccountImpl seeAllAccounts = new AccountImpl();
        seeAllAccounts.setAccountNumber("-");
        seeAllAccounts.setLabel(I18n.t((String)"lima.ui.list.seeAll", (Object[])new Object[0]));
        allAccounts.add(seeAllAccounts);
        this.view.getAccountComboBoxModel().setObjects(allAccounts);
        if (!allAccounts.isEmpty()) {
            this.view.getAccountComboBox().setSelectedItem(allAccounts.get(0));
        }
        FiscalPeriod fiscalPeriod = this.fiscalPeriodService.getLastFiscalPeriod();
        Calendar calendar = Calendar.getInstance();
        int dernierJourMoisCourant = calendar.getActualMaximum(5);
        int premierJourMoisCourant = calendar.getActualMinimum(5);
        Date defaultDateBegFiscalPeriod = fiscalPeriod != null ? this.fiscalPeriodService.getLastFiscalPeriod().getBeginDate() : DateUtils.setDays((Date)new Date(), (int)premierJourMoisCourant);
        Date defaultDateEndCurrent = DateUtils.setDays((Date)new Date(), (int)dernierJourMoisCourant);
        this.view.getPickerDebut().setDate(defaultDateBegFiscalPeriod);
        this.view.getPickerFin().setDate(defaultDateEndCurrent);
        this.filter.setDateStart(defaultDateBegFiscalPeriod);
        this.filter.setDateEnd(defaultDateEndCurrent);
        TypeEntry type = (TypeEntry)this.view.getLettredEntryComboBox().getSelectedItem();
        this.setTypeEntry(type);
        this.updateAllEntries();
    }

    protected List<Entry> findAllEntries(LetteringFilterImpl filter) {
        if (filter != null) {
            List entries = this.financialTransactionService.getAllEntrieByDatesAndAccountAndLettering((LetteringFilter)filter);
            return entries;
        }
        return null;
    }

    public void setDateStart(Date date) {
        this.filter.setDateStart(date);
        this.updateAllEntries();
    }

    public void setDateEnd(Date date) {
        this.filter.setDateEnd(date);
        this.updateAllEntries();
    }

    public void setAccount(Account account) {
        this.filter.setAccount(account);
        this.updateAllEntries();
    }

    public void setTypeEntry(TypeEntry typeEntry) {
        this.filter.setDisplayLettered(typeEntry.isLettered());
        this.filter.setDisplayUnlettred(typeEntry.isNoLettered());
        this.updateAllEntries();
    }

    public void updateAllEntries() {
        if (this.filter.getAccount() != null && this.filter.getDateStart() != null && this.filter.getDateEnd() != null) {
            List<Entry> entries = this.findAllEntries(this.filter);
            this.view.getTableModel().setValues(entries);
        }
        this.onBalanceChanged(null);
    }

    public void roundAndCreateEntry() {
        LetteringTableModel tableModel = this.view.getTableModel();
        int[] selectedRows = this.view.getTable().getSelectedRows();
        if (this.editModel.isEqualized() && selectedRows.length == 2) {
            Entry firstSelectedEntry = (Entry)tableModel.get(selectedRows[0]);
            Entry secondSelectedEntry = (Entry)tableModel.get(selectedRows[1]);
            Entry[] newEntriesFormEqualizing = this.financialTransactionService.getEntriesFromEqualizing(firstSelectedEntry, secondSelectedEntry);
            Entry newSameAccountEntry = newEntriesFormEqualizing[0];
            Entry newCostOrProductEntry = newEntriesFormEqualizing[1];
            tableModel.addValue(newSameAccountEntry);
            tableModel.addValue(newCostOrProductEntry);
            this.view.getLettringSelectionModel().selectRoundedAndNewEntries(selectedRows[0], selectedRows[1], newSameAccountEntry);
        }
    }

    public void back(JComboBox comboBox) {
        int row = comboBox.getSelectedIndex();
        if (row > 0) {
            comboBox.setSelectedIndex(row - 1);
        }
        this.view.getLettringSelectionModel().clearSelection();
    }

    public void next(JComboBox comboBox) {
        int size = comboBox.getModel().getSize();
        int row = comboBox.getSelectedIndex();
        if (row < size - 1) {
            comboBox.setSelectedIndex(row + 1);
        }
        this.view.getLettringSelectionModel().clearSelection();
    }

    public void addLetter() {
        if (this.editModel.isLettred()) {
            String newLetters = this.financialTransactionService.getNextLetters();
            this.changeLetter(newLetters);
            this.onButtonModeChanged(ButtonMode.DELETTRED);
        }
    }

    public void removeLetter() {
        if (this.editModel.isUnLettred()) {
            this.changeLetter(null);
            this.onButtonModeChanged(ButtonMode.LETTRED);
        }
    }

    protected void changeLetter(String newLetters) {
        int[] entrieSelected = this.view.getTable().getSelectedRows();
        LetteringTableModel tableModel = this.view.getTableModel();
        for (int indexEntry : entrieSelected) {
            Entry entry = (Entry)tableModel.get(indexEntry);
            entry.setLettering(newLetters);
            this.financialTransactionService.updateEntry(entry);
            tableModel.fireTableRowsUpdated(indexEntry, indexEntry);
        }
    }

    protected static enum ButtonMode {
        DELETTRED,
        LETTRED,
        EQUALIZED,
        ALL;

    }
}

