/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.ledger;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.nuiton.i18n.I18n;

public class LedgerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected List<Object> objects;

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.objects != null) {
            result = this.objects.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        switch (column) {
            case 0: {
                result = Account.class;
                break;
            }
            case 1: {
                result = Date.class;
                break;
            }
            case 2: {
                result = EntryBook.class;
                break;
            }
            case 3: {
                result = String.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            case 5: {
                result = BigDecimal.class;
                break;
            }
            case 6: {
                result = BigDecimal.class;
                break;
            }
            case 7: {
                result = BigDecimal.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0: {
                res = I18n.t((String)"lima.table.account", (Object[])new Object[0]);
                break;
            }
            case 1: {
                res = I18n.t((String)"lima.table.date", (Object[])new Object[0]);
                break;
            }
            case 2: {
                res = I18n.t((String)"lima.table.entrybook", (Object[])new Object[0]);
                break;
            }
            case 3: {
                res = I18n.t((String)"lima.table.voucher", (Object[])new Object[0]);
                break;
            }
            case 4: {
                res = I18n.t((String)"lima.table.description", (Object[])new Object[0]);
                break;
            }
            case 5: {
                res = I18n.t((String)"lima.table.debit", (Object[])new Object[0]);
                break;
            }
            case 6: {
                res = I18n.t((String)"lima.table.credit", (Object[])new Object[0]);
                break;
            }
            case 7: {
                res = I18n.t((String)"lima.table.solde", (Object[])new Object[0]);
            }
        }
        return res;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.objects != null) {
            result = this.objects.get(row);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMMMM yyyy");
            if (result instanceof ReportsDatas) {
                ReportsDatas currentRow = (ReportsDatas)result;
                BigDecimal amountDebit = currentRow.getAmountDebit();
                BigDecimal amountCredit = currentRow.getAmountCredit();
                switch (column) {
                    case 0: {
                        if (currentRow.getAccount() != null) {
                            result = currentRow.getAccount().getAccountNumber();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 1: {
                        result = null;
                        break;
                    }
                    case 2: {
                        result = null;
                        break;
                    }
                    case 3: {
                        result = null;
                        break;
                    }
                    case 4: {
                        result = null;
                        break;
                    }
                    case 5: {
                        result = amountDebit;
                        break;
                    }
                    case 6: {
                        result = amountCredit;
                        break;
                    }
                    case 7: {
                        result = amountDebit.subtract(amountCredit);
                    }
                }
            } else if (result instanceof Entry) {
                Entry currentRow = (Entry)result;
                BigDecimal amountDebit = BigDecimal.ZERO;
                BigDecimal amountCredit = BigDecimal.ZERO;
                if (currentRow.getDebit()) {
                    amountDebit = currentRow.getAmount();
                } else {
                    amountCredit = currentRow.getAmount();
                }
                switch (column) {
                    case 0: {
                        result = null;
                        break;
                    }
                    case 1: {
                        result = simpleDateFormat.format(currentRow.getFinancialTransaction().getTransactionDate());
                        break;
                    }
                    case 2: {
                        if (currentRow.getFinancialTransaction().getEntryBook() != null) {
                            result = currentRow.getFinancialTransaction().getEntryBook().getCode();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 3: {
                        result = currentRow.getVoucher();
                        break;
                    }
                    case 4: {
                        result = currentRow.getDescription();
                        break;
                    }
                    case 5: {
                        result = amountDebit;
                        break;
                    }
                    case 6: {
                        result = amountCredit;
                        break;
                    }
                    case 7: {
                        result = amountDebit.subtract(amountCredit);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setObjects(List<Object> datasList) {
        this.objects = datasList;
        this.fireTableDataChanged();
    }
}

