/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.entrybooksreports;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.api.DocumentService;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.HttpServerService;
import org.chorem.lima.business.api.ReportService;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.entrybooksreports.EntryBooksReportsView;

public class EntryBooksReportsViewHandler {
    private static final Log log = LogFactory.getLog(EntryBooksReportsViewHandler.class);
    protected EntryBooksReportsView view;
    protected ReportService reportService;
    protected DocumentService documentService;
    protected EntryBookService entryBookService;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialPeriodService financialPeriodService;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public EntryBooksReportsViewHandler(EntryBooksReportsView view) {
        this.view = view;
        this.reportService = (ReportService)LimaServiceFactory.getService(ReportService.class);
        this.documentService = (DocumentService)LimaServiceFactory.getService(DocumentService.class);
        this.reportService = (ReportService)LimaServiceFactory.getService(ReportService.class);
        this.entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
    }

    public void init() {
        List blockedFiscalPeriods = this.fiscalPeriodService.getAllFiscalPeriods();
        List financialPeriod = this.financialPeriodService.getUnblockedFinancialPeriods();
        this.view.getIntervalPanel().init(blockedFiscalPeriods, financialPeriod);
    }

    public void createDocument() {
        Date beginDate = this.view.getIntervalPanel().getBeginDate();
        Date endDate = this.view.getIntervalPanel().getEndDate();
        if (beginDate != null && endDate != null) {
            int port = ((HttpServerService)LimaServiceFactory.getService(HttpServerService.class)).getHttpPort();
            String address = LimaConfig.getInstance().getHostAdress();
            try {
                String url = "http://" + address + ":" + port + "/?beginDate=" + dateFormat.format(beginDate) + "&endDate=" + dateFormat.format(endDate) + "&format=.html&model=" + DocumentsEnum.ENTRYBOOKS.getFileName();
                Desktop.getDesktop().browse(new URI(url));
                String url2 = "http://" + address + ":" + port + "/?beginDate=" + dateFormat.format(beginDate) + "&endDate=" + dateFormat.format(endDate) + "&format=.html&model=" + DocumentsEnum.GENERAL_ENTRYBOOK.getFileName();
                Desktop.getDesktop().browse(new URI(url2));
            }
            catch (IOException e) {
                log.error((Object)"Can't open browser", (Throwable)e);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Can't create news URI", (Throwable)e);
            }
        }
    }
}

