/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.vatreports;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.VatStatementAmounts;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ReportServiceMonitorable;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.VatStatementServiceMonitorable;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class VatReportTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = -6301817853711018389L;
    private static final Log log = LogFactory.getLog(VatReportTableModel.class);
    protected ReportServiceMonitorable reportService = LimaServiceFactory.getInstance().getService(ReportServiceMonitorable.class);
    protected VatStatementServiceMonitorable vatStatementService = LimaServiceFactory.getInstance().getService(VatStatementServiceMonitorable.class);
    protected FinancialTransactionServiceMonitorable financialTransactionService;
    protected ImportServiceMonitorable importService;
    protected Date selectedBeginDate;
    protected Date selectedEndDate;
    protected List<VatStatementAmounts> cacheDataList;
    protected String autocomplete;

    public VatReportTableModel() {
        this.vatStatementService.addListener((ServiceListener)this);
        this.financialTransactionService = LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class);
        this.financialTransactionService.addListener((ServiceListener)this);
        this.importService = LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class);
        this.importService.addListener((ServiceListener)this);
        this.autocomplete = "true";
    }

    protected List<VatStatementAmounts> getDataList() throws TopiaException {
        List list = null;
        if (this.selectedBeginDate != null || this.selectedEndDate != null) {
            try {
                list = this.vatStatementService.vatStatementReport(this.getBeginDate(), this.getEndDate());
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Can't update model", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"lima.vatreport.listerror", (Object[])new Object[0]), eee);
            }
        }
        return list;
    }

    public void refresh() {
        try {
            this.cacheDataList = this.getDataList();
        }
        catch (TopiaException eee) {
            if (log.isErrorEnabled()) {
                log.debug((Object)"Can't update model", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog("Can't get VAT list", eee);
        }
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        switch (column) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = BigDecimal.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = "n/a";
        switch (column) {
            case 0: {
                result = I18n._((String)"lima.table.label", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n._((String)"lima.table.solde", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public VatStatementAmounts getElementAt(int row) {
        VatStatementAmounts currentRow = this.cacheDataList.get(row);
        return currentRow;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.cacheDataList != null) {
            VatStatementAmounts value = this.cacheDataList.get(row);
            switch (column) {
                case 0: {
                    result = value.getLabel();
                    break;
                }
                case 1: {
                    result = value.getAmount() != null && !value.isHeader() ? value.getAmount() : null;
                }
            }
        }
        return result;
    }

    public void setBeginDate(Date date) {
        this.selectedBeginDate = date;
    }

    public Date getBeginDate() {
        return this.selectedBeginDate;
    }

    public void setEndDate(Date date) {
        this.selectedEndDate = date;
    }

    public Date getEndDate() {
        return this.selectedEndDate;
    }

    public String getAutocomplete() {
        return this.autocomplete;
    }

    public void setAutocomplete() {
        this.autocomplete = this.getAutocomplete().equals("true") ? "false" : "true";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("VatStatement") || methodeName.contains("import")) {
            this.refresh();
        }
    }
}

