/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.chorem.lima.LimaSplash;
import org.chorem.lima.business.AccountServiceMonitorable;
import org.chorem.lima.business.HttpServerServiceMonitorable;
import org.chorem.lima.business.ejbinterface.AccountService;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.MainViewHandler;
import org.chorem.lima.ui.opening.OpeningView;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class LimaMain {
    private static final Log log = LogFactory.getLog(LimaMain.class);
    public static LimaConfig config;
    private static LimaSplash splash;

    public static void main(String[] args) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Lima start at " + new Date()));
            log.info((Object)("Args: " + Arrays.toString(args)));
        }
        try {
            LimaContext context = LimaMain.init(args);
            config = (LimaConfig)((Object)context.getContextValue(LimaConfig.class));
            config.doAction(1);
            if (config.isLaunchui()) {
                LimaMain.launch(context);
            }
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n._((String)"lima.common.globalexception"), (Throwable)ex);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"lima.common.globalexception"), ex);
            System.exit(1);
        }
    }

    public static synchronized LimaContext init(String ... args) throws Exception {
        LimaContext context;
        block3: {
            splash = new LimaSplash();
            splash.initSplash();
            System.setSecurityManager(null);
            long t0 = System.nanoTime();
            I18n.init((Locale)Locale.FRANCE);
            if (log.isDebugEnabled()) {
                log.debug((Object)("i18n loading time : " + StringUtil.convertTime((long)t0, (long)System.nanoTime())));
            }
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
            context = LimaContext.init();
            LimaConfig config = (LimaConfig)((Object)context.getContextValue(LimaConfig.class));
            config.parse(args);
            context.initI18n();
            try {
                SwingUtil.initNimbusLoookAndFeel();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)I18n._((String)"lima.warning.nimbus.landf"));
            }
        }
        return context;
    }

    protected static void launch(LimaContext context) throws Exception {
        splash.drawVersion(config.getVersion());
        splash.updateProgression(0.1, I18n._((String)"lima.splash.1"));
        MainViewHandler uiHandler = (MainViewHandler)context.getContextValue(MainViewHandler.class);
        final MainView ui = uiHandler.initUI(context, context.getConfig().isFullScreen());
        ui.setLocationRelativeTo(null);
        uiHandler.showHomeView((JAXXContext)context);
        splash.updateProgression(0.7, I18n._((String)"lima.splash.2"));
        LimaServiceFactory.getInstance().getService(HttpServerServiceMonitorable.class).start();
        AccountService accountService = (AccountService)LimaServiceFactory.getInstance().getService(AccountServiceMonitorable.class);
        List accounts = accountService.getChildrenAccounts(null);
        if (accounts.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Propose for defaut account loading");
            }
            OpeningView openingView = new OpeningView();
            openingView.setSize(800, 400);
            openingView.setLocationRelativeTo(null);
            openingView.setVisible(true);
        } else {
            splash.updateProgression(1.0, I18n._((String)"lima.splash.3"));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ui.setVisible(true);
            }
        });
    }

    public static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("Shutdown Lima");
        }

        @Override
        public void run() {
            try {
                super.run();
                LimaContext.get().close();
                LimaServiceFactory.getInstance().destroy();
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n._((String)"lima.init.closed", (Object[])new Object[]{new Date()}));
                }
                Runtime.getRuntime().halt(0);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)I18n._((String)"lima.init.errorclosing"), (Throwable)ex);
                }
                Runtime.getRuntime().halt(1);
            }
        }
    }
}

