/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialperiod;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialPeriodServiceMonitorable;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.nuiton.i18n.I18n;

public class FinancialPeriodTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = 77027335135838258L;
    private static final Log log = LogFactory.getLog(FinancialPeriodTableModel.class);
    protected FinancialPeriodServiceMonitorable financialPeriodService = LimaServiceFactory.getInstance().getService(FinancialPeriodServiceMonitorable.class);
    protected List<ClosedPeriodicEntryBook> cacheDataList;

    public FinancialPeriodTableModel() {
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class).addListener((ServiceListener)this);
    }

    @Override
    public int getRowCount() {
        return this.cacheDataList.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result = "n/a";
        switch (columnIndex) {
            case 0: {
                result = I18n._((String)"lima.table.period");
                break;
            }
            case 1: {
                result = I18n._((String)"lima.table.entrybook");
                break;
            }
            case 2: {
                result = I18n._((String)"lima.table.closure");
            }
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public ClosedPeriodicEntryBook getFinancialPeriodAtRow(int row) throws LimaException {
        return this.cacheDataList.get(row);
    }

    public Object getElementAt(int row) {
        ClosedPeriodicEntryBook currentRow = this.cacheDataList.get(row);
        return currentRow;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result = null;
        ClosedPeriodicEntryBook closedPeriodicEntryBook = this.cacheDataList.get(rowIndex);
        if (closedPeriodicEntryBook != null) {
            EntryBook entryBook = closedPeriodicEntryBook.getEntryBook();
            FinancialPeriod financialPeriod = closedPeriodicEntryBook.getFinancialPeriod();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy");
            switch (columnIndex) {
                case 0: {
                    result = simpleDateFormat.format(financialPeriod.getBeginDate()) + " - " + simpleDateFormat.format(financialPeriod.getEndDate());
                    break;
                }
                case 1: {
                    result = entryBook.getCode() + " - " + entryBook.getLabel();
                    break;
                }
                case 2: {
                    result = closedPeriodicEntryBook.getLocked() ? I18n._((String)"lima.common.closed") : I18n._((String)"lima.common.open");
                }
            }
        }
        return result;
    }

    public void getDataList() {
        List results;
        block2: {
            results = new ArrayList();
            try {
                results = this.financialPeriodService.getAllClosedPeriodicEntryBooksFromUnblockedFiscalPeriod();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get closedperiodicentrybook list", (Throwable)eee);
            }
        }
        this.cacheDataList = results;
    }

    public void blockFinancialPeriod(ClosedPeriodicEntryBook closedPeriodicEntryBook) throws LimaException {
        this.financialPeriodService.blockClosedPeriodicEntryBook(closedPeriodicEntryBook);
        this.fireTableDataChanged();
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("FiscalPeriod") || methodeName.contains("importAll")) {
            this.getDataList();
            this.fireTableDataChanged();
        }
    }
}

