/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.opening;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.AccountsChartEnum;
import org.chorem.lima.ui.opening.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class CreateAccountsPanel extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_RADIO_BUTTONS = "radioButtons";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JRADIO_BUTTON0_BUTTON_GROUP = "$JRadioButton0.buttonGroup";
    private static final String BINDING_$JRADIO_BUTTON1_BUTTON_GROUP = "$JRadioButton1.buttonGroup";
    private static final String BINDING_$JRADIO_BUTTON2_BUTTON_GROUP = "$JRadioButton2.buttonGroup";
    private static final String BINDING_$JRADIO_BUTTON3_BUTTON_GROUP = "$JRadioButton3.buttonGroup";
    private static final String BINDING_$JRADIO_BUTTON4_BUTTON_GROUP = "$JRadioButton4.buttonGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTz08TQRR+rRQooCiECgEiIh6MulXhYiDKD4NKKhrqgdiLs90JXbLdHWdnYb0Y/wT/BL17MfHmyXjw7MGL8V8wxoNX45tZ2i26DhPbw3Yz877vfe/b773+BoWQw9ldEscWj3zhNqm1sbK9fd/epXVxi4Z17jIRcEh+uTzkazDotM9DAedqFQkvH8DLa0GTBT71O9CLFRgIxVOPhg1KhYDpw4h6GJar7evFmEW8xdoWlcX68sf3/Avn+as8QMxQXRFHmTkKlU7SU4G86wgYwU57pOwRfwdlcNffQb3H5dmaR8JwkzTpE3gGfRXoZYQjmYBZ85EVh8LHTED/3MYD4lPvigAr4DtWvRFw2rQ8t0msyLUCRn3sb61xSgRdqdcD7BAqBGOKpVfAECeOG6xGQgQ++j97aOJwX+LlJ0wKbvMgYim2b+4hsT2K7cczYOpOVhbbABRcIbYSPCItiVsd1KksGm7Xnpjb2EqlJT06EB13OtxVeXpaV3HtyIr5IysWOis4TB5yAwNppYFME5OrQYFHeIyj1f7O8BZeJekd/yO9klDd/iqNfn739e16K7Jj2Hsss7Rj4zBKjGM0uHBl6+Ekr5FwvfI9whZrGHzq4bqqdZzKEFY9uEZx2O+UhFsSbt0hYQMpCn1f3n8oPf50DPLrMOAFxFknsv4uFEWDowuB58Ts5rJSNLTfj8+TUpuAHkFj3IeRJdf3XJ/OEIELZEeC3ojRhqkMG9pa7OLHn6PVN8stK3IobeKf5akdhUfQm3RT+3uwmpn7OshCGjlBuoJZS5mT/6OtHTmvnheyZh20043COC05RJAZ2/UdTDeOK3GX1RzyraxoSwa0/cnHo2qSS//LI48vdsUgoLBHvEh5t9CNjHkNw4QRw3XNIGYMOivMGFa7nkLnw2TXPpgx6HwwY9D5YMag82G6ax/MGHQ+mDHofDBj0PlwpmsfzBh0Ppgx6HyQDL8BD5hP8lMKAAA=";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.opening.CreateAccountsPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.JAXXButtonGroup radioButtons;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CreateAccountsPanel $JPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JRadioButton $JRadioButton0;
    private javax.swing.JRadioButton $JRadioButton1;
    private javax.swing.JRadioButton $JRadioButton2;
    private javax.swing.JRadioButton $JRadioButton3;
    private javax.swing.JRadioButton $JRadioButton4;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateAccountsPanel() {
        $initialize();
    }

    public CreateAccountsPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.JAXXButtonGroup getRadioButtons() {
        return radioButtons;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setRadioButtons(jaxx.runtime.swing.JAXXButtonGroup newValue) {
        jaxx.runtime.swing.JAXXButtonGroup oldValue = this.radioButtons;
        this.radioButtons = newValue;
        firePropertyChange(PROPERTY_RADIO_BUTTONS, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JRadioButton get$JRadioButton0() {
        return $JRadioButton0;
    }

    protected javax.swing.JRadioButton get$JRadioButton1() {
        return $JRadioButton1;
    }

    protected javax.swing.JRadioButton get$JRadioButton2() {
        return $JRadioButton2;
    }

    protected javax.swing.JRadioButton get$JRadioButton3() {
        return $JRadioButton3;
    }

    protected javax.swing.JRadioButton get$JRadioButton4() {
        return $JRadioButton4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createRadioButtons() {
        $objectMap.put("radioButtons", radioButtons = new JAXXButtonGroup());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton4, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        { $JRadioButton0.putClientProperty("$value", AccountsChartEnum.SHORTENED);  Object $buttonGroup = $JRadioButton0.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton1.putClientProperty("$value", AccountsChartEnum.BASE);  Object $buttonGroup = $JRadioButton1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton2.putClientProperty("$value", AccountsChartEnum.DEVELOPED);  Object $buttonGroup = $JRadioButton2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton3.putClientProperty("$value", AccountsChartEnum.IMPORT);  Object $buttonGroup = $JRadioButton3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton4.putClientProperty("$value", AccountsChartEnum.IMPORTEBP);  Object $buttonGroup = $JRadioButton4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createRadioButtons();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.opening.accounts"));
        // inline creation of $JRadioButton0
        $objectMap.put("$JRadioButton0", $JRadioButton0 = new javax.swing.JRadioButton());
        
        $JRadioButton0.setName("$JRadioButton0");
        $JRadioButton0.setSelected(true);
        $JRadioButton0.setText(_("lima.charts.account.shortened"));
        // inline creation of $JRadioButton1
        $objectMap.put("$JRadioButton1", $JRadioButton1 = new javax.swing.JRadioButton());
        
        $JRadioButton1.setName("$JRadioButton1");
        $JRadioButton1.setSelected(true);
        $JRadioButton1.setText(_("lima.charts.account.base"));
        // inline creation of $JRadioButton2
        $objectMap.put("$JRadioButton2", $JRadioButton2 = new javax.swing.JRadioButton());
        
        $JRadioButton2.setName("$JRadioButton2");
        $JRadioButton2.setSelected(true);
        $JRadioButton2.setText(_("lima.charts.account.developed"));
        // inline creation of $JRadioButton3
        $objectMap.put("$JRadioButton3", $JRadioButton3 = new javax.swing.JRadioButton());
        
        $JRadioButton3.setName("$JRadioButton3");
        $JRadioButton3.setSelected(true);
        $JRadioButton3.setText(_("lima.importexport.importcsv"));
        // inline creation of $JRadioButton4
        $objectMap.put("$JRadioButton4", $JRadioButton4 = new javax.swing.JRadioButton());
        
        $JRadioButton4.setName("$JRadioButton4");
        $JRadioButton4.setSelected(true);
        $JRadioButton4.setText(_("lima.importexport.importebp"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON0_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { javax.swing.ButtonGroup $buttonGroup = getRadioButtons(); $JRadioButton0.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton0); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON1_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { javax.swing.ButtonGroup $buttonGroup = getRadioButtons(); $JRadioButton1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton1); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON2_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { javax.swing.ButtonGroup $buttonGroup = getRadioButtons(); $JRadioButton2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton2); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON3_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { javax.swing.ButtonGroup $buttonGroup = getRadioButtons(); $JRadioButton3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton3); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON4_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { javax.swing.ButtonGroup $buttonGroup = getRadioButtons(); $JRadioButton4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton4); }
            }
        });
    }

}