/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.lettering;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.lettering.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class AddLetterForm extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_LETTER_LIST_COMBO_BOX = "LetterListComboBox";
    public static final String PROPERTY_RADIO_BUTTONS = "radioButtons";
    public static final String PROPERTY_VALID_OK = "validOk";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LETTER_LIST_COMBO_BOX_VISIBLE = "LetterListComboBox.visible";
    public static final String BINDING_LIST_LETTER_BUTTON_GROUP = "listLetter.buttonGroup";
    public static final String BINDING_NEW_LETTER_BUTTON_GROUP = "newLetter.buttonGroup";
    public static final String BINDING_NEW_LETTER_TEXT_FIELD_VISIBLE = "newLetterTextField.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTU8TQRieVkppwS8IFSIaQE4ctmo8aCDIVyqSKglwIPbitDtpB6Y768xsWS/Gn+BP0LsXE2+ejAfPHrwY/4IxHrwa35nt7rK4QGN7aLfvvM8zz/N+7NsfKCcFmtnHvm8Jz1G0TazNlb29rfo+aah1IhuCuooLFHwyWZStoWE7ikuFbtSqGl7uwstrvO1yhzhH0AtVVJTqOSOyRYhS6FoS0ZCyvBMdL/iuJ0LWSFQa6+tfP7Ov7Jdvsgj5LqgrgpXps1Cxk4EqylJboVG4qYPLDDtNkCGo0wS953VsjWEpH+M2eYZeoHwVDbpYAJlCs71bNhwG77sKFeY21ylmvHlToXkumlajxQVpW4y2seVRi0F5iJZgrdh21fypcNF2XUMxqNCIwDblq55S3IHizybsykON1P0LEh4I7rkxNt/BjNpbBwpd1u4s7dha5ZwR7BzJmtvFdUZA4EQKuTnTmYUIUHDIYSDVQDrYD4Vsx1p17mgEGY0gu8RXFUoY9KGUwEYHSWSRUakCqI5cOcYbnFQhB3pS56vcV2g8wRvGk0DoS6ATbI8l8tPkZ/mBfprtRgW6mqgUzLMVz3M8cJkaygkPwlCn2r8rsA1HwfBPHBt+TWhO/5TGvn74/r4STvwFuHs8NfXIwsIkuoK70B6qr74YjLunKCs/wu5CDRUkYbDtZpunUoTtdI9BHNwXzI6GWxtYtoAil//28VPp6ZdzKFuBBnFsV7DOf4gKqiWgCpzZvnt/2SgaORyC70tam0K5Nrcxg74tUodRh0xjBQtY9xRZ8qEOUyl1iMTUC59/j+28Ww5rkQFtkyemx/XIPUGDwW1m/7urnbrvw64kns3jFU5b6oz+LYZrNm++rTSzw/V4KRW6sGhjhafr1LFhzsCuxt02PvTTHUNb6oF2KOgeMU5u/T/PgIKN65MjB28Yz1TvXh+GiE1V+Jo5QcxkDzz5DpW0S3OCnLNpdPjuKQxTPTEsnWKlN4a1vhk2+naxfQrD9b5dzPTNMAcMfwGcLUNS0ggAAA==";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.lettering.AddLetterForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JComboBox LetterListComboBox;
    protected javax.swing.JRadioButton listLetter;
    protected javax.swing.JRadioButton newLetter;
    protected javax.swing.JTextField newLetterTextField;
    protected javax.swing.JButton ok;
    protected jaxx.runtime.swing.JAXXButtonGroup radioButtons;
    protected java.lang.Boolean validOk;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AddLetterForm $JDialog0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            setValidOk(false);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AddLetterForm() {
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        performCancel();
    }

    public void doActionPerformed__on__ok(java.awt.event.ActionEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JComboBox getLetterListComboBox() {
        return LetterListComboBox;
    }

    public javax.swing.JRadioButton getListLetter() {
        return listLetter;
    }

    public javax.swing.JRadioButton getNewLetter() {
        return newLetter;
    }

    public javax.swing.JTextField getNewLetterTextField() {
        return newLetterTextField;
    }

    public javax.swing.JButton getOk() {
        return ok;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getRadioButtons() {
        return radioButtons;
    }

    public java.lang.Boolean getValidOk() {
        return validOk;
    }

    public java.lang.Boolean isValidOk() {
        return validOk !=null && validOk;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setLetterListComboBox(javax.swing.JComboBox newValue) {
        javax.swing.JComboBox oldValue = this.LetterListComboBox;
        this.LetterListComboBox = newValue;
        firePropertyChange(PROPERTY_LETTER_LIST_COMBO_BOX, oldValue, newValue);
    }

    public void setRadioButtons(jaxx.runtime.swing.JAXXButtonGroup newValue) {
        jaxx.runtime.swing.JAXXButtonGroup oldValue = this.radioButtons;
        this.radioButtons = newValue;
        firePropertyChange(PROPERTY_RADIO_BUTTONS, oldValue, newValue);
    }

    public void setValidOk(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.validOk;
        this.validOk = newValue;
        firePropertyChange(PROPERTY_VALID_OK, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createLetterListComboBox() {
        $objectMap.put("LetterListComboBox", LetterListComboBox = new LetterComboBox());
        
        LetterListComboBox.setName("LetterListComboBox");
    }

    protected void createListLetter() {
        $objectMap.put("listLetter", listLetter = new javax.swing.JRadioButton());
        
        listLetter.setName("listLetter");
        listLetter.setSelected(true);
        listLetter.setText(_("lima.entries.lettering.radiobutton.list"));
    }

    protected void createNewLetter() {
        $objectMap.put("newLetter", newLetter = new javax.swing.JRadioButton());
        
        newLetter.setName("newLetter");
        newLetter.setSelected(true);
        newLetter.setText(_("lima.entries.lettering.radiobutton.new"));
    }

    protected void createNewLetterTextField() {
        $objectMap.put("newLetterTextField", newLetterTextField = new javax.swing.JTextField());
        
        newLetterTextField.setName("newLetterTextField");
        newLetterTextField.setColumns(15);
        newLetterTextField.setEditable(false);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new javax.swing.JButton());
        
        ok.setName("ok");
        ok.setText(_("lima.common.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createRadioButtons() {
        $objectMap.put("radioButtons", radioButtons = new JAXXButtonGroup());
    }

    protected void createValidOk() {
        $objectMap.put("validOk", validOk = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(newLetter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(newLetterTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(listLetter, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(LetterListComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        { newLetter.putClientProperty("$value", true);  Object $buttonGroup = newLetter.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { listLetter.putClientProperty("$value", false);  Object $buttonGroup = listLetter.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        createRadioButtons();
        createValidOk();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        createNewLetter();
        createNewLetterTextField();
        createListLetter();
        createLetterListComboBox();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createOk();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        
        getRootPane().setDefaultButton(ok);// registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NEW_LETTER_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { javax.swing.ButtonGroup $buttonGroup = getRadioButtons(); newLetter.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(newLetter); }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_LETTER_TEXT_FIELD_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (newLetter != null) {
                    $bindingSources.put("newLetter.getModel()", newLetter.getModel());
                    newLetter.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    newLetter.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.lettering.AddLetterForm.this, BINDING_NEW_LETTER_TEXT_FIELD_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newLetter != null) {
                    newLetterTextField.setVisible(newLetter.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newLetter != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("newLetter.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    newLetter.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.lettering.AddLetterForm.this, BINDING_NEW_LETTER_TEXT_FIELD_VISIBLE));
                }
            }
        
            public void $pr$u0(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_LETTER_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { javax.swing.ButtonGroup $buttonGroup = getRadioButtons(); listLetter.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(listLetter); }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LETTER_LIST_COMBO_BOX_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (listLetter != null) {
                    $bindingSources.put("listLetter.getModel()", listLetter.getModel());
                    listLetter.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    listLetter.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.lettering.AddLetterForm.this, BINDING_LETTER_LIST_COMBO_BOX_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (listLetter != null) {
                    LetterListComboBox.setVisible(listLetter.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (listLetter != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("listLetter.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    listLetter.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.lettering.AddLetterForm.this, BINDING_LETTER_LIST_COMBO_BOX_VISIBLE));
                }
            }
        
            public void $pr$u1(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
    }

}