/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialTransactionsPane.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.2/lima-swing/src/main/java/org/chorem/lima/ui/home/FinancialTransactionsPane.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.home;

import static org.nuiton.i18n.I18n._;
import java.awt.Color;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;

public class FinancialTransactionsPane extends JEditorPane implements HyperlinkListener, ServiceListener {

    private static final long serialVersionUID = 1L;
    
    private static final Log log = LogFactory.getLog(FinancialTransactionsPane.class);
    
    protected HomeView view;
    
    protected FinancialTransactionServiceMonitorable financialTransactionService;
    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
    
    private static Color redBackground = new Color(0xff, 0xee, 0xee);
    private static Color greenBackground = new Color(0xee, 0xff, 0xee);
    
    public FinancialTransactionsPane(HomeView view) {
        this.view = view;
        
        financialTransactionService =
            LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class);
        financialTransactionService.addListener(this);
        fiscalPeriodService =
            LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class);
        fiscalPeriodService.addListener(this);
        LimaServiceFactory.getInstance().getService(
                ImportServiceMonitorable.class).addListener(this);
        
        //init
        setOpaque(true);
        setContentType("text/html");
        setEditable(false);
        setUI(new BasicEditorPaneUI());
        addHyperlinkListener(this);
        refresh();
        }
    
    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            
            if (e.getDescription().equals("#financialtransactionunbalanced")) {
                MainView ui = LimaContext.MAIN_UI_ENTRY_DEF.getContextValue(view);
                ui.getHandler().showTransactionUnbalancedView(ui);
            }
            else if (e.getDescription().equals("#financialtransactionbalanced")) {
                MainView ui = LimaContext.MAIN_UI_ENTRY_DEF.getContextValue(view);
                ui.getHandler().showTransactionView(ui);
            }
        }        
    }

public void refresh(){
        
        String htmlBegin = "<font face='sans-serif' size=3>"
            + "<p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";
        
        try {
            
            List<FiscalPeriod> unblockedFiscalPeriods =
                fiscalPeriodService.getAllUnblockedFiscalPeriods();
            if (unblockedFiscalPeriods.size() != 0){
                List<FinancialTransaction> financialTransactionsUnbal =
                    financialTransactionService.
                    getAllInexactFinancialTransactions(unblockedFiscalPeriods.get(0));
                if (financialTransactionsUnbal.size()>0){
                    setBackground(redBackground);
                    String transactionsString = financialTransactionsUnbal.size()
                    + " " + _("lima.home.transaction.unbalanced")
                    + "<br/><br/><a href='#financialtransactionunbalanced'>"
                    + _("lima.home.transaction.modifiy.unbalanced") + "</a>";
                    //set Text
                    setText(htmlBegin + transactionsString + htmlEnd);
                }
                else {
                    List<FinancialTransaction> financialTransactionsBal =
                        financialTransactionService.getAllFinancialTransactionsBalanced(unblockedFiscalPeriods.get(0));
                    
                    if (financialTransactionsBal.size()>0){
                        setBackground(greenBackground);
                        String transactionsString = financialTransactionsBal.size()
                        + " " + _("lima.home.transaction.balanced")
                        + "<br/><br/><a href='#financialtransactionbalanced'>"
                        + _("lima.home.transaction.modifiy.balanced") + "</a>";
                        //set Text
                        setText(htmlBegin + transactionsString + htmlEnd);
                    }
                    else {
                        setBackground(redBackground);
                        String transactionsString = _("lima.home.transaction.nothing")
                        + "<br/><br/><a href='#financialtransactionbalanced'>"
                        + _("lima.home.transaction.create") + "</a>";
                        //set Text
                        setText(htmlBegin + transactionsString + htmlEnd);
                    }

                }
            }
            else {
                setBackground(redBackground);
            }
            
        } catch (LimaException eee) {
            log.debug("Can't get datas account editor pane home", eee);
        }
    }
    
    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("FiscalPeriod") || methodeName.contains("FinancialTransaction")
                || methodeName.contains("Entry") || methodeName.contains("importEntries")
                || methodeName.contains("importAll") || methodeName.contains("importAs")){
            refresh();
        }        
    }

}
