/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.balance;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.ComboBoxDatesEnum;
import org.chorem.lima.ui.balance.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class BalanceView extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_PERIOD_COMBO_BOX = "periodComboBox";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS28URxBub1jb60fAGIx5JDKwcCHMAsklshUc26zMagHLY1lW9kLPTMvTpmd60tPDTnJA/IT8hOTOBYlbTlEOOeeQS5S/EEU55Bqluue14x1nLdaSd+2u+r76qqq76s2fqB4KdP0Ix7EhIl9SjxidLw8OnllHxJZbJLQFDSQXKPmZqKFaD806+Xko0c1eV8FbKby1yb2A+8QfQK920Uwov2EkdAmREn1URthh2DJz82ocRCJjzUVVsX7/91+175zXP9QQigNQdwlSWRmFKjI500U16kh0HiK9xC2G/UOQIah/CHrn1dkmw2H4FHvka/QKTXXRZIAFkEl04/Qpaw6NjwOJppp72GLknkS3uTg0bJcL4hmMetiIqGFhEGETYyP53qekHwQaPAlQF/sOI0Kiu6eDbif+BcNsSBh0lTi7vC/RgsrQUFkbG5wzgv3Cc8HjDmEpl1Ys0Sejo2rPJwpaUC02TV2Sxz6VFDP6LREqe90mG+pGQaKRVM0Y8hzIPincfYmWSx0O+9AvQ9uUZyMHfBgQQbkDrbH4Bo8luqjyjVNAJztX3ss56EozzWRHg02Che3uYJ8w0Pzp6AIMwcr0081OF1ua7HxJjT4t659PqduUSdX0pRJgj8SyTQlzyqCZ5ha3Iw9uIoS4PIiQADAyY1HWsx5/qU6Ik8U5ViaX2C/SMg3UNiN65FC46xI1K3pCtM145Ede4nYsv2YH2s0ZU3UCtZdKcQtTGTVnle7kVdWSIxhHLyQPEmxsdA7y63AvB15odmkoTf0AKPf1JYWoHw9GHfYYun8P1L9Xypqyrt5X/99UH5/ntnPY45GaCxaVeZOP+WT4BxW2hQS/KVQ1TyKYCTlzyEnWVIJZ6SPQ1VLrYBQbxSguZuVED9VFBMfw/nrD03sXTMncXj42txWhtv67tPjbj3+8a2fDeh5iX6x0Hdg1MEQDweElS6pCn00mdSQpaz3BwWoPNZKRphfRtQphZmoGcRAvGXkKbmzj0AWK+tTvP/289PzXD1CtjWYYx04bK//HqCFdAVWAqsXBw3WtaK4/DZ/nlDaJzqgXBe94jfqM+mQFS1gdViTJFzGU4VpFGXItVuOXfxbNt+tZKSZA2uUT3Yty1L9Ck0k0vbnSpVS5qWaDkEQOL5ZP1TqaUN83gvSSd/XnTlWusx71qRd5JsxkeP1rDpZ4xaK+A68G0lW4PZ2H+mtf0946Da2EvbNHAzXMlJP5/lTT2Wr7H547I3nU8e5YDDBobM4iz9/kvoQRtk9Dms6iEzg/OwXnnEsPXQa/MKG1V+/9uep6tY9J0hC8v02UoDEzmw8H5+1YqkY1b21shvWxGbaA4T/y5j03dAsAAA==";
    public static final String PROPERTY$BALANCE_PERIOD_SEARCH_PANEL0 = "$BalancePeriodSearchPanel0";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.balance.BalanceView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.editor.EnumEditor DocumentEditor;
    protected javax.swing.JLabel amountCreditLabel;
    protected javax.swing.JLabel amountDebitLabel;
    protected javax.swing.JLabel amountSoldeLabel;
    protected javax.swing.JTextField balanceFilter;
    protected org.jdesktop.swingx.JXTable balanceTable;
    protected org.chorem.lima.ui.balance.BalanceViewHandler handler;
    protected org.chorem.lima.ui.balance.BalanceTableModel modelBalanceTable;
    protected javax.swing.JCheckBox movmentedFilter;
    protected javax.swing.JComboBox periodComboBox;
    protected java.lang.Boolean selectedRow;
    protected javax.swing.JLabel soldeLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BalanceView $Table0 = this;
    private jaxx.runtime.swing.Table $Table1;
    private org.chorem.lima.ui.balance.BalancePeriodSearchPanel $BalancePeriodSearchPanel0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.text.Document $Document0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.ListSelectionModel $ListSelectionModel0;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    BalancePeriodSearchPanel periodSearchPanel;
    
        
        void $afterCompleteSetup() {
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BalanceView() {
        $initialize();
    }

    public BalanceView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__DocumentEditor(java.awt.event.ActionEvent event) {
        getHandler().createDocument();
    }

    public void doActionPerformed__on__movmentedFilter(java.awt.event.ActionEvent event) {
        getHandler().refresh();
    }

    public void doActionPerformed__on__periodComboBox(java.awt.event.ActionEvent event) {
        periodSearchPanel.refresh(ComboBoxDatesEnum.valueOfDescription((String) periodComboBox.getSelectedItem()));                     validate(); repaint();
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        handler.setAccountFilter(balanceFilter.getText());
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        handler.setAccountFilter(balanceFilter.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JLabel getAmountCreditLabel() {
        return amountCreditLabel;
    }

    public javax.swing.JLabel getAmountDebitLabel() {
        return amountDebitLabel;
    }

    public javax.swing.JLabel getAmountSoldeLabel() {
        return amountSoldeLabel;
    }

    public javax.swing.JTextField getBalanceFilter() {
        return balanceFilter;
    }

    public org.jdesktop.swingx.JXTable getBalanceTable() {
        return balanceTable;
    }

    public jaxx.runtime.swing.editor.EnumEditor getDocumentEditor() {
        return DocumentEditor;
    }

    public org.chorem.lima.ui.balance.BalanceViewHandler getHandler() {
        return handler;
    }

    public org.chorem.lima.ui.balance.BalanceTableModel getModelBalanceTable() {
        return modelBalanceTable;
    }

    public javax.swing.JCheckBox getMovmentedFilter() {
        return movmentedFilter;
    }

    public javax.swing.JComboBox getPeriodComboBox() {
        return periodComboBox;
    }

    public java.lang.Boolean getSelectedRow() {
        return selectedRow;
    }

    public javax.swing.JLabel getSoldeLabel() {
        return soldeLabel;
    }

    public java.lang.Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$BalancePeriodSearchPanel0(org.chorem.lima.ui.balance.BalancePeriodSearchPanel newValue) {
        org.chorem.lima.ui.balance.BalancePeriodSearchPanel oldValue = this.$BalancePeriodSearchPanel0;
        this.$BalancePeriodSearchPanel0 = newValue;
        firePropertyChange(PROPERTY$BALANCE_PERIOD_SEARCH_PANEL0, oldValue, newValue);
    }

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void set$ListSelectionModel0(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = newValue;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, newValue);
    }

    public void setHandler(org.chorem.lima.ui.balance.BalanceViewHandler newValue) {
        org.chorem.lima.ui.balance.BalanceViewHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setPeriodComboBox(javax.swing.JComboBox newValue) {
        javax.swing.JComboBox oldValue = this.periodComboBox;
        this.periodComboBox = newValue;
        firePropertyChange(PROPERTY_PERIOD_COMBO_BOX, oldValue, newValue);
    }

    public void setSelectedRow(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selectedRow;
        this.selectedRow = newValue;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected org.chorem.lima.ui.balance.BalancePeriodSearchPanel get$BalancePeriodSearchPanel0() {
        return $BalancePeriodSearchPanel0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAmountCreditLabel() {
        $objectMap.put("amountCreditLabel", amountCreditLabel = new javax.swing.JLabel());
        
        amountCreditLabel.setName("amountCreditLabel");
    }

    protected void createAmountDebitLabel() {
        $objectMap.put("amountDebitLabel", amountDebitLabel = new javax.swing.JLabel());
        
        amountDebitLabel.setName("amountDebitLabel");
    }

    protected void createAmountSoldeLabel() {
        $objectMap.put("amountSoldeLabel", amountSoldeLabel = new javax.swing.JLabel());
        
        amountSoldeLabel.setName("amountSoldeLabel");
    }

    protected void createBalanceFilter() {
        $objectMap.put("balanceFilter", balanceFilter = new javax.swing.JTextField());
        
        balanceFilter.setName("balanceFilter");
        balanceFilter.setColumns(15);
        balanceFilter.setToolTipText(_("lima.tooltip.filter"));
    }

    protected void createBalanceTable() {
        $objectMap.put("balanceTable", balanceTable = new org.jdesktop.swingx.JXTable());
        
        balanceTable.setName("balanceTable");
        balanceTable.setColumnControlVisible(true);
        balanceTable.setRowHeight(24);
    }

    protected void createDocumentEditor() {
        $objectMap.put("DocumentEditor", DocumentEditor = new jaxx.runtime.swing.editor.EnumEditor(org.chorem.lima.business.utils.FormatsEnum.class));
        
        DocumentEditor.setName("DocumentEditor");
        DocumentEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__DocumentEditor"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new BalanceViewHandler(this));
    }

    protected void createModelBalanceTable() {
        $objectMap.put("modelBalanceTable", modelBalanceTable = new org.chorem.lima.ui.balance.BalanceTableModel());
    }

    protected void createMovmentedFilter() {
        $objectMap.put("movmentedFilter", movmentedFilter = new javax.swing.JCheckBox());
        
        movmentedFilter.setName("movmentedFilter");
        movmentedFilter.setSelected(false);
        movmentedFilter.setText(_("lima.common.movmentedfilter"));
        movmentedFilter.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__movmentedFilter"));
    }

    protected void createPeriodComboBox() {
        $objectMap.put("periodComboBox", periodComboBox = new JComboBox(ComboBoxDatesEnum.descriptions()));
        
        periodComboBox.setName("periodComboBox");
        periodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__periodComboBox"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createSoldeLabel() {
        $objectMap.put("soldeLabel", soldeLabel = new javax.swing.JLabel());
        
        soldeLabel.setName("soldeLabel");
        soldeLabel.setText(_("lima.common.solde"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(balanceFilter, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(movmentedFilter, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(DocumentEditor, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 8, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table2, new GridBagConstraints(0, 2, 7, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(periodComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($BalancePeriodSearchPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(balanceTable);
        // inline complete setup of $Table2
        $Table2.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountDebitLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountCreditLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(soldeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountSoldeLabel, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 property setters
        balanceFilter.setMinimumSize(balanceFilter.getPreferredSize());
        balanceTable.setHighlighters(org.jdesktop.swingx.decorator.HighlighterFactory.createSimpleStriping(new java.awt.Color(222,222,222)));
        balanceTable.setModel(getModelBalanceTable());
        balanceTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createSelectedRow();
        createModelBalanceTable();
        periodSearchPanel = new BalancePeriodSearchPanel(handler);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        createPeriodComboBox();
        // inline creation of $BalancePeriodSearchPanel0
        $objectMap.put("$BalancePeriodSearchPanel0", $BalancePeriodSearchPanel0 = periodSearchPanel);
        
        $BalancePeriodSearchPanel0.setName("$BalancePeriodSearchPanel0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.filter"));
        createBalanceFilter();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = balanceFilter.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createMovmentedFilter();
        createDocumentEditor();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createBalanceTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getBalanceTable().getSelectionModel());
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.amountdebit"));
        createAmountDebitLabel();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("lima.common.amountcredit"));
        createAmountCreditLabel();
        createSoldeLabel();
        createAmountSoldeLabel();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}