/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.net.URL;
import java.util.Locale;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.account.AccountView;
import org.chorem.lima.ui.accountsreports.AccountsReportsView;
import org.chorem.lima.ui.balance.BalanceView;
import org.chorem.lima.ui.entrybook.EntryBookView;
import org.chorem.lima.ui.entrybooksreports.EntryBooksReportsView;
import org.chorem.lima.ui.financialperiod.FinancialPeriodView;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartView;
import org.chorem.lima.ui.financialstatementreport.FinancialStatementReportView;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionView;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchView;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedView;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodView;
import org.chorem.lima.ui.home.HomeView;
import org.chorem.lima.ui.identity.IdentityForm;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.ui.ledger.LedgerView;
import org.chorem.lima.ui.lettering.LetteringView;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;

public class MainViewHandler {
    private static Log log = LogFactory.getLog(MainViewHandler.class);

    public MainView initUI(LimaContext rootContext, boolean fullscreen) {
        MainView ui = new MainView((JAXXContext)rootContext);
        LimaContext.MAIN_UI_ENTRY_DEF.setContextValue((JAXXContext)rootContext, (Object)ui);
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(fullscreen ? ui : null);
        return ui;
    }

    public void changeLanguage(MainView mainUI, Locale newLocale) {
        LimaConfig config = mainUI.getConfig();
        config.setLocale(newLocale);
        LimaContext.get().initI18n();
        this.reloadUI(LimaContext.get(), config.isFullScreen());
    }

    public void close(MainView ui) {
        boolean canContinue;
        if (log.isInfoEnabled()) {
            log.info((Object)"Lima quitting...");
        }
        if (!(canContinue = this.ensureModification((JAXXContext)ui))) {
            return;
        }
        try {
            LimaContext.get().close();
            Runtime.getRuntime().halt(0);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
            }
            Runtime.getRuntime().halt(1);
        }
    }

    public void changeScreen(MainView ui, boolean fullscreen) {
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ui.getConfig().setFullscreen(fullscreen);
        this.reloadUI(LimaContext.get(), fullscreen);
    }

    public void showConfig(JAXXContext context) {
        MainView ui = this.getUI(context);
        LimaConfig config = (LimaConfig)((Object)context.getContextValue(LimaConfig.class));
        ConfigUIHelper helper = new ConfigUIHelper((ApplicationConfig)config);
        helper.addCategory(I18n._((String)"lima.config.category.directories"), I18n._((String)"lima.config.category.directories.description"));
        helper.addOption((ApplicationConfig.OptionDef)LimaConfig.Option.CONFIG_FILE);
        helper.addCategory(I18n._((String)"lima.config.category.other"), I18n._((String)"lima.config.category.other.description"));
        helper.addOption((ApplicationConfig.OptionDef)LimaConfig.Option.FULL_SCREEN);
        helper.addOption((ApplicationConfig.OptionDef)LimaConfig.Option.LOCALE);
        helper.buildUI(context, I18n._((String)"lima.config.category.directories"));
        helper.displayUI((Frame)ui, false);
    }

    public void showHelp(JAXXContext context, String helpId) {
    }

    public void closeHelp(JAXXContext context) {
    }

    public void gotoSite(JAXXContext rootContext) {
        LimaConfig config = (LimaConfig)((Object)rootContext.getContextValue(LimaConfig.class));
        URL siteURL = config.getOptionAsURL("application.site.url");
        log.info((Object)("goto " + siteURL));
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.error((Object)"Can't open lima website", (Throwable)ex);
                }
                ErrorHelper.showErrorDialog("Can't open lima website", ex);
            }
        }
    }

    public void showAbout(MainView ui) {
        AboutPanel about = new AboutPanel();
        about.setTitle(I18n._((String)"lima.title.about"));
        about.setAboutText(I18n._((String)"lima.title.about.description"));
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setIconPath("/icons/lima.png");
        about.setLicenseFile("META-INF/lima-main-LICENSE.txt");
        about.setThirdpartyFile("META-INF/lima-main-THIRD-PARTY.txt");
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    protected void reloadUI(LimaContext rootContext, boolean fullscreen) {
        ((LimaConfig)((Object)rootContext.getContextValue(LimaConfig.class))).removeJaxxPropertyChangeListener();
        MainView ui = this.getUI((JAXXContext)rootContext);
        if (ui != null) {
            LimaContext.MAIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)rootContext);
            ui.dispose();
            ui.setVisible(false);
        }
        ui = this.initUI(rootContext, fullscreen);
        ui.setVisible(true);
    }

    protected boolean ensureModification(JAXXContext rootContext) throws IllegalArgumentException {
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        MainView ui = this.getUI(rootContext);
        if (ui == null) {
            return true;
        }
        return true;
    }

    protected MainView getUI(JAXXContext context) {
        if (context instanceof MainView) {
            return (MainView)context;
        }
        MainView ui = (MainView)LimaContext.MAIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public void showHomeView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        HomeView homeView = new HomeView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.tab.home"), (Component)((Object)homeView), false);
    }

    public void showIdentity(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        IdentityForm identityForm = new IdentityForm();
        identityForm.setLocationRelativeTo(mainView);
        identityForm.setVisible(true);
    }

    public void showAccountView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        AccountView accountView = new AccountView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.charts.account"), (Component)((Object)accountView));
    }

    public void showEntryBookView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        EntryBookView entryBookView = new EntryBookView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.common.entrybooks"), (Component)((Object)entryBookView));
    }

    public void showFiscalPeriodView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FiscalPeriodView fiscalPeriodView = new FiscalPeriodView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.charts.fiscalyear"), (Component)((Object)fiscalPeriodView));
    }

    public void showFinancialPeriodView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialPeriodView financialPeriodView = new FinancialPeriodView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.charts.financialperiod"), (Component)((Object)financialPeriodView));
    }

    public void showFinancialStatementView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialStatementChartView financialStatementView = new FinancialStatementChartView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.charts.financialstatement"), (Component)((Object)financialStatementView));
    }

    public void showAccountReports(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        AccountsReportsView accountsReportsView = new AccountsReportsView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.reports.accounts"), (Component)((Object)accountsReportsView));
    }

    public void showEntryBookReports(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        EntryBooksReportsView entryBooksReportsView = new EntryBooksReportsView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.reports.entrybooks"), (Component)((Object)entryBooksReportsView));
    }

    public void showTransactionView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialTransactionView transactionView = new FinancialTransactionView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.entries.writetransaction"), (Component)((Object)transactionView));
    }

    public void showTransactionUnbalancedView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialTransactionUnbalancedView searchResultView = new FinancialTransactionUnbalancedView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.entries.searchunbalancedtransaction"), (Component)((Object)searchResultView));
    }

    public void showTransactionSearchView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialTransactionSearchView searchView = new FinancialTransactionSearchView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.entries.searchtransaction"), (Component)((Object)searchView));
    }

    public void showLetteringView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        LetteringView letteringView = new LetteringView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.entries.lettering"), (Component)((Object)letteringView));
    }

    public void showBalanceView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        BalanceView balanceView = new BalanceView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.reports.balance"), (Component)((Object)balanceView));
    }

    public void showLedgerView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        LedgerView ledgerView = new LedgerView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.reports.ledger"), (Component)((Object)ledgerView));
    }

    public void showFinancialStatementReportsView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialStatementReportView financialStatementReportView = new FinancialStatementReportView((JAXXContext)mainView);
        mainView.showTab(I18n._((String)"lima.reports.financialstatement"), (Component)((Object)financialStatementReportView));
    }

    public void showImportExportView(JAXXContext rootContext, ImportExportEnum type) {
        MainView mainView = this.getUI(rootContext);
        ImportExport importExport = ImportExport.getInstance(mainView);
        importExport.importExport(type, "", true);
    }
}

