/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.service.neogia;

import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.AccountDTO;
import org.chorem.lima.dto.EntryDTO;
import org.chorem.lima.dto.StatusDTO;
import org.chorem.lima.dto.TransactionDTO;
import org.chorem.lima.dto.util.DTOHelper;
import org.chorem.lima.service.EntryService;
import org.chorem.lima.service.neogia.AddEntryStub;
import org.chorem.lima.service.neogia.GetEntryByTransactionStub;
import org.chorem.lima.service.neogia.RemoveEntryStub;
import org.chorem.lima.service.neogia.UpdateEntryStub;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.chorem.lima.service.util.ServiceHelper;
import org.ofbiz.webservice.proxies.AddEntryDocument;
import org.ofbiz.webservice.proxies.AddEntryResponseDocument;
import org.ofbiz.webservice.proxies.GetEntryByTransactionDocument;
import org.ofbiz.webservice.proxies.GetEntryByTransactionResponseDocument;
import org.ofbiz.webservice.proxies.RemoveEntryDocument;
import org.ofbiz.webservice.proxies.RemoveEntryResponseDocument;
import org.ofbiz.webservice.proxies.UpdateEntryDocument;
import org.ofbiz.webservice.proxies.UpdateEntryResponseDocument;
import org.ofbiz.webservice.wrappers.xsd.AddEntryResult;
import org.ofbiz.webservice.wrappers.xsd.GenericValueGlEntry;
import org.ofbiz.webservice.wrappers.xsd.GenericValueGlEntryAndGlEntryAccount;

public class NeogiaEntryService
implements EntryService {
    protected static final Log log = LogFactory.getLog(NeogiaEntryService.class);
    private final String DEBIT = "DEBIT";
    private final String CREDIT = "CREDIT";

    public List<EntryDTO> getAllEntry() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<EntryDTO> getEntryByTransaction(TransactionDTO trans, List<AccountDTO> accounts) {
        LinkedList<EntryDTO> list = new LinkedList<EntryDTO>();
        try {
            GenericValueGlEntryAndGlEntryAccount[] array;
            GetEntryByTransactionStub stub = new GetEntryByTransactionStub();
            GetEntryByTransactionDocument document = GetEntryByTransactionDocument.Factory.newInstance();
            GetEntryByTransactionDocument.GetEntryByTransaction element = GetEntryByTransactionDocument.GetEntryByTransaction.Factory.newInstance();
            element.setIdSeq(trans.getIdSeq());
            element.setIdName(trans.getIdName());
            document.setGetEntryByTransaction(element);
            GetEntryByTransactionResponseDocument response = stub.getEntryByTransaction(document);
            for (GenericValueGlEntryAndGlEntryAccount value : array = response.getGetEntryByTransactionResponse().getReturnArray()) {
                EntryDTO entry = NeogiaUtil.mapToEntryDTO(value, accounts);
                list.add(entry);
            }
        }
        catch (RemoteException e) {
            log.error((Object)e);
        }
        return list;
    }

    public String removeEntry(List<StatusDTO> list, EntryDTO entry) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeEntry : ");
        }
        try {
            RemoveEntryStub stub = new RemoveEntryStub();
            RemoveEntryDocument document = RemoveEntryDocument.Factory.newInstance();
            RemoveEntryDocument.RemoveEntry element = RemoveEntryDocument.RemoveEntry.Factory.newInstance();
            element.setTrItAtranIdName(entry.getTransaction().getIdName());
            element.setTrItSequenceId(entry.getTransaction().getIdSeq());
            element.setSequenceId(Long.parseLong(entry.getIdSeq()));
            document.setRemoveEntry(element);
            RemoveEntryResponseDocument response = stub.removeEntry(document);
            if (list != null) {
                String status = response.getRemoveEntryResponse().getReturn();
                entry.getTransaction().setStatus(ServiceHelper.findStatusById(list, (String)status));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("entry " + entry.getDescription() + " removed"));
            }
            return "success";
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            return "error";
        }
    }

    public String updateEntry(List<StatusDTO> list, EntryDTO entry) {
        try {
            UpdateEntryStub stub = new UpdateEntryStub();
            UpdateEntryDocument document = UpdateEntryDocument.Factory.newInstance();
            UpdateEntryDocument.UpdateEntry element = UpdateEntryDocument.UpdateEntry.Factory.newInstance();
            element.setTrItAtranIdName(entry.getTransaction().getIdName());
            element.setTrItSequenceId(entry.getTransaction().getIdSeq());
            element.setSequenceId(Long.parseLong(entry.getIdSeq()));
            element.setAmount(DTOHelper.parse((String)entry.getAmount()));
            if (DTOHelper.hasAccount((EntryDTO)entry)) {
                element.setAccountAccount(entry.getAccount().getIdNumber());
            }
            if (!DTOHelper.isEmpty((Object)entry.getDescription())) {
                element.setDescription(entry.getDescription());
            }
            element.setDebitCreditEnumId(DTOHelper.isCredit((EntryDTO)entry) ? "CREDIT" : "DEBIT");
            document.setUpdateEntry(element);
            UpdateEntryResponseDocument response = stub.updateEntry(document);
            if (list != null) {
                String status = response.getUpdateEntryResponse().getReturn();
                entry.getTransaction().setStatus(ServiceHelper.findStatusById(list, (String)status));
            }
            return "success";
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            return "error";
        }
    }

    public String addEntry(List<StatusDTO> list, EntryDTO entry) {
        try {
            AddEntryStub stub = new AddEntryStub();
            AddEntryDocument document = AddEntryDocument.Factory.newInstance();
            AddEntryDocument.AddEntry element = AddEntryDocument.AddEntry.Factory.newInstance();
            element.setTrItAtranIdName(entry.getTransaction().getIdName());
            element.setTrItSequenceId(entry.getTransaction().getIdSeq());
            element.setAmount(DTOHelper.parse((String)entry.getAmount()));
            element.setDebitCreditEnumId(DTOHelper.isCredit((EntryDTO)entry) ? "CREDIT" : "DEBIT");
            if (DTOHelper.hasAccount((EntryDTO)entry)) {
                element.setAccountAccount(entry.getAccount().getIdNumber());
            }
            if (!DTOHelper.isEmpty((Object)entry.getDescription())) {
                element.setDescription(entry.getDescription());
            }
            document.setAddEntry(element);
            AddEntryResponseDocument response = stub.addEntry(document);
            AddEntryResult result = response.getAddEntryResponse().getReturn();
            GenericValueGlEntry value = result.getValue();
            String status = result.getStatus();
            entry.setIdSeq(Long.toString(value.getSequenceId()));
            entry.getTransaction().setStatus(ServiceHelper.findStatusById(list, (String)status));
            return "success";
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            return "error";
        }
    }
}

