/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité Period.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class PeriodDAOAbstract<E extends Period> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)Period.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.callao.entity.TimeSpan> list = getContext()
                            .getDAO(org.chorem.callao.entity.TimeSpan.class)
                            .findAllByProperties("period", entity);
                    for (org.chorem.callao.entity.TimeSpan item : list) {
                        item.setPeriod(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut beginPeriod
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * beginPeriod le paramètre
     * @param v la valeur que doit avoir beginPeriod
     * @return un element ou null
     */
    public E findByBeginPeriod(java.util.Date v) throws TopiaException {
        E result = findByProperty("beginPeriod", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * beginPeriod le paramètre
     * @param v la valeur que doit avoir beginPeriod
     * @return une liste
     */
    public List<E> findAllByBeginPeriod(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("beginPeriod", v);
        return result;
    }
    /**
     * Recherche sur l'attribut endPeriod
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * endPeriod le paramètre
     * @param v la valeur que doit avoir endPeriod
     * @return un element ou null
     */
    public E findByEndPeriod(java.util.Date v) throws TopiaException {
        E result = findByProperty("endPeriod", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * endPeriod le paramètre
     * @param v la valeur que doit avoir endPeriod
     * @return une liste
     */
    public List<E> findAllByEndPeriod(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("endPeriod", v);
        return result;
    }
    /**
     * Recherche sur l'attribut locked
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * locked le paramètre
     * @param v la valeur que doit avoir locked
     * @return un element ou null
     */
    public E findByLocked(boolean v) throws TopiaException {
        E result = findByProperty("locked", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * locked le paramètre
     * @param v la valeur que doit avoir locked
     * @return une liste
     */
    public List<E> findAllByLocked(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("locked", v);
        return result;
    }
    /**
     * Recherche sur l'attribut timeSpan
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * timeSpan contient le paramètre
     * @param v la valeur que doit contenir timeSpan
     * @return un element ou null
     */
    public E findContainsTimeSpan(org.chorem.callao.entity.TimeSpan ... v) throws TopiaException {
        E result = findContainsProperties("timeSpan", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * timeSpan contient le paramètre
     * @param v la valeur que doit contenir timeSpan
     * @return une liste
     */
    public List<E> findAllContainsTimeSpan(org.chorem.callao.entity.TimeSpan ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("timeSpan", Arrays.asList(v));
        return results;
    }

} // PeriodDAOAbstract
