/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import java.text.DecimalFormat;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TYERTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iYear;

    public TYERTextInformationID3V2Frame(int iYear) throws ID3Exception {
        super(Integer.toString(iYear));
        if (iYear < 0 || iYear > 9999) {
            throw new ID3Exception("Year value must be between 0 and 9999.");
        }
        this.m_iYear = iYear;
    }

    public TYERTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            this.m_iYear = Integer.parseInt(this.m_sInformation);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered a corrupt TYER year frame.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTYERTextInformationID3V2Frame(this);
    }

    public void setYear(int iYear) throws ID3Exception {
        if (iYear < 0 || iYear > 9999) {
            throw new ID3Exception("Year in TYER tag must be between 0 and 9999.");
        }
        this.m_iYear = iYear;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = TYERTextInformationID3V2Frame.getYearString(iYear);
    }

    public int getYear() {
        return this.m_iYear;
    }

    protected byte[] getFrameId() {
        return "TYER".getBytes();
    }

    public String toString() {
        return "Year: [" + this.m_sInformation + "]";
    }

    private static String getYearString(int iYear) {
        DecimalFormat oNF = new DecimalFormat("0000");
        return oNF.format(iYear);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TYERTextInformationID3V2Frame)) {
            return false;
        }
        TYERTextInformationID3V2Frame oOtherTYER = (TYERTextInformationID3V2Frame)oOther;
        return this.m_iYear == oOtherTYER.m_iYear && this.m_oTextEncoding.equals(oOtherTYER.m_oTextEncoding) && this.m_sInformation.equals(oOtherTYER.m_sInformation);
    }
}

