/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import java.text.DecimalFormat;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TDATTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iDay;
    private int m_iMonth;

    public TDATTextInformationID3V2Frame(int iDay, int iMonth) throws ID3Exception {
        if (!this.checkDayMonthValidity(iDay, iMonth)) {
            throw new ID3Exception("Invalid day/month combination " + iDay + "/" + iMonth + ".");
        }
        DecimalFormat oNF = new DecimalFormat("00");
        this.m_sInformation = oNF.format(iDay) + oNF.format(iMonth);
        this.m_iDay = iDay;
        this.m_iMonth = iMonth;
    }

    public TDATTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            String sDay = this.m_sInformation.substring(0, 2);
            this.m_iDay = Integer.parseInt(sDay);
            String sMonth = this.m_sInformation.substring(2, 4);
            this.m_iMonth = Integer.parseInt(sMonth);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered a corrupt TDAT recording date frame.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTDATTextInformationID3V2Frame(this);
    }

    protected byte[] getFrameId() {
        return "TDAT".getBytes();
    }

    public String toString() {
        return "Date (DDMM): [" + this.m_sInformation + "]";
    }

    public void setDate(int iDay, int iMonth) throws ID3Exception {
        if (!this.checkDayMonthValidity(iDay, iMonth)) {
            throw new ID3Exception("Invalid day/month combination " + iDay + "/" + iMonth + ".");
        }
        DecimalFormat oNF = new DecimalFormat("00");
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = oNF.format(iDay) + oNF.format(iMonth);
        this.m_iDay = iDay;
        this.m_iMonth = iMonth;
    }

    public int getDay() {
        return this.m_iDay;
    }

    public int getMonth() throws ID3Exception {
        return this.m_iMonth;
    }

    private boolean checkDayMonthValidity(int iDay, int iMonth) {
        return iDay >= 1 && (iMonth != 1 && iMonth != 3 && iMonth != 5 && iMonth != 7 && iMonth != 8 && iMonth != 10 && iMonth != 12 || iDay <= 31) && (iMonth != 4 && iMonth != 6 && iMonth != 9 && iMonth != 11 || iDay <= 30) && (iMonth != 2 || iDay <= 29);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TDATTextInformationID3V2Frame)) {
            return false;
        }
        TDATTextInformationID3V2Frame oOtherTDAT = (TDATTextInformationID3V2Frame)oOther;
        return this.m_iDay == oOtherTDAT.m_iDay && this.m_iMonth == oOtherTDAT.m_iMonth && this.m_oTextEncoding.equals(oOtherTDAT.m_oTextEncoding) && this.m_sInformation.equals(oOtherTDAT.m_sInformation);
    }
}

