/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class RBUFID3V2Frame
extends ID3V2Frame {
    private int m_i24BufferSize;
    private boolean m_bEmbeddedInfoFlag;
    private int m_iOffsetToNextTag;

    public RBUFID3V2Frame(int i24BufferSize, boolean bEmbeddedInfoFlag, int iOffsetToNextTag) throws ID3Exception {
        if (i24BufferSize < 0 || i24BufferSize > 0xFFFFFF) {
            throw new ID3Exception("Buffer size must be an unsigned 24-bit value in RBUF frame.");
        }
        this.m_i24BufferSize = i24BufferSize;
        this.m_bEmbeddedInfoFlag = bEmbeddedInfoFlag;
        if (iOffsetToNextTag < 0) {
            throw new ID3Exception("Offset to next tag cannot be negative in RBUF frame.");
        }
        this.m_iOffsetToNextTag = iOffsetToNextTag;
    }

    public RBUFID3V2Frame(int i24BufferSize, boolean bEmbeddedInfoFlag) throws ID3Exception {
        if (i24BufferSize < 0 || i24BufferSize > 0xFFFFFF) {
            throw new ID3Exception("Buffer size must be an unsigned 24-bit value in RBUF frame.");
        }
        this.m_i24BufferSize = i24BufferSize;
        this.m_bEmbeddedInfoFlag = bEmbeddedInfoFlag;
        this.m_iOffsetToNextTag = -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RBUFID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_i24BufferSize = oFrameDataID3DIS.readBE24();
            int iEmbeddedInfoFlag = oFrameDataID3DIS.readUnsignedByte();
            boolean bl = this.m_bEmbeddedInfoFlag = (iEmbeddedInfoFlag & 1) == 1;
            if (oFrameDataID3DIS.available() > 0) {
                if (oFrameDataID3DIS.available() != 4) throw new ID3Exception("RBUF frame data longer than expected.");
                this.m_iOffsetToNextTag = oFrameDataID3DIS.readBE32();
                return;
            } else {
                this.m_iOffsetToNextTag = -1;
            }
            return;
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitRBUFID3V2Frame(this);
    }

    public void setRecommendedBufferSize(int i24BufferSize, boolean bEmbeddedInfoFlag, int iOffsetToNextTag) throws ID3Exception {
        if (i24BufferSize < 0 || i24BufferSize > 0xFFFFFF) {
            throw new ID3Exception("Buffer size must be an unsigned 24-bit value in RBUF frame.");
        }
        this.m_i24BufferSize = i24BufferSize;
        this.m_bEmbeddedInfoFlag = bEmbeddedInfoFlag;
        if (iOffsetToNextTag < 0) {
            throw new ID3Exception("Offset to next tag cannot be negative in RBUF frame.");
        }
        this.m_iOffsetToNextTag = iOffsetToNextTag;
    }

    public void setRecommendedBufferSize(int i24BufferSize, boolean bEmbeddedInfoFlag) throws ID3Exception {
        if (i24BufferSize < 0 || i24BufferSize > 0xFFFFFF) {
            throw new ID3Exception("Buffer size must be an unsigned 24-bit value in RBUF frame.");
        }
        this.m_i24BufferSize = i24BufferSize;
        this.m_bEmbeddedInfoFlag = bEmbeddedInfoFlag;
        this.m_iOffsetToNextTag = -1;
    }

    public int getBufferSize() {
        return this.m_i24BufferSize;
    }

    public boolean getEmbeddedInfoFlag() {
        return this.m_bEmbeddedInfoFlag;
    }

    public int getOffsetToNextTag() {
        return this.m_iOffsetToNextTag;
    }

    protected byte[] getFrameId() {
        return "RBUF".getBytes();
    }

    public String toString() {
        return "Recommended buffer size: Buffer size=[" + this.m_i24BufferSize + "], Embedded info flag=" + this.m_bEmbeddedInfoFlag + "], Offset to next tag=[" + this.m_iOffsetToNextTag + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeBE24(this.m_i24BufferSize);
        oIDOS.writeUnsignedByte(this.m_bEmbeddedInfoFlag ? 1 : 0);
        if (this.m_iOffsetToNextTag >= 0) {
            oIDOS.writeBE32(this.m_iOffsetToNextTag);
        }
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof RBUFID3V2Frame)) {
            return false;
        }
        RBUFID3V2Frame oOtherRBUF = (RBUFID3V2Frame)oOther;
        return this.m_i24BufferSize == oOtherRBUF.m_i24BufferSize && this.m_bEmbeddedInfoFlag == oOtherRBUF.m_bEmbeddedInfoFlag && this.m_iOffsetToNextTag == oOtherRBUF.m_iOffsetToNextTag;
    }
}

