/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class POPMID3V2Frame
extends ID3V2Frame {
    private String m_sEmailToUser = null;
    private int m_iPopularity;
    private int m_iPlayCount;

    public POPMID3V2Frame(String sEmailToUser, int iPopularity, int iPlayCount) throws ID3Exception {
        if (sEmailToUser == null || sEmailToUser.length() == 0) {
            throw new ID3Exception("Email address is required in POPM frame.");
        }
        this.m_sEmailToUser = sEmailToUser;
        if (iPopularity < 0 || iPopularity > 255) {
            throw new ID3Exception("Popularity must be between 0 and 255 in POPM frame.");
        }
        this.m_iPopularity = iPopularity;
        if (iPlayCount < 0) {
            throw new ID3Exception("Play count cannot be negative in POPM frame.");
        }
        this.m_iPlayCount = iPlayCount;
    }

    public POPMID3V2Frame(String sEmailToUser, int iPopularity) throws ID3Exception {
        if (sEmailToUser == null || sEmailToUser.length() == 0) {
            throw new ID3Exception("Email address is required in POPM frame.");
        }
        this.m_sEmailToUser = sEmailToUser;
        if (iPopularity < 0 || iPopularity > 255) {
            throw new ID3Exception("Popularity must be between 0 and 255 in POPM frame.");
        }
        this.m_iPopularity = iPopularity;
        this.m_iPlayCount = -1;
    }

    public POPMID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_sEmailToUser = oFrameDataID3DIS.readStringToNull();
            this.m_iPopularity = oFrameDataID3DIS.readUnsignedByte();
            this.m_iPlayCount = oFrameDataID3DIS.available() > 0 ? (oFrameDataID3DIS.available() == 4 ? oFrameDataID3DIS.readBE32() : Integer.MAX_VALUE) : -1;
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitPOPMID3V2Frame(this);
    }

    public void setPopularity(String sEmailToUser, int iPopularity, int iPlayCount) throws ID3Exception {
        String sOrigEmailToUser = this.m_sEmailToUser;
        int iOrigPopularity = this.m_iPopularity;
        int iOrigPlayCount = this.m_iPlayCount;
        if (sEmailToUser == null || sEmailToUser.length() == 0) {
            throw new ID3Exception("Email address is required in POPM frame.");
        }
        if (iPopularity < 0 || iPopularity > 255) {
            throw new ID3Exception("Popularity must be between 0 and 255 in POPM frame.");
        }
        if (iPlayCount < 0) {
            throw new ID3Exception("Play count cannot be negative in POPM frame.");
        }
        this.m_sEmailToUser = sEmailToUser;
        this.m_iPopularity = iPopularity;
        this.m_iPlayCount = iPlayCount;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sEmailToUser = sOrigEmailToUser;
            this.m_iPopularity = iOrigPopularity;
            this.m_iPlayCount = iOrigPlayCount;
            throw e;
        }
    }

    public void setPopularity(String sEmailToUser, int iPopularity) throws ID3Exception {
        String sOrigEmailToUser = this.m_sEmailToUser;
        int iOrigPopularity = this.m_iPopularity;
        int iOrigPlayCount = this.m_iPlayCount;
        if (sEmailToUser == null || sEmailToUser.length() == 0) {
            throw new ID3Exception("Email address is required in POPM frame.");
        }
        if (iPopularity < 0 || iPopularity > 255) {
            throw new ID3Exception("Popularity must be between 0 and 255 in POPM frame.");
        }
        this.m_sEmailToUser = sEmailToUser;
        this.m_iPopularity = iPopularity;
        this.m_iPlayCount = -1;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sEmailToUser = sOrigEmailToUser;
            this.m_iPopularity = iOrigPopularity;
            this.m_iPlayCount = iOrigPlayCount;
            throw e;
        }
    }

    public String getEmailToUser() {
        return this.m_sEmailToUser;
    }

    public int getPopularity() {
        return this.m_iPopularity;
    }

    public int getPlayCount() {
        return this.m_iPlayCount;
    }

    protected byte[] getFrameId() {
        return "POPM".getBytes();
    }

    public String toString() {
        return "Popularimeter: Email To User=[" + this.m_sEmailToUser + "], Popularity=" + this.m_iPopularity + "], Play Count=[" + this.m_iPlayCount + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_sEmailToUser.getBytes());
        oIDOS.write(0);
        oIDOS.write(this.m_iPopularity);
        if (this.m_iPlayCount >= 0) {
            oIDOS.writeBE32(this.m_iPlayCount);
        }
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof POPMID3V2Frame)) {
            return false;
        }
        POPMID3V2Frame oOtherPOPM = (POPMID3V2Frame)oOther;
        return this.m_sEmailToUser.equals(oOtherPOPM.m_sEmailToUser) && this.m_iPopularity == oOtherPOPM.m_iPopularity && this.m_iPlayCount == oOtherPOPM.m_iPlayCount;
    }
}

