/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.ID3Tag;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.v2.ID3V2Frame;
import org.blinkenlights.jid3.v2.ID3V2_3_0Tag;

public abstract class ID3V2Tag
extends ID3Tag {
    protected boolean m_bUnsynchronizationUsedFlag;
    protected boolean m_bExtendedHeaderFlag;
    protected boolean m_bExperimentalFlag;
    protected boolean m_bCRCDataFlag;
    protected Map m_oFrameIdToFrameMap = null;
    private static int s_iDefaultPaddingLength = 16;
    protected int m_iPaddingLength;

    public ID3V2Tag(boolean bUnsynchronizationUsedFlag, boolean bExtendedHeaderFlag, boolean bExperimentalFlag) {
        this.m_bUnsynchronizationUsedFlag = bUnsynchronizationUsedFlag;
        this.m_bExtendedHeaderFlag = bExtendedHeaderFlag;
        this.m_bExperimentalFlag = bExperimentalFlag;
        this.m_oFrameIdToFrameMap = new HashMap();
        this.m_iPaddingLength = s_iDefaultPaddingLength;
    }

    public ID3V2Frame[] getSingleFrames() {
        return this.m_oFrameIdToFrameMap.values().toArray(new ID3V2Frame[0]);
    }

    public abstract boolean containsAtLeastOneFrame();

    public abstract void sanityCheck() throws ID3Exception;

    public abstract void write(OutputStream var1) throws ID3Exception;

    public String toString() {
        StringBuffer sbText = new StringBuffer();
        sbText.append("Unsynchronization: " + this.m_bUnsynchronizationUsedFlag + "\nExtended header: " + this.m_bExtendedHeaderFlag + "\nExperimental: " + this.m_bExperimentalFlag + "\nCRC: " + this.m_bCRCDataFlag + "\nPadding length: " + this.m_iPaddingLength + "\nNum frames: " + this.m_oFrameIdToFrameMap.size());
        Iterator oIter = this.m_oFrameIdToFrameMap.keySet().iterator();
        while (oIter.hasNext()) {
            String sFrameId = (String)oIter.next();
            sbText.append("\n" + (ID3V2Frame)this.m_oFrameIdToFrameMap.get(sFrameId));
        }
        return sbText.toString();
    }

    public static ID3V2Tag read(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oID3DIS = new ID3DataInputStream(oIS);
            int iMinorVersion = oID3DIS.readUnsignedByte();
            int iPatchVersion = oID3DIS.readUnsignedByte();
            if (iMinorVersion == 3) {
                ID3V2Tag oID3V2Tag = ID3V2_3_0Tag.internalRead(oID3DIS);
                return oID3V2Tag;
            }
            return null;
        }
        catch (ID3Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new ID3Exception("Error reading tag.", e);
        }
    }

    public void setUnsynchronization(boolean bUnsynchronizationUsed) {
        this.m_bUnsynchronizationUsedFlag = bUnsynchronizationUsed;
    }

    public boolean getUnsynchronization() {
        return this.m_bUnsynchronizationUsedFlag;
    }

    public void setExtendedHeader(boolean bExtendedHeaderUsed) {
        this.m_bExtendedHeaderFlag = bExtendedHeaderUsed;
    }

    public boolean getExtendedHeader() {
        return this.m_bExtendedHeaderFlag;
    }

    public void setCRC(boolean bCRCUsed) throws ID3Exception {
        if (!this.m_bExtendedHeaderFlag) {
            throw new ID3Exception("The CRC flag cannot be set unless the extended header flag is set first.");
        }
        this.m_bCRCDataFlag = bCRCUsed;
    }

    public boolean getCRC() {
        return this.m_bCRCDataFlag;
    }

    public static void setDefaultPaddingLength(int iPaddingLength) throws ID3Exception {
        if (iPaddingLength < 0) {
            throw new ID3Exception("Padding length in ID3 V2 tag cannot be negative.");
        }
        s_iDefaultPaddingLength = iPaddingLength;
    }

    public void setPaddingLength(int iPaddingLength) throws ID3Exception {
        if (iPaddingLength < 0) {
            throw new ID3Exception("Padding length in ID3 V2 tag cannot be negative.");
        }
        this.m_iPaddingLength = iPaddingLength;
    }

    public static int getDefaultPaddingLength() {
        return s_iDefaultPaddingLength;
    }

    public int getPaddingLength() {
        return this.m_iPaddingLength;
    }

    public abstract void setArtist(String var1) throws ID3Exception;

    public abstract String getArtist();

    public abstract void setTitle(String var1) throws ID3Exception;

    public abstract String getTitle();

    public abstract void setAlbum(String var1) throws ID3Exception;

    public abstract String getAlbum();

    public abstract void setYear(int var1) throws ID3Exception;

    public abstract int getYear() throws ID3Exception;

    public abstract void setTrackNumber(int var1) throws ID3Exception;

    public abstract void setTrackNumber(int var1, int var2) throws ID3Exception;

    public abstract int getTrackNumber() throws ID3Exception;

    public abstract int getTotalTracks() throws ID3Exception;

    public abstract void setGenre(String var1) throws ID3Exception;

    public abstract String getGenre();

    public abstract void setComment(String var1) throws ID3Exception;

    public abstract String getComment();
}

