/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class GRIDID3V2Frame
extends ID3V2Frame {
    private String m_sOwnerIdentifier = null;
    private byte m_byGroupSymbol;
    private byte[] m_abyGroupDependantData = null;

    public GRIDID3V2Frame(String sOwnerIdentifier, byte byGroupSymbol, byte[] abyGroupDependantData) throws ID3Exception {
        if (sOwnerIdentifier == null || sOwnerIdentifier.length() == 0) {
            throw new ID3Exception("GRID frame requires owner identifier value.");
        }
        this.m_sOwnerIdentifier = sOwnerIdentifier;
        this.m_byGroupSymbol = byGroupSymbol;
        this.m_abyGroupDependantData = abyGroupDependantData;
        if (this.m_abyGroupDependantData != null && this.m_abyGroupDependantData.length == 0) {
            this.m_abyGroupDependantData = null;
        }
    }

    public GRIDID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_sOwnerIdentifier = oFrameDataID3DIS.readStringToNull();
            this.m_byGroupSymbol = (byte)oFrameDataID3DIS.readUnsignedByte();
            if (oFrameDataID3DIS.available() > 0) {
                this.m_abyGroupDependantData = new byte[oFrameDataID3DIS.available()];
                oFrameDataID3DIS.readFully(this.m_abyGroupDependantData);
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitGRIDID3V2Frame(this);
    }

    public void setGroupIdentificationRegistration(String sOwnerIdentifier, byte byGroupSymbol, byte[] abyGroupDependantData) throws ID3Exception {
        String sOrigOwnerIdentifier = this.m_sOwnerIdentifier;
        byte byOrigGroupSymbol = this.m_byGroupSymbol;
        byte[] abyOrigGroupDependantData = this.m_abyGroupDependantData;
        if (sOwnerIdentifier == null || sOwnerIdentifier.length() == 0) {
            throw new ID3Exception("GRID frame requires owner identifier value.");
        }
        this.m_sOwnerIdentifier = sOwnerIdentifier;
        this.m_byGroupSymbol = byGroupSymbol;
        this.m_abyGroupDependantData = abyGroupDependantData;
        if (this.m_abyGroupDependantData != null && this.m_abyGroupDependantData.length == 0) {
            this.m_abyGroupDependantData = null;
        }
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sOwnerIdentifier = sOrigOwnerIdentifier;
            this.m_byGroupSymbol = byOrigGroupSymbol;
            this.m_abyGroupDependantData = abyOrigGroupDependantData;
            throw e;
        }
    }

    public String getOwnerIdentifier() {
        return this.m_sOwnerIdentifier;
    }

    public byte getGroupSymbol() {
        return this.m_byGroupSymbol;
    }

    public byte[] getGroupDependantData() {
        return this.m_abyGroupDependantData;
    }

    protected byte[] getFrameId() {
        return "GRID".getBytes();
    }

    public String toString() {
        StringBuffer sbOutput = new StringBuffer();
        sbOutput.append("Group identification registration: Owner identifier=[" + this.m_sOwnerIdentifier + "], Group symbol=[" + this.m_byGroupSymbol + "], ");
        if (this.m_abyGroupDependantData == null) {
            sbOutput.append("Group dependant data = none");
        } else {
            sbOutput.append("Group dependant data length = " + this.m_abyGroupDependantData.length);
        }
        return sbOutput.toString();
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_sOwnerIdentifier.getBytes());
        oIDOS.writeUnsignedByte(0);
        oIDOS.writeUnsignedByte(this.m_byGroupSymbol);
        if (this.m_abyGroupDependantData != null) {
            oIDOS.write(this.m_abyGroupDependantData);
        }
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof GRIDID3V2Frame)) {
            return false;
        }
        GRIDID3V2Frame oOtherGRID = (GRIDID3V2Frame)oOther;
        return (this.m_sOwnerIdentifier == null && oOtherGRID.m_sOwnerIdentifier == null || this.m_sOwnerIdentifier.equals(oOtherGRID.m_sOwnerIdentifier)) && this.m_byGroupSymbol == oOtherGRID.m_byGroupSymbol && Arrays.equals(this.m_abyGroupDependantData, oOtherGRID.m_abyGroupDependantData);
    }
}

