/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Reference
implements PhylogenyData {
    String _desc;
    String _doi;

    public Reference(String desc) {
        this._desc = desc;
        this._doi = "";
    }

    public Reference(String desc, String doi) {
        this._desc = desc;
        this._doi = doi;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getDescription());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getDoi())) {
            sb.append("[doi:");
            sb.append(this.getDoi());
            sb.append("] ");
        }
        sb.append(this.getDescription());
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        return new Reference(this.getDescription(), this.getDoi());
    }

    public String getDoi() {
        return this._doi;
    }

    public String getDescription() {
        return this._desc;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (data == null || this.getDescription() == null) {
            return false;
        }
        return ((Reference)data).getDescription().equals(this.getDescription()) && ((Reference)data).getDoi().equals(this.getDoi());
    }

    public void setDoi(String doi) throws PhyloXmlDataFormatException {
        if (!ForesterUtil.isEmpty(doi) && !PhyloXmlUtil.LIT_REF_DOI_PATTERN.matcher(doi).matches()) {
            throw new PhyloXmlDataFormatException("illegal doi: [" + doi + "]");
        }
        this._doi = doi;
    }

    public void setValue(String value) {
        this._desc = value;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "reference", "doi", this.getDoi());
        if (!ForesterUtil.isEmpty(this.getDescription())) {
            PhylogenyDataUtil.appendElement(writer, "desc", this.getDescription(), indentation);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "reference");
    }

    public String toString() {
        return this.asText().toString();
    }
}

