/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;

public class BranchData
implements PhylogenyData {
    private BranchColor _branch_color;
    private List<Confidence> _confidences;
    private BranchWidth _branch_width;

    public void addConfidence(Confidence confidence) {
        this.getConfidences().add(confidence);
    }

    @Override
    public StringBuffer asSimpleText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer asText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PhylogenyData copy() {
        BranchData new_bd = new BranchData();
        if (this.isHasBranchColor()) {
            new_bd.setBranchColor((BranchColor)this.getBranchColor().copy());
        }
        if (this.isHasBranchWidth()) {
            new_bd.setBranchWidth((BranchWidth)this.getBranchWidth().copy());
        }
        if (this.isHasConfidences()) {
            for (Confidence confidence : this.getConfidences()) {
                new_bd.addConfidence((Confidence)confidence.copy());
            }
        }
        return new_bd;
    }

    public BranchColor getBranchColor() {
        return this._branch_color;
    }

    public BranchWidth getBranchWidth() {
        return this._branch_width;
    }

    public Confidence getConfidence(int index) {
        return this.getConfidences().get(index);
    }

    public List<Confidence> getConfidences() {
        if (this._confidences == null) {
            this._confidences = new ArrayList<Confidence>();
        }
        return this._confidences;
    }

    public int getNumberOfConfidences() {
        return this.getConfidences().size();
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    public boolean isHasBranchColor() {
        return this.getBranchColor() != null;
    }

    public boolean isHasBranchWidth() {
        return this.getBranchWidth() != null;
    }

    public boolean isHasConfidences() {
        return this.getNumberOfConfidences() > 0;
    }

    public void setBranchColor(BranchColor branch_color) {
        this._branch_color = branch_color;
    }

    public void setBranchWidth(BranchWidth branch_width) {
        this._branch_width = branch_width;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        if (this.isHasConfidences() && this.getConfidence(0).getValue() != -9999.0) {
            sb.append(":");
            sb.append(this.getConfidence(0).toNHX());
        }
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.isHasConfidences()) {
            for (Confidence confidence : this.getConfidences()) {
                confidence.toPhyloXML(writer, level, indentation);
            }
        }
        if (this.isHasBranchWidth()) {
            this.getBranchWidth().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasBranchColor()) {
            this.getBranchColor().toPhyloXML(writer, level, indentation);
        }
    }
}

