/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa_compactor;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.archaeopteryx.Archaeopteryx;
import org.forester.archaeopteryx.Configuration;
import org.forester.evoinference.distance.NeighborJoiningF;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.tools.BootstrapResampler;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.DeleteableMsa;
import org.forester.msa.Mafft;
import org.forester.msa.Msa;
import org.forester.msa.MsaInferrer;
import org.forester.msa.MsaMethods;
import org.forester.msa.ResampleableMsa;
import org.forester.msa_compactor.GapContribution;
import org.forester.msa_compactor.MsaProperties;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.MolecularSequence;
import org.forester.tools.ConfidenceAssessor;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class MsaCompactor {
    private static final NumberFormat NF_1 = new DecimalFormat("0.#");
    private static final NumberFormat NF_3 = new DecimalFormat("0.###");
    private static final NumberFormat NF_4 = new DecimalFormat("0.####");
    private boolean _calculate_shannon_entropy = false;
    private String _infile_name = null;
    private final short _longest_id_length;
    private String _maffts_opts = "--auto";
    private DeleteableMsa _msa = null;
    private boolean _normalize_for_effective_seq_length = true;
    private File _out_file_base = null;
    private Msa.MSA_FORMAT _output_format = Msa.MSA_FORMAT.FASTA;
    private String _path_to_mafft = null;
    private boolean _phylogentic_inference = false;
    private boolean _realign = false;
    private final SortedSet<String> _removed_seq_ids;
    private final ArrayList<MolecularSequence> _removed_seqs;
    private File _removed_seqs_out_base = null;
    private int _step = -1;
    private int _step_for_diagnostics = -1;

    public MsaCompactor(DeleteableMsa msa) {
        this._msa = msa;
        this._removed_seq_ids = new TreeSet<String>();
        this._longest_id_length = this._msa.determineMaxIdLength();
        this._removed_seqs = new ArrayList();
    }

    public final Phylogeny calcTree() {
        Phylogeny phy = this.inferNJphylogeny(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.KIMURA_DISTANCE, this._msa, false, "");
        PhylogenyMethods.midpointRoot(phy);
        PhylogenyMethods.orderAppearance(phy.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME);
        boolean x = PhylogenyMethods.extractFastaInformation(phy);
        if (!x) {
            PhylogenyNodeIterator it = phy.iteratorExternalForward();
            while (it.hasNext()) {
                PhylogenyNode n = it.next();
                String name = n.getName().trim();
                if (ForesterUtil.isEmpty(name)) continue;
                try {
                    ParserUtils.extractTaxonomyDataFromNodeName(n, NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {}
            }
        }
        return phy;
    }

    public final List<MsaProperties> chart(int step, boolean realign, boolean normalize_for_effective_seq_length) throws IOException, InterruptedException {
        int x;
        GapContribution[] stats = this.calcGapContribtionsStats(normalize_for_effective_seq_length);
        ArrayList<String> to_remove_ids = new ArrayList<String>();
        ArrayList<MsaProperties> msa_props = new ArrayList<MsaProperties>();
        for (GapContribution gap_gontribution : stats) {
            to_remove_ids.add(gap_gontribution.getId());
        }
        Phylogeny phy = null;
        if (this._phylogentic_inference) {
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            phy = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phy);
        }
        if (!this._realign) {
            this._step = -1;
        }
        if ((x = ForesterUtil.roundToInt((double)this._msa.getNumberOfSequences() / 10.0)) < 2) {
            x = 2;
        }
        MsaProperties msa_prop = new MsaProperties(this._msa, "", this._calculate_shannon_entropy);
        msa_props.add(msa_prop);
        this.printTableHeader();
        this.printMsaProperties(msa_prop);
        System.out.println();
        int i = 0;
        while (this._msa.getNumberOfSequences() > x) {
            String id = (String)to_remove_ids.get(i);
            this._msa.deleteRow(id, false);
            if (realign && this.isPrintMsaStatsWriteOutfileAndRealign(i)) {
                this.removeGapColumns();
                this.realignWithMafft();
                msa_prop = new MsaProperties(this._msa, id, this._calculate_shannon_entropy);
                msa_props.add(msa_prop);
                this.printMsaProperties(msa_prop);
                System.out.print("(realigned)");
                System.out.println();
            } else if (this.isPrintMsaStats(i)) {
                this.removeGapColumns();
                msa_prop = new MsaProperties(this._msa, id, this._calculate_shannon_entropy);
                msa_props.add(msa_prop);
                this.printMsaProperties(msa_prop);
                System.out.println();
            }
            ++i;
        }
        if (this._phylogentic_inference) {
            MsaCompactor.decorateTree(phy, msa_props, true);
            this.displayTree(phy);
        }
        return msa_props;
    }

    private static final void addSeqs2Tree(Msa msa, Phylogeny phy) {
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            MolecularSequence seq = msa.getSequence(i);
            String seq_name = seq.getIdentifier();
            PhylogenyNode n = phy.getNode(seq_name);
            if (n.getNodeData().isHasSequence()) {
                throw new IllegalArgumentException("this should not have happened");
            }
            n.getNodeData().addSequence(new Sequence());
            n.getNodeData().getSequence().setMolecularSequence(seq.getMolecularSequenceAsString());
            n.getNodeData().getSequence().setMolecularSequenceAligned(true);
            n.getNodeData().getSequence().setName(seq_name);
        }
    }

    private static final void decorateTree(Phylogeny phy, List<MsaProperties> msa_props, boolean chart_only) {
        BasicDescriptiveStatistics length_stats = new BasicDescriptiveStatistics();
        for (int i = 0; i < msa_props.size(); ++i) {
            MsaProperties msa_prop = msa_props.get(i);
            String id = msa_prop.getRemovedSeq();
            if (ForesterUtil.isEmpty(id)) continue;
            length_stats.addValue(msa_prop.getLength());
        }
        double mean = length_stats.arithmeticMean();
        double min = length_stats.getMin();
        double max = length_stats.getMax();
        Color min_color = new Color(0, 255, 0);
        Color max_color = new Color(255, 0, 0);
        Color mean_color = new Color(255, 255, 0);
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        if (chart_only) {
            while (it.hasNext()) {
                NodeVisualData vis = new NodeVisualData();
                vis.setFillType(NodeVisualData.NodeFill.SOLID);
                vis.setShape(NodeVisualData.NodeShape.RECTANGLE);
                vis.setNodeColor(min_color);
                it.next().getNodeData().setNodeVisualData(vis);
            }
        }
        for (int i = 0; i < msa_props.size(); ++i) {
            MsaProperties msa_prop = msa_props.get(i);
            String id = msa_prop.getRemovedSeq();
            if (ForesterUtil.isEmpty(id)) continue;
            PhylogenyNode n = phy.getNode(id);
            n.setName(n.getName() + " [" + i + "]");
            if (!chart_only) {
                NodeVisualData vis = new NodeVisualData();
                vis.setFillType(NodeVisualData.NodeFill.SOLID);
                vis.setShape(NodeVisualData.NodeShape.RECTANGLE);
                vis.setNodeColor(ForesterUtil.calcColor(msa_prop.getLength(), min, max, mean_color, max_color));
                n.getNodeData().setNodeVisualData(vis);
                continue;
            }
            n.getNodeData().getNodeVisualData().setNodeColor(ForesterUtil.calcColor(msa_prop.getLength(), min, max, mean, min_color, max_color, mean_color));
        }
    }

    public final void deleteGapColumns(double max_allowed_gap_ratio) {
        this._msa.deleteGapColumns(max_allowed_gap_ratio);
    }

    public final void displayTree(Phylogeny phy) {
        Configuration config = new Configuration();
        config.setDisplayAsPhylogram(true);
        config.setUseStyle(true);
        config.setDisplayTaxonomyCode(false);
        config.setDisplayTaxonomyCommonNames(false);
        config.setDisplayTaxonomyScientificNames(false);
        config.setDisplaySequenceNames(false);
        config.setDisplaySequenceSymbols(false);
        config.setDisplayGeneNames(false);
        config.setDisplayMultipleSequenceAlignment(true);
        config.setShowScale(true);
        config.setAddTaxonomyImagesCB(false);
        config.setBaseFontSize(9);
        config.setBaseFontFamilyName("Arial");
        Archaeopteryx.createApplication(phy, config, this._infile_name);
    }

    public final Msa getMsa() {
        return this._msa;
    }

    public final void removeSequencesByMinimalLength(int min_effective_length) throws IOException {
        this._msa = DeleteableMsa.createInstance(MsaMethods.removeSequencesByMinimalLength(this._msa, min_effective_length));
        this.removeGapColumns();
        String s = this.writeOutfile();
        DescriptiveStatistics msa_stats = MsaMethods.calculateEffectiveLengthStatistics(this._msa);
        System.out.println("Output MSA                           : " + s);
        System.out.println("  MSA length                         : " + this._msa.getLength());
        System.out.println("  Number of sequences                : " + this._msa.getNumberOfSequences());
        System.out.println("  Median sequence length             : " + NF_1.format(msa_stats.median()));
        System.out.println("  Mean sequence length               : " + NF_1.format(msa_stats.arithmeticMean()));
        System.out.println("  Max sequence length                : " + (int)msa_stats.getMax());
        System.out.println("  Min sequence length                : " + (int)msa_stats.getMin());
        System.out.println("  Gap ratio                          : " + NF_4.format(MsaMethods.calcGapRatio(this._msa)));
        System.out.println("  Normalized Shannon Entropy (entn21): " + NF_4.format(MsaMethods.calcNormalizedShannonsEntropy(21, this._msa)));
        System.out.println();
    }

    public final List<MsaProperties> removeViaGapAverage(double mean_gapiness) throws IOException, InterruptedException {
        GapContribution[] stats = this.calcGapContribtionsStats(this._normalize_for_effective_seq_length);
        ArrayList<String> to_remove_ids = new ArrayList<String>();
        ArrayList<MsaProperties> msa_props = new ArrayList<MsaProperties>();
        for (GapContribution gap_gontribution : stats) {
            to_remove_ids.add(gap_gontribution.getId());
        }
        Phylogeny phy = null;
        if (this._phylogentic_inference) {
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            phy = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phy);
        }
        this.printTableHeader();
        MsaProperties msa_prop = new MsaProperties(this._msa, "", this._calculate_shannon_entropy);
        msa_props.add(msa_prop);
        this.printMsaProperties(msa_prop);
        System.out.println();
        int i = 0;
        while (MsaMethods.calcGapRatio(this._msa) > mean_gapiness) {
            String id = (String)to_remove_ids.get(i);
            this._removed_seq_ids.add(id);
            MolecularSequence deleted = this._msa.deleteRow(id, true);
            this._removed_seqs.add(deleted);
            this.removeGapColumns();
            if (this.isPrintMsaStatsWriteOutfileAndRealign(i) || MsaMethods.calcGapRatio(this._msa) <= mean_gapiness) {
                msa_prop = this.printMsaStatsWriteOutfileAndRealign(this._realign, id);
                msa_props.add(msa_prop);
                System.out.println();
            } else if (this.isPrintMsaStats(i)) {
                msa_prop = new MsaProperties(this._msa, id, this._calculate_shannon_entropy);
                msa_props.add(msa_prop);
                this.printMsaProperties(msa_prop);
                System.out.println();
            }
            ++i;
        }
        if (this._removed_seqs_out_base != null) {
            String msg = this.writeAndAlignRemovedSeqs();
            System.out.println();
            System.out.println(msg);
        }
        if (this._phylogentic_inference) {
            MsaCompactor.decorateTree(phy, msa_props, false);
            this.displayTree(phy);
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            Phylogeny phy2 = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phy2);
            this.displayTree(phy2);
        }
        return msa_props;
    }

    public List<MsaProperties> removeViaLength(int length) throws IOException, InterruptedException {
        GapContribution[] stats = this.calcGapContribtionsStats(this._normalize_for_effective_seq_length);
        ArrayList<String> to_remove_ids = new ArrayList<String>();
        ArrayList<MsaProperties> msa_props = new ArrayList<MsaProperties>();
        for (GapContribution gap_gontribution : stats) {
            to_remove_ids.add(gap_gontribution.getId());
        }
        Phylogeny phy = null;
        if (this._phylogentic_inference) {
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            phy = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phy);
        }
        this.printTableHeader();
        MsaProperties msa_prop = new MsaProperties(this._msa, "", this._calculate_shannon_entropy);
        msa_props.add(msa_prop);
        this.printMsaProperties(msa_prop);
        System.out.println();
        int i = 0;
        while (this._msa.getLength() > length) {
            String id = (String)to_remove_ids.get(i);
            this._removed_seq_ids.add(id);
            MolecularSequence deleted = this._msa.deleteRow(id, true);
            this._removed_seqs.add(deleted);
            this.removeGapColumns();
            if (this.isPrintMsaStatsWriteOutfileAndRealign(i) || this._msa.getLength() <= length) {
                msa_prop = this.printMsaStatsWriteOutfileAndRealign(this._realign, id);
                msa_props.add(msa_prop);
                System.out.println();
            } else if (this.isPrintMsaStats(i)) {
                msa_prop = new MsaProperties(this._msa, id, this._calculate_shannon_entropy);
                this.printMsaProperties(msa_prop);
                msa_props.add(msa_prop);
                System.out.println();
            }
            ++i;
        }
        if (this._removed_seqs_out_base != null) {
            String msg = this.writeAndAlignRemovedSeqs();
            System.out.println();
            System.out.println(msg);
        }
        if (this._phylogentic_inference) {
            MsaCompactor.decorateTree(phy, msa_props, false);
            this.displayTree(phy);
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            Phylogeny phy2 = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phy2);
            this.displayTree(phy2);
        }
        return msa_props;
    }

    public final List<MsaProperties> removeWorstOffenders(int to_remove) throws IOException, InterruptedException {
        GapContribution[] stats = this.calcGapContribtionsStats(this._normalize_for_effective_seq_length);
        ArrayList<String> to_remove_ids = new ArrayList<String>();
        ArrayList<MsaProperties> msa_props = new ArrayList<MsaProperties>();
        for (int j = 0; j < to_remove; ++j) {
            to_remove_ids.add(stats[j].getId());
        }
        Phylogeny phy = null;
        if (this._phylogentic_inference) {
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            phy = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phy);
        }
        this.printTableHeader();
        MsaProperties msa_prop = new MsaProperties(this._msa, "", this._calculate_shannon_entropy);
        msa_props.add(msa_prop);
        this.printMsaProperties(msa_prop);
        System.out.println();
        for (int i = 0; i < to_remove_ids.size(); ++i) {
            String id = (String)to_remove_ids.get(i);
            this._removed_seq_ids.add(id);
            MolecularSequence deleted = this._msa.deleteRow(id, true);
            this._removed_seqs.add(deleted);
            this.removeGapColumns();
            if (this.isPrintMsaStatsWriteOutfileAndRealign(i) || i == to_remove_ids.size() - 1) {
                msa_prop = this.printMsaStatsWriteOutfileAndRealign(this._realign, id);
                msa_props.add(msa_prop);
                System.out.println();
                continue;
            }
            if (!this.isPrintMsaStats(i)) continue;
            msa_prop = new MsaProperties(this._msa, id, this._calculate_shannon_entropy);
            msa_props.add(msa_prop);
            this.printMsaProperties(msa_prop);
            System.out.println();
        }
        if (this._removed_seqs_out_base != null) {
            String msg = this.writeAndAlignRemovedSeqs();
            System.out.println();
            System.out.println(msg);
        }
        if (this._phylogentic_inference) {
            MsaCompactor.decorateTree(phy, msa_props, false);
            this.displayTree(phy);
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            Phylogeny phy2 = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phy2);
            this.displayTree(phy2);
        }
        return msa_props;
    }

    public final void setCalculateNormalizedShannonEntropy(boolean calculate_shannon_entropy) {
        this._calculate_shannon_entropy = calculate_shannon_entropy;
    }

    public void setInfileName(String infile_name) {
        this._infile_name = infile_name;
    }

    public final void setMafftOptions(String maffts_opts) {
        this._maffts_opts = maffts_opts;
    }

    public final void setNorm(boolean normalize_for_effective_seq_length) {
        this._normalize_for_effective_seq_length = normalize_for_effective_seq_length;
    }

    public final void setOutFileBase(File out_file_base) {
        this._out_file_base = out_file_base;
    }

    public final void setOutputFormat(Msa.MSA_FORMAT output_format) {
        this._output_format = output_format;
    }

    public void setPathToMafft(String path_to_mafft) {
        this._path_to_mafft = path_to_mafft;
    }

    public void setPeformPhylogenticInference(boolean phylogentic_inference) {
        this._phylogentic_inference = phylogentic_inference;
    }

    public final void setRealign(boolean realign) {
        this._realign = realign;
    }

    public final void setRemovedSeqsOutBase(File removed_seqs_out_base) {
        this._removed_seqs_out_base = removed_seqs_out_base;
    }

    public final void setStep(int step) {
        this._step = step;
    }

    public final void setStepForDiagnostics(int step_for_diagnostics) {
        this._step_for_diagnostics = step_for_diagnostics;
    }

    public final String writeAndAlignRemovedSeqs() throws IOException, InterruptedException {
        StringBuilder msg = new StringBuilder();
        String n = this._removed_seqs_out_base + "_" + this._removed_seqs.size() + ".fasta";
        SequenceWriter.writeSeqs(this._removed_seqs, new File(n), SequenceWriter.SEQ_FORMAT.FASTA, 100);
        msg.append("wrote " + this._removed_seqs.size() + " removed sequences to " + "\"" + n + "\"");
        if (this._realign) {
            MsaInferrer mafft = Mafft.createInstance(this._path_to_mafft);
            ArrayList<String> opts = new ArrayList<String>();
            for (String o : this._maffts_opts.split("\\s")) {
                opts.add(o);
            }
            Msa removed_msa = mafft.infer(this._removed_seqs, opts);
            Double gr = MsaMethods.calcGapRatio(removed_msa);
            String s = this._removed_seqs_out_base + "_" + removed_msa.getNumberOfSequences() + "_" + removed_msa.getLength() + "_" + ForesterUtil.roundToInt(gr * 100.0);
            String suffix = this.obtainSuffix();
            s = s + suffix;
            MsaCompactor.writeMsa(removed_msa, s, this._output_format);
            msg.append(", and as MSA of length " + removed_msa.getLength() + " to \"" + s + "\"");
        }
        return msg.toString();
    }

    public final String writeMsa(File outfile) throws IOException {
        Double gr = MsaMethods.calcGapRatio(this._msa);
        String s = outfile + "_" + this._msa.getNumberOfSequences() + "_" + this._msa.getLength() + "_" + ForesterUtil.roundToInt(gr * 100.0);
        MsaCompactor.writeMsa(this._msa, s + this.obtainSuffix(), this._output_format);
        return s;
    }

    final int calcNonGapResidues(MolecularSequence seq) {
        int ng = 0;
        for (int i = 0; i < seq.getLength(); ++i) {
            if (seq.isGapAt(i)) continue;
            ++ng;
        }
        return ng;
    }

    private final GapContribution[] calcGapContribtions(boolean normalize_for_effective_seq_length) {
        double[] gappiness = this.calcGappiness();
        GapContribution[] stats = new GapContribution[this._msa.getNumberOfSequences()];
        for (int row = 0; row < this._msa.getNumberOfSequences(); ++row) {
            stats[row] = new GapContribution(this._msa.getIdentifier(row));
            for (int col = 0; col < this._msa.getLength(); ++col) {
                if (this._msa.isGapAt(row, col)) continue;
                stats[row].addToValue(gappiness[col]);
            }
            if (normalize_for_effective_seq_length) {
                stats[row].divideValue(this.calcNonGapResidues(this._msa.getSequence(row)));
                continue;
            }
            stats[row].divideValue(this._msa.getLength());
        }
        return stats;
    }

    private final GapContribution[] calcGapContribtionsStats(boolean normalize_for_effective_seq_length) {
        Object[] stats = this.calcGapContribtions(normalize_for_effective_seq_length);
        Arrays.sort(stats);
        return stats;
    }

    private final double[] calcGappiness() {
        int l = this._msa.getLength();
        double[] gappiness = new double[l];
        int seqs = this._msa.getNumberOfSequences();
        for (int i = 0; i < l; ++i) {
            gappiness[i] = (double)MsaMethods.calcGapSumPerColumn(this._msa, i) / (double)seqs;
        }
        return gappiness;
    }

    private final Phylogeny collapse(Msa msa, int threshold) {
        BasicSymmetricalDistanceMatrix m = PairwiseDistanceCalculator.calcFractionalDissimilarities(msa);
        return null;
    }

    private final Phylogeny inferNJphylogeny(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD pwd_distance_method, Msa msa, boolean write_matrix, String matrix_name) {
        BasicSymmetricalDistanceMatrix m = null;
        switch (pwd_distance_method) {
            case KIMURA_DISTANCE: {
                m = PairwiseDistanceCalculator.calcKimuraDistances(msa);
                break;
            }
            case POISSON_DISTANCE: {
                m = PairwiseDistanceCalculator.calcPoissonDistances(msa);
                break;
            }
            case FRACTIONAL_DISSIMILARITY: {
                m = PairwiseDistanceCalculator.calcFractionalDissimilarities(msa);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid pwd method");
            }
        }
        if (write_matrix) {
            try {
                m.write(ForesterUtil.createBufferedWriter(matrix_name));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        NeighborJoiningF nj2 = NeighborJoiningF.createInstance(false, 5);
        Phylogeny phy = nj2.execute(m);
        return phy;
    }

    private final boolean isPrintMsaStats(int i) {
        return this._step == 1 && this._step_for_diagnostics == 1 || this._step_for_diagnostics > 0 && (i + 1) % this._step_for_diagnostics == 0;
    }

    private final boolean isPrintMsaStatsWriteOutfileAndRealign(int i) {
        return this._step == 1 && this._step_for_diagnostics == 1 || this._step > 0 && (i + 1) % this._step == 0;
    }

    private final StringBuilder msaPropertiesAsSB(MsaProperties msa_properties) {
        StringBuilder sb = new StringBuilder();
        sb.append(msa_properties.getNumberOfSequences());
        sb.append("\t");
        sb.append(msa_properties.getLength());
        sb.append("\t");
        sb.append(NF_4.format(msa_properties.getGapRatio()));
        sb.append("\t");
        sb.append(NF_1.format(msa_properties.getAvgNumberOfGaps()));
        if (this._calculate_shannon_entropy) {
            sb.append("\t");
            sb.append(NF_4.format(msa_properties.getEntropy7()));
            sb.append("\t");
            sb.append(NF_4.format(msa_properties.getEntropy21()));
        }
        return sb;
    }

    private String obtainSuffix() {
        if (this._output_format == Msa.MSA_FORMAT.FASTA) {
            return ".fasta";
        }
        if (this._output_format == Msa.MSA_FORMAT.PHYLIP) {
            return ".aln";
        }
        return "";
    }

    private final Phylogeny pi(String matrix, int boostrap) {
        Phylogeny master_phy = this.inferNJphylogeny(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.KIMURA_DISTANCE, this._msa, true, matrix);
        int seed = 15;
        int n = 100;
        ResampleableMsa resampleable_msa = new ResampleableMsa(this._msa);
        int[][] resampled_column_positions = BootstrapResampler.createResampledColumnPositions(this._msa.getLength(), 100, 15L);
        Phylogeny[] eval_phys = new Phylogeny[100];
        for (int i = 0; i < 100; ++i) {
            resampleable_msa.resample(resampled_column_positions[i]);
            eval_phys[i] = this.inferNJphylogeny(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.KIMURA_DISTANCE, resampleable_msa, false, null);
        }
        ConfidenceAssessor.evaluate("bootstrap", eval_phys, master_phy, true, 1.0);
        PhylogenyMethods.extractFastaInformation(master_phy);
        return master_phy;
    }

    private final void printMsaProperties(MsaProperties msa_properties) {
        if (this._step == 1 || this._step_for_diagnostics == 1) {
            System.out.print(ForesterUtil.pad(msa_properties.getRemovedSeq(), (int)this._longest_id_length, ' ', false));
            System.out.print("\t");
        }
        System.out.print(this.msaPropertiesAsSB(msa_properties));
        System.out.print("\t");
    }

    private final MsaProperties printMsaStatsWriteOutfileAndRealign(boolean realign, String id) throws IOException, InterruptedException {
        if (realign) {
            this.realignWithMafft();
        }
        MsaProperties msa_prop = new MsaProperties(this._msa, id, this._calculate_shannon_entropy);
        this.printMsaProperties(msa_prop);
        String s = this.writeOutfile();
        System.out.print("-> " + s + (realign ? "\t(realigned)" : ""));
        return msa_prop;
    }

    private final void printTableHeader() {
        if (this._step == 1 || this._step_for_diagnostics == 1) {
            System.out.print(ForesterUtil.pad("Id", (int)this._longest_id_length, ' ', false));
            System.out.print("\t");
        }
        System.out.print("Seqs");
        System.out.print("\t");
        System.out.print("Length");
        System.out.print("\t");
        System.out.print("Gap R");
        System.out.print("\t");
        System.out.print("Gaps");
        System.out.print("\t");
        if (this._calculate_shannon_entropy) {
            System.out.print("entn7");
            System.out.print("\t");
            System.out.print("entn21");
            System.out.print("\t");
        }
        System.out.println();
    }

    private final void realignWithMafft() throws IOException, InterruptedException {
        MsaInferrer mafft = Mafft.createInstance(this._path_to_mafft);
        ArrayList<String> opts = new ArrayList<String>();
        for (String o : this._maffts_opts.split("\\s")) {
            opts.add(o);
        }
        this._msa = DeleteableMsa.createInstance(mafft.infer(this._msa.asSequenceList(), opts));
    }

    private final void removeGapColumns() {
        this._msa.deleteGapOnlyColumns();
    }

    private final String writeOutfile() throws IOException {
        String s = this.writeMsa(this._out_file_base);
        return s;
    }

    public static final String guessPathToMafft() {
        String path;
        if (ForesterUtil.OS_NAME.toLowerCase().indexOf("win") >= 0 && MsaInferrer.isInstalled(path = "C:\\Program Files\\mafft-win\\mafft.bat")) {
            return path;
        }
        path = "/home/czmasek/SOFTWARE/MSA/MAFFT/mafft-7.130-without-extensions/scripts/mafft";
        if (MsaInferrer.isInstalled(path)) {
            return path;
        }
        path = "/usr/local/bin/mafft";
        if (MsaInferrer.isInstalled(path)) {
            return path;
        }
        path = "/usr/bin/mafft";
        if (MsaInferrer.isInstalled(path)) {
            return path;
        }
        path = "/bin/mafft";
        if (MsaInferrer.isInstalled(path)) {
            return path;
        }
        path = "mafft";
        if (MsaInferrer.isInstalled(path)) {
            return path;
        }
        return null;
    }

    private static final void writeMsa(Msa msa, String outfile, Msa.MSA_FORMAT format) throws IOException {
        BufferedWriter w = ForesterUtil.createBufferedWriter(outfile);
        msa.write(w, format);
        ((Writer)w).close();
    }

    static {
        NF_1.setRoundingMode(RoundingMode.HALF_UP);
        NF_4.setRoundingMode(RoundingMode.HALF_UP);
        NF_3.setRoundingMode(RoundingMode.HALF_UP);
    }
}

