/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.AccessionParser;
import org.forester.io.parsers.phyloxml.data.AnnotationParser;
import org.forester.io.parsers.phyloxml.data.DomainArchitectureParser;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.data.UriParser;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Uri;

public class SequenceParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private SequenceParser() {
    }

    @Override
    public Sequence parse(XmlElement element) throws PhyloXmlDataFormatException {
        Sequence sequence = new Sequence();
        if (element.isHasAttribute("type")) {
            sequence.setType(element.getAttribute("type"));
        }
        if (element.isHasAttribute("id_source")) {
            sequence.setSourceId(element.getAttribute("id_source"));
        }
        for (int i = 0; i < element.getNumberOfChildElements(); ++i) {
            XmlElement child_element = element.getChildElement(i);
            if (child_element.getQualifiedName().equals("location")) {
                sequence.setLocation(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("name")) {
                sequence.setName(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("gene_name")) {
                sequence.setGeneName(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("mol_seq")) {
                if (child_element.isHasAttribute("is_aligned")) {
                    sequence.setMolecularSequenceAligned(Boolean.parseBoolean(child_element.getAttribute("is_aligned")));
                }
                sequence.setMolecularSequence(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("accession")) {
                sequence.setAccession((Accession)AccessionParser.getInstance().parse(child_element));
                continue;
            }
            if (child_element.getQualifiedName().equals("symbol")) {
                sequence.setSymbol(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("annotation")) {
                sequence.addAnnotation((Annotation)AnnotationParser.getInstance().parse(child_element));
                continue;
            }
            if (child_element.getQualifiedName().equals("domain_architecture")) {
                sequence.setDomainArchitecture((DomainArchitecture)DomainArchitectureParser.getInstance().parse(child_element));
                continue;
            }
            if (child_element.getQualifiedName().equals("uri")) {
                sequence.addUri((Uri)UriParser.getInstance().parse(child_element));
                continue;
            }
            if (!child_element.getQualifiedName().equals("cross_references")) continue;
            for (int j = 0; j < child_element.getNumberOfChildElements(); ++j) {
                sequence.addCrossReference((Accession)AccessionParser.getInstance().parse(child_element.getChildElement(j)));
            }
        }
        return sequence;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new SequenceParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

