/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.tools;

import java.util.Random;
import org.forester.msa.BasicMsa;
import org.forester.msa.Msa;

public class BootstrapResampler {
    private static void copyIdentifiers(Msa msa, Msa new_msa) {
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            new_msa.setIdentifier(i, msa.getIdentifier(i));
        }
    }

    private static void preconditionCheck(Msa msa, int n) {
        if (msa.getLength() < 2) {
            throw new IllegalArgumentException("Msa length cannot be smaller than two for bootstrap resampling");
        }
        if (msa.getNumberOfSequences() < 1) {
            throw new IllegalArgumentException("Attempt to bootstrap resample empty multiple sequence alignment");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Number of bootstrap resamples cannot be zero or negative");
        }
    }

    private static void preconditionCheck(int length, int n) {
        if (length < 2) {
            throw new IllegalArgumentException("Msa length cannot be smaller than two for bootstrap resampling");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Number of bootstrap resamples cannot be zero or negative");
        }
    }

    public static Msa[] resample(Msa msa, int n, long seed) {
        BootstrapResampler.preconditionCheck(msa, n);
        Random random = new Random(seed);
        Msa[] msas = new Msa[n];
        for (int i = 0; i < n; ++i) {
            BasicMsa new_msa = new BasicMsa(msa.getNumberOfSequences(), msa.getLength(), msa.getType());
            msas[i] = new_msa;
            BootstrapResampler.copyIdentifiers(msa, new_msa);
            for (int col = 0; col < msa.getLength(); ++col) {
                int random_col = random.nextInt(msa.getLength());
                for (int row = 0; row < msa.getNumberOfSequences(); ++row) {
                    new_msa.setResidueAt(row, col, msa.getResidueAt(row, random_col));
                }
            }
        }
        return msas;
    }

    public static int[][] createResampledColumnPositions(int length, int n, long seed) {
        BootstrapResampler.preconditionCheck(length, n);
        Random random = new Random(seed);
        int[][] columns = new int[n][length];
        for (int i = 0; i < n; ++i) {
            for (int col = 0; col < length; ++col) {
                columns[i][col] = random.nextInt(length);
            }
        }
        return columns;
    }
}

