/*
 * Decompiled with CFR 0.152.
 */
package org.forester.datastructures;

import java.util.List;
import org.forester.util.ForesterUtil;

public final class IntMatrix {
    private final int[][] _data;
    private final String[] _labels;

    public IntMatrix(int size) {
        this._data = new int[size][size];
        this._labels = new String[size];
    }

    public IntMatrix(List<String> labels) {
        int size = labels.size();
        this._data = new int[size][size];
        this._labels = new String[size];
        for (int i = 0; i < size; ++i) {
            this.setLabel(i, labels.get(i));
        }
    }

    public final int get(int x, int y) {
        return this._data[x][y];
    }

    public final String getLabel(int x) {
        return this._labels[x];
    }

    public final String getRowAsString(int x, char separator) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLabel(x));
        for (int y = 0; y < this.size(); ++y) {
            sb.append(separator);
            sb.append(this.get(x, y));
        }
        return sb.toString();
    }

    public final void inreaseByOne(int x, int y) {
        int[] nArray = this._data[x];
        int n = y;
        nArray[n] = nArray[n] + 1;
    }

    public final void set(int x, int y, int value) {
        this._data[x][y] = value;
    }

    public final void setLabel(int x, String label) {
        if (label == null) {
            throw new IllegalArgumentException("matrix label must not be null");
        }
        this._labels[x] = label;
    }

    public final int size() {
        return this._labels.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < this.size(); ++x) {
            if (this.getLabel(x) != null) {
                sb.append(this.getLabel(x));
                sb.append("\t");
            }
            for (int y = 0; y < this.size(); ++y) {
                sb.append(this.get(x, y));
                sb.append("\t");
            }
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

