/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.tools.PhylogeneticInferenceOptions;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;

public class PhyloInferenceDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 8337543508238133614L;
    private final JPanel _pnl;
    private final JButton _launch_btn;
    private final JButton _cancel_btn;
    private final JFormattedTextField _bootstrap_tf;
    private final JCheckBox _bootstrap_cb;
    private final PhylogeneticInferenceOptions _opts;
    private JTextField _input_msa_file_tf;
    private JButton _select_input_msa_btn;
    private final MainFrameApplication _parent_frame;
    private JTextField _msa_length_tf;
    private JTextField _msa_size_tf;
    private JTextField _msa_type_tf;
    private final JRadioButton _distance_calc_kimura_rb;
    private final JRadioButton _distance_calc_poisson_rb;
    private final JRadioButton _distance_calc_fract_dissimilarity_rb;
    private int _value = 2;
    private JTextField _input_seqs_tf;
    private JButton _select_input_seqs_btn;
    private JTextField _input_seqs_number_tf;
    private JTextField _input_seqs_median_length_tf;
    private JTextField _input_seqs_min_length_tf;
    private JTextField _input_seqs_max_length_tf;
    private JTextField _input_seqs_type_tf;
    private JTextField _mafft_paramenters_tf;
    private JTextField _msa_processing_max_allowed_gap_ratio_tf;
    private JTextField _msa_processing_min_allowed_length_tf;
    private JTextField _random_seed_tf;
    private JCheckBox _execute_msa_processing_cb;
    private JCheckBox _msa_processing_remove_all_gap_columns_cb;
    private JCheckBox _mafft_cb;
    private JCheckBox _save_pwd_file_cb;
    private JCheckBox _save_processed_msa_cb;
    private JCheckBox _save_original_msa_cb;
    private JTextField _pwd_outfile_tf;
    private JTextField _processed_msa_outfile_tf;
    private JTextField _original_msa_outfile_tf;

    public PhyloInferenceDialog(MainFrameApplication frame, PhylogeneticInferenceOptions options, boolean from_unaligned_seqs) {
        super((Frame)frame, true);
        JPanel inputfile_pnl_2;
        JPanel inputfile_pnl_1;
        this.setVisible(false);
        this._parent_frame = frame;
        this._opts = options;
        this._pnl = new JPanel();
        this.getContentPane().add(this._pnl);
        BoxLayout box_layout = new BoxLayout(this._pnl, 3);
        this._pnl.setLayout(box_layout);
        if (from_unaligned_seqs) {
            this.setTitle("Phylogenetic Inference (including multiple sequence alignment)");
            inputfile_pnl_1 = new JPanel();
            inputfile_pnl_2 = new JPanel();
            JPanel inputfile_pnl_3 = new JPanel();
            JPanel inputfile_pnl_4 = new JPanel();
            inputfile_pnl_1.setLayout(new FlowLayout());
            inputfile_pnl_2.setLayout(new FlowLayout());
            inputfile_pnl_3.setLayout(new FlowLayout());
            inputfile_pnl_4.setLayout(new FlowLayout());
            inputfile_pnl_1.add(new JLabel("Input Sequence File:"));
            this._input_seqs_tf = new JTextField();
            inputfile_pnl_1.add(this._input_seqs_tf);
            this._select_input_seqs_btn = new JButton("Select Input File");
            inputfile_pnl_1.add(this._select_input_seqs_btn);
            inputfile_pnl_2.add(new JLabel("Sequences: "));
            inputfile_pnl_2.add(new JLabel("Number of Sequences:"));
            this._input_seqs_number_tf = new JTextField();
            inputfile_pnl_2.add(this._input_seqs_number_tf);
            inputfile_pnl_2.add(new JLabel("Length: median:"));
            this._input_seqs_median_length_tf = new JTextField();
            inputfile_pnl_2.add(this._input_seqs_median_length_tf);
            inputfile_pnl_2.add(new JLabel("min:"));
            this._input_seqs_min_length_tf = new JTextField();
            inputfile_pnl_2.add(this._input_seqs_min_length_tf);
            inputfile_pnl_2.add(new JLabel("max:"));
            this._input_seqs_max_length_tf = new JTextField();
            inputfile_pnl_2.add(this._input_seqs_max_length_tf);
            inputfile_pnl_2.add(new JLabel("Type:"));
            this._input_seqs_type_tf = new JTextField();
            inputfile_pnl_2.add(this._input_seqs_type_tf);
            this._mafft_cb = new JCheckBox("MAFFT");
            inputfile_pnl_3.add(this._mafft_cb);
            inputfile_pnl_3.add(new JLabel("Parameters: "));
            this._mafft_paramenters_tf = new JTextField();
            inputfile_pnl_3.add(this._mafft_paramenters_tf);
            this._input_seqs_median_length_tf.setColumns(4);
            this._input_seqs_min_length_tf.setColumns(4);
            this._input_seqs_max_length_tf.setColumns(4);
            this._input_seqs_number_tf.setColumns(4);
            this._input_seqs_type_tf.setColumns(2);
            this._input_seqs_tf.setColumns(20);
            this._input_seqs_tf.setEditable(false);
            this._input_seqs_median_length_tf.setEditable(false);
            this._input_seqs_min_length_tf.setEditable(false);
            this._input_seqs_max_length_tf.setEditable(false);
            this._input_seqs_number_tf.setEditable(false);
            this._input_seqs_type_tf.setEditable(false);
            this._mafft_paramenters_tf.setColumns(26);
            this._mafft_paramenters_tf.setText("--maxiterate 1000 --localpair");
            this._select_input_seqs_btn.addActionListener(this);
            this._pnl.add(inputfile_pnl_1);
            this._pnl.add(inputfile_pnl_2);
            this._pnl.add(inputfile_pnl_3);
            this._pnl.add(inputfile_pnl_4);
        } else {
            this.setTitle("Phylogenetic Inference (from already aligned sequences) ");
            inputfile_pnl_1 = new JPanel();
            inputfile_pnl_2 = new JPanel();
            inputfile_pnl_1.setLayout(new FlowLayout());
            inputfile_pnl_2.setLayout(new FlowLayout());
            inputfile_pnl_1.add(new JLabel("Input MSA File:"));
            this._input_msa_file_tf = new JTextField();
            inputfile_pnl_1.add(this._input_msa_file_tf);
            this._select_input_msa_btn = new JButton("Select Input File");
            inputfile_pnl_1.add(this._select_input_msa_btn);
            inputfile_pnl_2.add(new JLabel("MSA: "));
            inputfile_pnl_2.add(new JLabel("Number of Sequences:"));
            this._msa_size_tf = new JTextField();
            inputfile_pnl_2.add(this._msa_size_tf);
            inputfile_pnl_2.add(new JLabel("Length:"));
            this._msa_length_tf = new JTextField();
            inputfile_pnl_2.add(this._msa_length_tf);
            inputfile_pnl_2.add(new JLabel("Type:"));
            this._msa_type_tf = new JTextField();
            inputfile_pnl_2.add(this._msa_type_tf);
            this._msa_length_tf.setColumns(4);
            this._msa_size_tf.setColumns(4);
            this._msa_type_tf.setColumns(2);
            this._input_msa_file_tf.setColumns(20);
            this._input_msa_file_tf.setEditable(false);
            this._msa_length_tf.setEditable(false);
            this._msa_size_tf.setEditable(false);
            this._msa_type_tf.setEditable(false);
            this._select_input_msa_btn.addActionListener(this);
            this._pnl.add(inputfile_pnl_1);
            this._pnl.add(inputfile_pnl_2);
        }
        JPanel inputfile_pnl_4 = new JPanel();
        inputfile_pnl_4.setLayout(new FlowLayout());
        inputfile_pnl_4.add(new JLabel("MSA Processing: "));
        this._execute_msa_processing_cb = new JCheckBox("Process MSA");
        inputfile_pnl_4.add(this._execute_msa_processing_cb);
        this._msa_processing_remove_all_gap_columns_cb = new JCheckBox("Remove all gap columns");
        inputfile_pnl_4.add(this._msa_processing_remove_all_gap_columns_cb);
        inputfile_pnl_4.add(new JLabel("Max allowed gap ratio: "));
        this._msa_processing_max_allowed_gap_ratio_tf = new JTextField();
        inputfile_pnl_4.add(this._msa_processing_max_allowed_gap_ratio_tf);
        inputfile_pnl_4.add(new JLabel("Min allowed non-gap sequence length: "));
        this._msa_processing_min_allowed_length_tf = new JTextField();
        inputfile_pnl_4.add(this._msa_processing_min_allowed_length_tf);
        this._msa_processing_max_allowed_gap_ratio_tf.setColumns(4);
        this._msa_processing_min_allowed_length_tf.setColumns(4);
        LineBorder b = new LineBorder(Color.DARK_GRAY);
        inputfile_pnl_4.setBorder(b);
        this._pnl.add(inputfile_pnl_4);
        JPanel distance_calc_pnl_1 = new JPanel();
        distance_calc_pnl_1.setLayout(new FlowLayout());
        distance_calc_pnl_1.add(new JLabel("Distance calculation:"));
        this._distance_calc_kimura_rb = new JRadioButton("Kimura correction");
        distance_calc_pnl_1.add(this._distance_calc_kimura_rb);
        this._distance_calc_poisson_rb = new JRadioButton("Poisson");
        distance_calc_pnl_1.add(this._distance_calc_poisson_rb);
        this._distance_calc_fract_dissimilarity_rb = new JRadioButton("Fractional dissimilarity");
        distance_calc_pnl_1.add(this._distance_calc_fract_dissimilarity_rb);
        ButtonGroup distance_calc_group_1 = new ButtonGroup();
        distance_calc_group_1.add(this._distance_calc_kimura_rb);
        distance_calc_group_1.add(this._distance_calc_poisson_rb);
        distance_calc_group_1.add(this._distance_calc_fract_dissimilarity_rb);
        this._pnl.add(distance_calc_pnl_1);
        JPanel bootstrap_pnl = new JPanel();
        bootstrap_pnl.setLayout(new FlowLayout());
        this._bootstrap_cb = new JCheckBox("Perform Bootstrap Resampling");
        bootstrap_pnl.add(this._bootstrap_cb);
        bootstrap_pnl.add(new JLabel("Number of Bootstrap Samples:"));
        this._bootstrap_tf = new JFormattedTextField(AptxUtil.createMaskFormatter("###"));
        bootstrap_pnl.add(this._bootstrap_tf);
        this._bootstrap_tf.setColumns(4);
        bootstrap_pnl.add(new JLabel("Random Seed:"));
        this._random_seed_tf = new JTextField();
        bootstrap_pnl.add(this._random_seed_tf);
        this._random_seed_tf.setColumns(4);
        this._pnl.add(bootstrap_pnl);
        JPanel launch_pnl = new JPanel();
        launch_pnl.setLayout(new FlowLayout());
        this._launch_btn = new JButton("Go!");
        this._launch_btn.addActionListener(this);
        launch_pnl.add(this._launch_btn);
        this._cancel_btn = new JButton("Cancel");
        this._cancel_btn.addActionListener(this);
        launch_pnl.add(this._cancel_btn);
        this._pnl.add(launch_pnl);
        this.initializeValues(from_unaligned_seqs);
        this.pack();
        this.setLocationRelativeTo(this.getParentFrame());
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._select_input_msa_btn) {
            this.readInputFile();
        } else if (e.getSource() == this._select_input_seqs_btn) {
            this.readInputSeqsFile();
        } else if (e.getSource() == this._launch_btn) {
            this.launch();
        } else if (e.getSource() == this._cancel_btn) {
            this.cancel();
        }
    }

    public void activate() {
        this.setVisible(true);
    }

    private MainFrameApplication getParentFrame() {
        return this._parent_frame;
    }

    public PhylogeneticInferenceOptions getPhylogeneticInferenceOptions() {
        return this._opts;
    }

    public int getValue() {
        return this._value;
    }

    private void initializeValues(boolean from_unaligned_seqs) {
        this._value = 2;
        if (from_unaligned_seqs) {
            this.updateSeqsItems();
        } else {
            this.updateMsaItems();
        }
        this.updateMsaProcessingItem();
        this.updateDistanceCalcMethod();
        this._bootstrap_tf.setText(this.getPhylogeneticInferenceOptions().getBootstrapSamples() + "");
        this._random_seed_tf.setText(this.getPhylogeneticInferenceOptions().getRandomNumberGeneratorSeed() + "");
    }

    private void launch() {
        this.processPerformBootstrapResampling();
        if (this._bootstrap_cb.isSelected()) {
            this.processBootstrapSamplesNumber();
            this.processRandomNumberGeneratorSeed();
        }
        this.processMsaProcessing();
        this.processDistanceCalcMethod();
        this.processMsaPrgParameters();
        this.setVisible(false);
        this._value = 0;
    }

    private void cancel() {
        this.setVisible(false);
        this._value = 2;
    }

    private void processBootstrapSamplesNumber() {
        int bootstrap_samples = 0;
        try {
            bootstrap_samples = Integer.parseInt(this._bootstrap_tf.getText().trim());
        }
        catch (NumberFormatException e) {
            return;
        }
        if (bootstrap_samples >= 0) {
            this.getPhylogeneticInferenceOptions().setBootstrapSamples(bootstrap_samples);
        }
    }

    private void processRandomNumberGeneratorSeed() {
        long seed = 42L;
        try {
            seed = Long.parseLong(this._random_seed_tf.getText().trim());
        }
        catch (NumberFormatException e) {
            return;
        }
        this.getPhylogeneticInferenceOptions().setRandomNumberGeneratorSeed(seed);
    }

    private void processMsaProcessing() {
        this.getPhylogeneticInferenceOptions().setExecuteMsaProcessing(this._execute_msa_processing_cb.isSelected());
        this.getPhylogeneticInferenceOptions().setMsaProcessingRemoveAllGapColumns(this._msa_processing_remove_all_gap_columns_cb.isSelected());
        int min_length = -1;
        try {
            min_length = Integer.parseInt(this._msa_processing_min_allowed_length_tf.getText().trim());
        }
        catch (NumberFormatException e) {
            min_length = -1;
        }
        if (min_length > 0) {
            this.getPhylogeneticInferenceOptions().setMsaProcessingMinAllowedLength(min_length);
        }
        double msa_processing_max_allowed_gap_ratio = -1.0;
        try {
            msa_processing_max_allowed_gap_ratio = Double.parseDouble(this._msa_processing_max_allowed_gap_ratio_tf.getText().trim());
        }
        catch (NumberFormatException e) {
            msa_processing_max_allowed_gap_ratio = -1.0;
        }
        if (msa_processing_max_allowed_gap_ratio >= 0.0 && msa_processing_max_allowed_gap_ratio <= 1.0) {
            this.getPhylogeneticInferenceOptions().setMsaProcessingMaxAllowedGapRatio(msa_processing_max_allowed_gap_ratio);
        }
    }

    private void processDistanceCalcMethod() {
        if (this._distance_calc_kimura_rb != null && this._distance_calc_kimura_rb.isSelected()) {
            this.getPhylogeneticInferenceOptions().setPwdDistanceMethod(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.KIMURA_DISTANCE);
        } else if (this._distance_calc_poisson_rb != null && this._distance_calc_poisson_rb.isSelected()) {
            this.getPhylogeneticInferenceOptions().setPwdDistanceMethod(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.POISSON_DISTANCE);
        } else if (this._distance_calc_fract_dissimilarity_rb != null && this._distance_calc_fract_dissimilarity_rb.isSelected()) {
            this.getPhylogeneticInferenceOptions().setPwdDistanceMethod(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.FRACTIONAL_DISSIMILARITY);
        }
    }

    private void processPerformBootstrapResampling() {
        this.getPhylogeneticInferenceOptions().setPerformBootstrapResampling(this._bootstrap_cb.isSelected());
    }

    private void processMsaPrgParameters() {
        if (this._mafft_paramenters_tf != null) {
            this.getPhylogeneticInferenceOptions().setMsaPrgParameters(this._mafft_paramenters_tf.getText());
        }
    }

    private void readInputFile() {
        this.getParentFrame().readMsaFromFile();
        this.updateMsaItems();
    }

    private void readInputSeqsFile() {
        this.getParentFrame().readSeqsFromFileforPI();
        this.updateSeqsItems();
    }

    private void updateDistanceCalcMethod() {
        switch (this.getPhylogeneticInferenceOptions().getPwdDistanceMethod()) {
            case KIMURA_DISTANCE: {
                this._distance_calc_kimura_rb.setSelected(true);
                break;
            }
            case POISSON_DISTANCE: {
                this._distance_calc_poisson_rb.setSelected(true);
                break;
            }
            case FRACTIONAL_DISSIMILARITY: {
                this._distance_calc_fract_dissimilarity_rb.setSelected(true);
                break;
            }
            default: {
                throw new RuntimeException("invalid distance calc method");
            }
        }
    }

    private void updateMsaProcessingItem() {
        this._execute_msa_processing_cb.setSelected(this.getPhylogeneticInferenceOptions().isExecuteMsaProcessing());
        this._msa_processing_remove_all_gap_columns_cb.setSelected(this.getPhylogeneticInferenceOptions().isMsaProcessingRemoveAllGapColumns());
        if (this._opts.getMsaProcessingMaxAllowedGapRatio() > 0.0) {
            this._msa_processing_max_allowed_gap_ratio_tf.setText(this._opts.getMsaProcessingMaxAllowedGapRatio() + "");
        }
        if (this._opts.getMsaProcessingMinAllowedLength() > 0) {
            this._msa_processing_min_allowed_length_tf.setText(this._opts.getMsaProcessingMinAllowedLength() + "");
        }
    }

    private void updateMsaItems() {
        if (this.getParentFrame().getMsa() != null) {
            this._input_msa_file_tf.setText(this.getParentFrame().getMsaFile().toString());
            this._msa_length_tf.setText(this.getParentFrame().getMsa().getLength() + "");
            this._msa_size_tf.setText(this.getParentFrame().getMsa().getNumberOfSequences() + "");
            this._msa_type_tf.setText((Object)((Object)this.getParentFrame().getMsa().getType()) + "");
            this._input_msa_file_tf.setEnabled(true);
            this._msa_length_tf.setEnabled(true);
            this._msa_size_tf.setEnabled(true);
            this._msa_type_tf.setEnabled(true);
            this._launch_btn.setEnabled(true);
        } else {
            this._input_msa_file_tf.setText("");
            this._msa_length_tf.setText("");
            this._msa_size_tf.setText("");
            this._msa_type_tf.setText("");
            this._input_msa_file_tf.setEnabled(false);
            this._msa_length_tf.setEnabled(false);
            this._msa_size_tf.setEnabled(false);
            this._msa_type_tf.setEnabled(false);
            this._launch_btn.setEnabled(false);
        }
    }

    private void updateSeqsItems() {
        if (this.getParentFrame().getSeqs() != null) {
            DescriptiveStatistics stats = this.calcSequenceStats(this.getParentFrame().getSeqs());
            this._input_seqs_tf.setText(this.getParentFrame().getSeqsFile().toString());
            this._input_seqs_median_length_tf.setText((int)stats.median() + "");
            this._input_seqs_min_length_tf.setText((int)stats.getMin() + "");
            this._input_seqs_max_length_tf.setText((int)stats.getMax() + "");
            this._input_seqs_number_tf.setText(this.getParentFrame().getSeqs().size() + "");
            this._input_seqs_type_tf.setText((Object)((Object)this.getParentFrame().getSeqs().get(0).getType()) + "");
            this._input_seqs_tf.setEnabled(true);
            this._input_seqs_median_length_tf.setEnabled(true);
            this._input_seqs_min_length_tf.setEnabled(true);
            this._input_seqs_max_length_tf.setEnabled(true);
            this._input_seqs_number_tf.setEnabled(true);
            this._input_seqs_type_tf.setEnabled(true);
            this._launch_btn.setEnabled(true);
        } else {
            this._input_seqs_tf.setText("");
            this._input_seqs_median_length_tf.setText("");
            this._input_seqs_min_length_tf.setText("");
            this._input_seqs_max_length_tf.setText("");
            this._input_seqs_number_tf.setText("");
            this._input_seqs_type_tf.setText("");
            this._input_seqs_tf.setEnabled(false);
            this._input_seqs_median_length_tf.setEnabled(false);
            this._input_seqs_min_length_tf.setEnabled(false);
            this._input_seqs_max_length_tf.setEnabled(false);
            this._input_seqs_number_tf.setEnabled(false);
            this._input_seqs_type_tf.setEnabled(false);
            this._launch_btn.setEnabled(false);
        }
    }

    DescriptiveStatistics calcSequenceStats(List<MolecularSequence> seqs) {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (MolecularSequence s : seqs) {
            stats.addValue(s.getLength());
        }
        return stats;
    }
}

