/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class shared_chars_in_ext_nodes {
    static final boolean SIMPLE = true;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println();
            System.err.println("shared_chars_in_ext_nodes: wrong number of arguments");
            System.err.println("Usage: \"shared_chars_in_ext_nodes <intree> <node name>");
            System.err.println();
            System.exit(-1);
        }
        File infile = new File(args[0]);
        String node_name = args[1];
        Phylogeny phy = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            phy = factory.create(infile, ParserUtils.createParserDependingOnFileType(infile, true))[0];
        }
        catch (Exception e) {
            System.err.println(e + "\nCould not read " + infile + "\n");
            System.exit(-1);
        }
        SortedSet<String> a = phy.getNode(node_name).getNodeData().getBinaryCharacters().getGainedCharacters();
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            SortedSet<String> b = n.getNodeData().getBinaryCharacters().getGainedCharacters();
            SortedSet<String> a_copy = shared_chars_in_ext_nodes.copy(a);
            a_copy.retainAll(b);
            double ratio = (double)a_copy.size() / (double)b.size();
            System.out.println(n.getName() + "\t\"" + a_copy.size() + "/" + b.size() + "\"\t" + ratio);
        }
    }

    private static SortedSet<String> copy(SortedSet<String> set) {
        TreeSet<String> copy = new TreeSet<String>();
        for (String i : set) {
            copy.add(i);
        }
        return copy;
    }
}

