/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public class get_subtree_specific_chars {
    static final boolean SIMPLE = true;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println();
            System.err.println("get_subtree_specific_chars: wrong number of arguments");
            System.err.println("Usage: \"get_subtree_specific_chars <intree>");
            System.err.println();
            System.exit(-1);
        }
        File infile = new File(args[0]);
        Phylogeny phy = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            phy = factory.create(infile, ParserUtils.createParserDependingOnFileType(infile, true))[0];
        }
        catch (Exception e) {
            System.err.println(e + "\nCould not read " + infile + "\n");
            System.exit(-1);
        }
        SortedSet<Long> all_external_ids = get_subtree_specific_chars.getAllExternalDescendantsNodeIds(phy.getRoot());
        SortedSet<String> all_chars = get_subtree_specific_chars.getAllExternalPresentAndGainedCharacters(phy.getRoot());
        System.out.println("Sum of all external characters:\t" + all_chars.size());
        System.out.println();
        PhylogenyNodeIterator iter = phy.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.isRoot()) continue;
            if (node.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getScientificName())) {
                System.out.print(node.getNodeData().getTaxonomy().getScientificName());
            } else {
                System.out.print(node.getName());
            }
            System.out.print("\t");
            SortedSet<Long> external_ids = get_subtree_specific_chars.getAllExternalDescendantsNodeIds(node);
            SortedSet<Long> not_external_ids = get_subtree_specific_chars.copy(all_external_ids);
            not_external_ids.removeAll(external_ids);
            TreeSet<String> not_node_chars = new TreeSet<String>();
            for (Long id : not_external_ids) {
                not_node_chars.addAll(get_subtree_specific_chars.getAllExternalPresentAndGainedCharacters(phy.getNode(id)));
            }
            SortedSet<String> node_chars = get_subtree_specific_chars.getAllExternalPresentAndGainedCharacters(node);
            TreeSet<String> unique_chars = new TreeSet<String>();
            for (String node_char : node_chars) {
                if (not_node_chars.contains(node_char)) continue;
                unique_chars.add(node_char);
            }
            int counter = 0;
            System.out.print("\t" + unique_chars.size());
            for (String unique_char : unique_chars) {
                System.out.print("\t" + unique_char);
                ++counter;
            }
            System.out.println();
        }
    }

    private static SortedSet<Long> copy(SortedSet<Long> set) {
        TreeSet<Long> copy = new TreeSet<Long>();
        for (Long i : set) {
            copy.add(i);
        }
        return copy;
    }

    private static SortedSet<Long> getAllExternalDescendantsNodeIds(PhylogenyNode node) {
        TreeSet<Long> ids = new TreeSet<Long>();
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        for (PhylogenyNode desc : descs) {
            ids.add(desc.getId());
        }
        return ids;
    }

    private static SortedSet<String> getAllExternalPresentAndGainedCharacters(PhylogenyNode node) {
        TreeSet<String> chars = new TreeSet<String>();
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        for (PhylogenyNode desc : descs) {
            chars.addAll(desc.getNodeData().getBinaryCharacters().getGainedCharacters());
            chars.addAll(desc.getNodeData().getBinaryCharacters().getPresentCharacters());
        }
        return chars;
    }
}

