/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;

public class get_distances {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("\nget_distances: Wrong number of arguments.\n");
            System.out.println("Usage: \"get_distances <phylogeny file> <file with node names> <outfile>\"\n");
            System.exit(-1);
        }
        File phylogeny_infile = new File(args[0]);
        File names_infile = new File(args[1]);
        File outfile = new File(args[2]);
        Phylogeny p = null;
        try {
            PhylogenyParser pp = ParserUtils.createParserDependingOnFileType(phylogeny_infile, true);
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            p = factory.create(phylogeny_infile, pp)[0];
        }
        catch (Exception e) {
            System.out.println("\nCould not read \"" + phylogeny_infile + "\" [" + e.getMessage() + "]\n");
            System.exit(-1);
        }
        String line = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(names_infile));
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            while ((line = in.readLine()) != null) {
                StringTokenizer st;
                if (line.length() < 3 || (st = new StringTokenizer(line)).countTokens() < 2) continue;
                double d = PhylogenyMethods.calculateDistance(p.getNode(st.nextToken()), p.getNode(st.nextToken()));
                out.write(line + " " + d);
                out.newLine();
            }
            out.flush();
            out.close();
            in.close();
        }
        catch (IOException e) {
            System.out.println("\nError during processing of \"" + names_infile + "\" [" + e.getMessage() + "] at line \"" + line + "\"\n");
            System.exit(-1);
        }
        System.out.println("\nDone.\n");
    }
}

