/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class pfam_go {
    private static final String ALLOW_DUPLICATES_OPTION = "d";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_NAME = "pfam_go";
    private static final String PRG_VERSION = "1.10";
    private static final String PRG_DATE = "2011.06.26";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org";

    private static void process(File pfams_file, List<PfamToGoMapping> mappings, boolean allow_duplicates) throws IOException {
        BufferedReader reader = ForesterUtil.obtainReader(pfams_file);
        String line = "";
        int found_count = 0;
        int not_found_count = 0;
        AbstractCollection encountered_domains = null;
        encountered_domains = allow_duplicates ? new ArrayList() : new HashSet();
        while ((line = reader.readLine()) != null) {
            if (ForesterUtil.isEmpty(line = line.trim()) || line.startsWith("##")) continue;
            if (line.startsWith("#")) {
                encountered_domains.clear();
                line = line.replace('#', '>');
                System.out.println(line);
                continue;
            }
            if (allow_duplicates || !encountered_domains.contains(line)) {
                encountered_domains.add(line);
                boolean found = false;
                for (PfamToGoMapping mapping : mappings) {
                    if (!mapping.getKey().equals(line)) continue;
                    System.out.println(mapping.getValue());
                    found = true;
                }
                if (found) {
                    ++found_count;
                    continue;
                }
                ++not_found_count;
                continue;
            }
            System.err.println("# duplicate domain: " + line);
        }
        System.out.println("# pfams with mapping to GO   : " + found_count);
        System.out.println("# pfams without mapping to GO: " + not_found_count);
        reader.close();
    }

    public static void main(String[] args) {
        String dissallowed_options;
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || args.length == 0) {
            pfam_go.printHelp();
            System.exit(0);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(ALLOW_DUPLICATES_OPTION);
        if (cla.getNumberOfNames() != 2 && cla.getNumberOfNames() != 3) {
            pfam_go.printHelp();
            System.exit(-1);
        }
        if ((dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        File pfam2go_file = cla.getFile(0);
        File pfams_file = cla.getFile(1);
        boolean allow_duplicates = false;
        if (cla.isOptionSet(ALLOW_DUPLICATES_OPTION)) {
            allow_duplicates = true;
        }
        PfamToGoParser pfam2go_parser = new PfamToGoParser(pfam2go_file);
        List<PfamToGoMapping> mappings = null;
        try {
            mappings = pfam2go_parser.parse();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            pfam_go.process(pfams_file, mappings, allow_duplicates);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println();
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        System.out.println("Usage:");
        System.out.println();
        System.out.println("pfam_go [-d to allow duplicates] <pfam2go file> <file with pfams>");
        System.out.println();
        System.out.println();
    }
}

