/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sdi.GSDI;
import org.forester.sdi.GSDII;
import org.forester.sdi.GSDIR;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIutil;
import org.forester.util.CommandLineArguments;
import org.forester.util.EasyWriter;
import org.forester.util.ForesterUtil;

public final class gsdi {
    public static final boolean REPLACE_UNDERSCORES_IN_NH_SPECIES_TREE = true;
    private static final String ALLOW_STRIPPING_OF_GENE_TREE_OPTION = "g";
    private static final String GSDIR_OPTION = "r";
    private static final String MOST_PARSIMONIOUS_OPTION = "m";
    private static final String GUESS_FORMAT_OF_SPECIES_TREE = "q";
    private static final String TRANSFER_TAXONOMY_OPTION = "t";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String SUFFIX_FOR_SPECIES_TREE_USED = "_species_tree_used.xml";
    private static final String LOGFILE_SUFFIX = "_gsdi_log.txt";
    private static final String REMAPPED_SUFFIX = "_gsdi_remapped.txt";
    private static final String PRG_NAME = "gsdi";
    private static final String PRG_VERSION = "1.001";
    private static final String PRG_DATE = "130325";
    private static final String PRG_DESC = "general speciation duplication inference";
    private static final String E_MAIL = "phylosoft@gmail.com";
    private static final String WWW = "https://sites.google.com/site/cmzmasek/home/software/forester";

    public static void main(String[] args) {
        try {
            ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
            CommandLineArguments cla = null;
            try {
                cla = new CommandLineArguments(args);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
            if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2)) {
                System.out.println();
                gsdi.print_help();
                System.exit(0);
            } else if (args.length < 2 || cla.getNumberOfNames() != 3) {
                System.out.println();
                System.out.println("Wrong number of arguments.");
                System.out.println();
                gsdi.print_help();
                System.exit(-1);
            }
            ArrayList<String> allowed_options = new ArrayList<String>();
            allowed_options.add(GSDIR_OPTION);
            allowed_options.add(GUESS_FORMAT_OF_SPECIES_TREE);
            allowed_options.add(MOST_PARSIMONIOUS_OPTION);
            allowed_options.add(ALLOW_STRIPPING_OF_GENE_TREE_OPTION);
            allowed_options.add(TRANSFER_TAXONOMY_OPTION);
            String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
            if (dissallowed_options.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
            }
            gsdi.execute(cla);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
    }

    private static void execute(CommandLineArguments cla) throws IOException {
        SDIutil.ALGORITHM base_algorithm = SDIutil.ALGORITHM.GSDI;
        boolean most_parsimonous_duplication_model = false;
        boolean allow_stripping_of_gene_tree = false;
        if (cla.isOptionSet(GSDIR_OPTION)) {
            base_algorithm = SDIutil.ALGORITHM.GSDIR;
        }
        if (cla.isOptionSet(MOST_PARSIMONIOUS_OPTION)) {
            if (base_algorithm == SDIutil.ALGORITHM.SDI) {
                ForesterUtil.fatalError(PRG_NAME, "Cannot use most parsimonious duplication mode with SDI");
            }
            most_parsimonous_duplication_model = true;
        }
        if (cla.isOptionSet(ALLOW_STRIPPING_OF_GENE_TREE_OPTION)) {
            if (base_algorithm == SDIutil.ALGORITHM.SDI) {
                ForesterUtil.fatalError(PRG_NAME, "Cannot allow stripping of gene tree with SDI");
            }
            allow_stripping_of_gene_tree = true;
        }
        boolean transfer_taxonomy = false;
        if (cla.isOptionSet(TRANSFER_TAXONOMY_OPTION)) {
            transfer_taxonomy = true;
        }
        Phylogeny species_tree = null;
        Phylogeny gene_tree = null;
        File gene_tree_file = null;
        File species_tree_file = null;
        File out_file = null;
        File log_file = null;
        EasyWriter log_writer = null;
        try {
            gene_tree_file = cla.getFile(0);
            species_tree_file = cla.getFile(1);
            out_file = cla.getFile(2);
            log_file = new File(ForesterUtil.removeSuffix(out_file.toString()) + LOGFILE_SUFFIX);
        }
        catch (IllegalArgumentException e) {
            ForesterUtil.fatalError(PRG_NAME, "error in command line: " + e.getMessage());
        }
        if (ForesterUtil.isReadableFile(gene_tree_file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(gene_tree_file));
        }
        if (ForesterUtil.isReadableFile(species_tree_file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(species_tree_file));
        }
        if (ForesterUtil.isWritableFile(out_file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(out_file));
        }
        if (ForesterUtil.isWritableFile(log_file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(log_file));
        }
        try {
            log_writer = ForesterUtil.createEasyWriter(log_file);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to create [" + log_file + "]: " + e.getMessage());
        }
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            gene_tree = factory.create(gene_tree_file, PhyloXmlParser.createPhyloXmlParserXsdValidating())[0];
        }
        catch (IOException e) {
            gsdi.fatalError("error", "failed to read gene tree from [" + gene_tree_file + "]: " + e.getMessage(), log_writer);
        }
        try {
            species_tree = SDIutil.parseSpeciesTree(gene_tree, species_tree_file, true, true, NHXParser.TAXONOMY_EXTRACTION.NO);
        }
        catch (PhyloXmlDataFormatException e) {
            gsdi.fatalError("user error", "failed to transfer general node name, in [" + species_tree_file + "]: " + e.getMessage(), log_writer);
        }
        catch (SDIException e) {
            gsdi.fatalError("user error", e.getMessage(), log_writer);
        }
        catch (IOException e) {
            gsdi.fatalError("error", "Failed to read species tree from [" + species_tree_file + "]: " + e.getMessage(), log_writer);
        }
        gene_tree.setRooted(true);
        species_tree.setRooted(true);
        if (!gene_tree.isCompletelyBinary()) {
            gsdi.fatalError("user error", "gene tree is not completely binary", log_writer);
        }
        if (base_algorithm == SDIutil.ALGORITHM.SDI && !species_tree.isCompletelyBinary()) {
            gsdi.fatalError("user error", "species tree is not completely binary, use GSDI or GSDIR instead", log_writer);
        }
        log_writer.println("gsdi - general speciation duplication inference");
        log_writer.println("  version         : 1.001");
        log_writer.println("  date            : 130325");
        log_writer.println("  forester version: 1.039");
        log_writer.println();
        log_writer.println("Start time                               : " + new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(new Date()));
        System.out.println("Start time                               : " + new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(new Date()));
        log_writer.println("Gene tree file                           : " + gene_tree_file.getCanonicalPath());
        System.out.println("Gene tree file                           : " + gene_tree_file.getCanonicalPath());
        log_writer.println("Gene tree name                           : " + (ForesterUtil.isEmpty(gene_tree.getName()) ? "" : gene_tree.getName()));
        System.out.println("Gene tree name                           : " + (ForesterUtil.isEmpty(gene_tree.getName()) ? "" : gene_tree.getName()));
        log_writer.println("Species tree file                        : " + species_tree_file.getCanonicalPath());
        System.out.println("Species tree file                        : " + species_tree_file.getCanonicalPath());
        log_writer.println("Species tree name                        : " + (ForesterUtil.isEmpty(species_tree.getName()) ? "" : gene_tree.getName()));
        System.out.println("Species tree name                        : " + (ForesterUtil.isEmpty(species_tree.getName()) ? "" : gene_tree.getName()));
        System.out.println("Transfer taxonomy                        : " + transfer_taxonomy);
        GSDII gsdii = null;
        long start_time = new Date().getTime();
        try {
            if (base_algorithm == SDIutil.ALGORITHM.GSDI) {
                System.out.println("Algorithm                                : GSDI");
                log_writer.println("Algorithm                                : GSDI");
            } else if (base_algorithm == SDIutil.ALGORITHM.GSDIR) {
                System.out.println("Algorithm                                : GSDIR");
                log_writer.println("Algorithm                                : GSDIR");
            }
            System.out.println("Use most parsimonous duplication model   : " + most_parsimonous_duplication_model);
            System.out.println("Allow stripping of gene tree nodes       : " + allow_stripping_of_gene_tree);
            log_writer.println("Use most parsimonous duplication model   : " + most_parsimonous_duplication_model);
            log_writer.println("Allow stripping of gene tree nodes       : " + allow_stripping_of_gene_tree);
            log_writer.flush();
            if (base_algorithm == SDIutil.ALGORITHM.GSDI) {
                gsdii = new GSDI(gene_tree, species_tree, most_parsimonous_duplication_model, allow_stripping_of_gene_tree, true, transfer_taxonomy);
            } else if (base_algorithm == SDIutil.ALGORITHM.GSDIR) {
                gsdii = new GSDIR(gene_tree, species_tree, allow_stripping_of_gene_tree, true, transfer_taxonomy);
            }
        }
        catch (SDIException e) {
            gsdi.fatalError("user error", e.getLocalizedMessage(), log_writer);
        }
        catch (IOException e) {
            gsdi.fatalError("error", e.toString(), log_writer);
        }
        catch (OutOfMemoryError e) {
            ForesterUtil.outOfMemoryError(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            gsdi.fatalError("unexpected error", e.toString(), log_writer);
        }
        System.out.println("Running time (excluding I/O)             : " + (new Date().getTime() - start_time) + "ms");
        log_writer.println("Running time (excluding I/O)             : " + (new Date().getTime() - start_time) + "ms");
        System.out.println("Mapping based on                         : " + (Object)((Object)gsdii.getTaxCompBase()));
        log_writer.println("Mapping based on                         : " + (Object)((Object)gsdii.getTaxCompBase()));
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            if (base_algorithm == SDIutil.ALGORITHM.GSDIR) {
                writer.toPhyloXML(out_file, ((GSDIR)gsdii).getMinDuplicationsSumGeneTree(), 0);
            } else {
                writer.toPhyloXML(out_file, gene_tree, 0);
            }
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write to [" + out_file.getCanonicalPath() + "]: " + e.getMessage());
        }
        System.out.println("Wrote resulting gene tree to             : " + out_file.getCanonicalPath());
        log_writer.println("Wrote resulting gene tree to             : " + out_file.getCanonicalPath());
        File species_tree_used_file = new File(ForesterUtil.removeSuffix(out_file.toString()) + SUFFIX_FOR_SPECIES_TREE_USED);
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toPhyloXML(species_tree_used_file, species_tree, 0);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write to [" + species_tree_used_file.getCanonicalPath() + "]: " + e.getMessage());
        }
        System.out.println("Wrote (stripped) species tree to         : " + species_tree_used_file.getCanonicalPath());
        log_writer.println("Wrote (stripped) species tree to         : " + species_tree_used_file.getCanonicalPath());
        if (gsdii.getReMappedScientificNamesFromGeneTree() != null && !gsdii.getReMappedScientificNamesFromGeneTree().isEmpty()) {
            System.out.println("Number of gene tree species remapped     : " + gsdii.getReMappedScientificNamesFromGeneTree().size());
            log_writer.println("Number of gene tree species remapped     : " + gsdii.getReMappedScientificNamesFromGeneTree().size());
            gsdi.writeToRemappedFile(out_file, gsdii.getReMappedScientificNamesFromGeneTree(), log_writer);
        }
        System.out.println("Number of external nodes in gene tree    : " + gene_tree.getNumberOfExternalNodes());
        log_writer.println("Number of external nodes in gene tree    : " + gene_tree.getNumberOfExternalNodes());
        System.out.println("Number of external nodes in species tree : " + species_tree.getNumberOfExternalNodes());
        log_writer.println("Number of external nodes in species tree : " + species_tree.getNumberOfExternalNodes());
        int poly = PhylogenyMethods.countNumberOfPolytomies(species_tree);
        System.out.println("Number of polytomies in species tree     : " + poly);
        log_writer.println("Number of polytomies in species tree     : " + poly);
        System.out.println("External nodes stripped from gene tree   : " + gsdii.getStrippedExternalGeneTreeNodes().size());
        log_writer.println("External nodes stripped from gene tree   : " + gsdii.getStrippedExternalGeneTreeNodes().size());
        System.out.println("External nodes stripped from species tree: " + gsdii.getStrippedSpeciesTreeNodes().size());
        log_writer.println("External nodes stripped from species tree: " + gsdii.getStrippedSpeciesTreeNodes().size());
        System.out.println();
        System.out.println("Number of speciations                    : " + gsdii.getSpeciationsSum());
        log_writer.println("Number of speciations                    : " + gsdii.getSpeciationsSum());
        if (base_algorithm == SDIutil.ALGORITHM.GSDIR) {
            GSDIR gsdir = (GSDIR)gsdii;
            System.out.println("Minimal number of duplications           : " + gsdir.getMinDuplicationsSum());
            log_writer.println("Minimal number of duplications           : " + gsdir.getMinDuplicationsSum());
        } else if (base_algorithm == SDIutil.ALGORITHM.GSDI) {
            GSDI gsdi2 = (GSDI)gsdii;
            System.out.println("Number of duplications                   : " + gsdi2.getDuplicationsSum());
            log_writer.println("Number of duplications                   : " + gsdi2.getDuplicationsSum());
            if (!most_parsimonous_duplication_model) {
                int u = gsdi2.getSpeciationOrDuplicationEventsSum();
                System.out.println("Number of potential duplications         : " + u);
                log_writer.println("Number of potential duplications         : " + u);
            }
        }
        log_writer.println();
        gsdi.printMappedNodesToLog(log_writer, gsdii);
        log_writer.println();
        gsdi.printStrippedGeneTreeNodesToLog(log_writer, gsdii);
        System.out.println();
        System.out.println("Wrote log to                             : " + log_file.getCanonicalPath());
        System.out.println();
        log_writer.close();
    }

    private static void fatalError(String type, String msg, EasyWriter log_writer) {
        try {
            log_writer.flush();
            log_writer.println();
            log_writer.print(type.toUpperCase() + ": ");
            log_writer.println(msg);
            log_writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ForesterUtil.fatalError(PRG_NAME, msg);
    }

    private static void print_help() {
        System.out.println("Usage: gsdi [-options] <gene tree in phyloXML format> <species tree> <outfile>");
        System.out.println();
        System.out.println("Options:");
        System.out.println(" -g: to allow stripping of gene tree nodes without a matching species");
        System.out.println(" -m: use most parimonious duplication model for GSDI: ");
        System.out.println("     assign nodes as speciations which would otherwise be assiged");
        System.out.println("     as potential duplications due to polytomies in the species tree");
        System.out.println(" -q: to allow species tree in other formats than phyloXML (i.e. Newick, NHX, Nexus)");
        System.out.println(" -r: to use GSDIR algorithm instead of GSDI algorithm (re-rooting)");
        System.out.println(" -t: to transfer taxonomic data from species tree to gene tree\n");
        System.out.println();
        System.out.println("Gene tree:");
        System.out.println(" in phyloXM format, with taxonomy and sequence data in appropriate fields");
        System.out.println();
        System.out.println("Species tree:");
        System.out.println(" in phyloXML format (unless option -q is used)");
        System.out.println();
        System.out.println("Example: gsdi -g gene_tree.xml tree_of_life.xml out.xml");
        System.out.println();
    }

    private static void printMappedNodesToLog(EasyWriter log_writer, GSDII gsdi2) throws IOException {
        TreeSet<String> ss = new TreeSet<String>();
        for (PhylogenyNode n : gsdi2.getMappedExternalSpeciesTreeNodes()) {
            ss.add(n.toString());
        }
        log_writer.println("The following " + ss.size() + " species were used: ");
        for (String s : ss) {
            log_writer.println("  " + s);
        }
    }

    private static void printStrippedGeneTreeNodesToLog(EasyWriter log_writer, GSDII gsdi2) throws IOException {
        TreeMap<String, Integer> sm = new TreeMap<String, Integer>();
        for (PhylogenyNode n : gsdi2.getStrippedExternalGeneTreeNodes()) {
            String s = n.toString();
            if (sm.containsKey(s)) {
                sm.put(s, (Integer)sm.get(s) + 1);
                continue;
            }
            sm.put(s, 1);
        }
        log_writer.println("The following " + sm.size() + " nodes were stripped from the gene tree: ");
        for (String s : sm.keySet()) {
            int count = (Integer)sm.get(s);
            if (count == 1) {
                log_writer.println("  " + s);
                continue;
            }
            log_writer.println("  " + s + " [" + count + "]");
        }
    }

    private static void writeToRemappedFile(File out_file, SortedSet<String> remapped, EasyWriter log_writer) throws IOException {
        File file = new File(ForesterUtil.removeSuffix(out_file.toString()) + REMAPPED_SUFFIX);
        EasyWriter remapped_writer = ForesterUtil.createEasyWriter(file);
        for (String s : remapped) {
            remapped_writer.println(s);
        }
        remapped_writer.close();
        System.out.println("Wrote remapped gene tree species to      : " + file.getCanonicalPath());
        log_writer.println("Wrote remapped gene tree species to      : " + file.getCanonicalPath());
    }
}

