/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.forester.analysis.AncestralTaxonomyInference;
import org.forester.analysis.AncestralTaxonomyInferenceException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.SequenceDbWsTools;

public final class annotator {
    private static final String PRG_NAME = "annotator";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "131122";

    public static void main(String[] args) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        if (args.length != 2) {
            annotator.argumentsError();
        }
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        File indir = cla.getFile(0);
        File outdir = cla.getFile(1);
        if (!indir.isDirectory()) {
            ForesterUtil.fatalError(PRG_NAME, indir + " is not a directory");
        }
        if (!outdir.isDirectory()) {
            ForesterUtil.fatalError(PRG_NAME, outdir + " is not a directory");
        }
        File[] list_of_files = indir.listFiles();
        ArrayList<File> infiles = new ArrayList<File>();
        for (File file : list_of_files) {
            if (!file.isFile() || !file.canRead() || !file.toString().toLowerCase().endsWith(".xml")) continue;
            infiles.add(file);
        }
        Collections.sort(infiles);
        int c = 0;
        for (File infile : infiles) {
            System.out.println(++c + "/" + infiles.size() + ": " + infile);
            File outfile = new File(outdir.getAbsolutePath().toString() + "/" + infile.getName());
            if (outfile.exists()) {
                System.out.println(outfile + " already exists");
                continue;
            }
            Phylogeny phy = null;
            try {
                PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                Phylogeny[] phylogenies = factory.create(infile, PhyloXmlParser.createPhyloXmlParserXsdValidating());
                phy = phylogenies[0];
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read phylgenies from [" + infile + "] [" + e.getMessage() + "]");
            }
            try {
                annotator.obtainSeqInformation(phy);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
            try {
                PhylogenyWriter w = new PhylogenyWriter();
                w.toPhyloXML(phy, 0, outfile);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to write output [" + e.getMessage() + "]");
            }
        }
    }

    private static void obtainSeqInformation(Phylogeny phy) throws IOException {
        SequenceDbWsTools.obtainSeqInformation(phy, true, true, 4000);
    }

    private static void inferTaxonomyFromDescendents(Phylogeny phy) throws IOException, AncestralTaxonomyInferenceException {
        AncestralTaxonomyInference.inferTaxonomyFromDescendents(phy);
    }

    private static void argumentsError() {
        System.out.println("annotator <indir> <outdir>");
        System.out.println();
        System.exit(-1);
    }
}

