/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.yui.calendar;

import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.datetime.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.joda.time.MutableDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateField
extends FormComponentPanel<Date> {
    private static final long serialVersionUID = 1L;
    private MutableDateTime date;
    private DateTextField dateField;

    public DateField(String id) {
        this(id, null);
    }

    public DateField(String id, IModel<Date> model) {
        super(id, model);
        this.setType(Date.class);
    }

    public Date getDate() {
        return this.date != null ? this.date.toDate() : null;
    }

    public String getInput() {
        return this.dateField.getInput();
    }

    public void setDate(Date date) {
        this.date = date != null ? new MutableDateTime((Object)date) : null;
        this.setDefaultModelObject(date);
    }

    protected void convertInput() {
        this.setConvertedInput(this.dateField.getConvertedInput());
    }

    @Deprecated
    protected final DateTextField newDateTextField(PropertyModel dateFieldModel) {
        throw new UnsupportedOperationException();
    }

    protected DateTextField newDateTextField(String id, PropertyModel dateFieldModel) {
        return DateTextField.forShortStyle(id, (IModel<Date>)dateFieldModel);
    }

    protected void onBeforeRender() {
        if (this.dateField == null) {
            PropertyModel dateFieldModel = new PropertyModel((Object)this, "date");
            Component[] componentArray = new Component[1];
            this.dateField = this.newDateTextField("date", dateFieldModel);
            componentArray[0] = this.dateField;
            this.add(componentArray);
            this.dateField.add(new IBehavior[]{this.newDatePicker()});
        }
        this.dateField.setRequired(this.isRequired());
        Date d = (Date)this.getDefaultModelObject();
        this.date = d != null ? new MutableDateTime((Object)d) : null;
        super.onBeforeRender();
    }

    protected DatePicker newDatePicker() {
        return new DatePicker();
    }
}

