/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.common.deployer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.tomcat.maven.common.deployer.TomcatManagerException;
import org.apache.tomcat.maven.common.deployer.TomcatManagerResponse;

public class TomcatManager {
    private static final String MANAGER_CHARSET = "UTF-8";
    private URL url;
    private String username;
    private String password;
    private String charset;
    private String userAgent;
    private DefaultHttpClient httpClient;
    private BasicHttpContext localContext;

    public TomcatManager(URL url) {
        this(url, "admin");
    }

    public TomcatManager(URL url, String username) {
        this(url, username, "");
    }

    public TomcatManager(URL url, String username, String password) {
        this(url, username, password, "ISO-8859-1");
    }

    public TomcatManager(URL url, String username, String password, String charset) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.charset = charset;
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)new BasicClientConnectionManager());
        if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            String host = url.getHost();
            int port = url.getPort() > -1 ? url.getPort() : -1;
            this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)creds);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            HttpHost targetHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            authCache.put(targetHost, (AuthScheme)basicAuth);
            this.localContext = new BasicHttpContext();
            this.localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public TomcatManagerResponse deploy(String path, URL war) throws TomcatManagerException, IOException {
        return this.deploy(path, war, false);
    }

    public TomcatManagerResponse deploy(String path, URL war, boolean update) throws TomcatManagerException, IOException {
        return this.deploy(path, war, update, null);
    }

    public TomcatManagerResponse deploy(String path, URL war, boolean update, String tag) throws TomcatManagerException, IOException {
        return this.deployImpl(path, null, war, null, update, tag);
    }

    public TomcatManagerResponse deploy(String path, InputStream war) throws TomcatManagerException, IOException {
        return this.deploy(path, war, false);
    }

    public TomcatManagerResponse deploy(String path, InputStream war, boolean update) throws TomcatManagerException, IOException {
        return this.deploy(path, war, update, null);
    }

    public TomcatManagerResponse deploy(String path, InputStream war, boolean update, String tag) throws TomcatManagerException, IOException {
        return this.deployImpl(path, null, null, war, update, tag);
    }

    public TomcatManagerResponse deploy(String path, InputStream war, boolean update, String tag, long length) throws TomcatManagerException, IOException {
        return this.deployImpl(path, null, null, war, update, tag, length);
    }

    public TomcatManagerResponse deployContext(String path, URL config) throws TomcatManagerException, IOException {
        return this.deployContext(path, config, false);
    }

    public TomcatManagerResponse deployContext(String path, URL config, boolean update) throws TomcatManagerException, IOException {
        return this.deployContext(path, config, update, null);
    }

    public TomcatManagerResponse deployContext(String path, URL config, boolean update, String tag) throws TomcatManagerException, IOException {
        return this.deployContext(path, config, null, update, tag);
    }

    public TomcatManagerResponse deployContext(String path, URL config, URL war) throws TomcatManagerException, IOException {
        return this.deployContext(path, config, war, false);
    }

    public TomcatManagerResponse deployContext(String path, URL config, URL war, boolean update) throws TomcatManagerException, IOException {
        return this.deployContext(path, config, war, update, null);
    }

    public TomcatManagerResponse deployContext(String path, URL config, URL war, boolean update, String tag) throws TomcatManagerException, IOException {
        return this.deployImpl(path, config, war, null, update, tag);
    }

    public TomcatManagerResponse undeploy(String path) throws TomcatManagerException, IOException {
        return this.invoke("/undeploy?path=" + URLEncoder.encode(path, this.charset));
    }

    public TomcatManagerResponse reload(String path) throws TomcatManagerException, IOException {
        return this.invoke("/reload?path=" + URLEncoder.encode(path, this.charset));
    }

    public TomcatManagerResponse start(String path) throws TomcatManagerException, IOException {
        return this.invoke("/start?path=" + URLEncoder.encode(path, this.charset));
    }

    public TomcatManagerResponse stop(String path) throws TomcatManagerException, IOException {
        return this.invoke("/stop?path=" + URLEncoder.encode(path, this.charset));
    }

    public TomcatManagerResponse list() throws TomcatManagerException, IOException {
        return this.invoke("/list");
    }

    public TomcatManagerResponse getServerInfo() throws TomcatManagerException, IOException {
        return this.invoke("/serverinfo");
    }

    public TomcatManagerResponse getResources() throws TomcatManagerException, IOException {
        return this.getResources(null);
    }

    public TomcatManagerResponse getResources(String type) throws TomcatManagerException, IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("/resources");
        if (type != null) {
            buffer.append("?type=" + URLEncoder.encode(type, this.charset));
        }
        return this.invoke(buffer.toString());
    }

    public TomcatManagerResponse getRoles() throws TomcatManagerException, IOException {
        return this.invoke("/roles");
    }

    public TomcatManagerResponse getSessions(String path) throws TomcatManagerException, IOException {
        return this.invoke("/sessions?path=" + URLEncoder.encode(path, this.charset));
    }

    protected TomcatManagerResponse invoke(String path) throws TomcatManagerException, IOException {
        return this.invoke(path, null, -1L);
    }

    private TomcatManagerResponse deployImpl(String path, URL config, URL war, InputStream data, boolean update, String tag) throws TomcatManagerException, IOException {
        return this.deployImpl(path, config, war, data, update, tag, -1L);
    }

    private TomcatManagerResponse deployImpl(String path, URL config, URL war, InputStream data, boolean update, String tag, long length) throws TomcatManagerException, IOException {
        StringBuilder buffer = new StringBuilder("/deploy");
        buffer.append("?path=").append(URLEncoder.encode(path, this.charset));
        if (config != null) {
            buffer.append("&config=").append(URLEncoder.encode(config.toString(), this.charset));
        }
        if (war != null) {
            buffer.append("&war=").append(URLEncoder.encode(war.toString(), this.charset));
        }
        if (update) {
            buffer.append("&update=true");
        }
        if (tag != null) {
            buffer.append("&tag=").append(URLEncoder.encode(tag, this.charset));
        }
        return this.invoke(buffer.toString(), data, length);
    }

    protected TomcatManagerResponse invoke(String path, InputStream data, long length) throws TomcatManagerException, IOException {
        HttpGet httpRequestBase = null;
        if (data == null) {
            httpRequestBase = new HttpGet(this.url + path);
        } else {
            HttpPut httpPut = new HttpPut(this.url + path);
            httpPut.setEntity((HttpEntity)new RequestEntityImplementation(data, length, this.url + path));
            httpRequestBase = httpPut;
        }
        if (this.userAgent != null) {
            httpRequestBase.setHeader("User-Agent", this.userAgent);
        }
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequestBase, (HttpContext)this.localContext);
        return new TomcatManagerResponse().setStatusCode(response.getStatusLine().getStatusCode()).setReasonPhrase(response.getStatusLine().getReasonPhrase()).setHttpResponseBody(IOUtils.toString((InputStream)response.getEntity().getContent()));
    }

    private String toAuthorization(String username, String password) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(username).append(':');
        if (password != null) {
            buffer.append(password);
        }
        return "Basic " + new String(Base64.encodeBase64((byte[])buffer.toString().getBytes()));
    }

    private final class RequestEntityImplementation
    extends AbstractHttpEntity {
        private static final int BUFFER_SIZE = 2048;
        private InputStream stream;
        PrintStream out = System.out;
        private long length = -1L;
        private int lastLength;
        private String url;
        private long startTime;

        private RequestEntityImplementation(InputStream stream, long length, String url) {
            this.stream = stream;
            this.length = length;
            this.url = url;
        }

        public long getContentLength() {
            return this.length >= 0L ? this.length : -1L;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return this.stream;
        }

        public boolean isRepeatable() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream outstream) throws IOException {
            long completed = 0L;
            if (outstream == null) {
                throw new IllegalArgumentException("Output stream may not be null");
            }
            this.transferInitiated(this.url);
            this.startTime = System.currentTimeMillis();
            try {
                byte[] buffer = new byte[2048];
                if (this.length < 0L) {
                    int l;
                    while ((l = this.stream.read(buffer)) != -1) {
                        this.transferProgressed(completed += (long)buffer.length, -1L);
                        outstream.write(buffer, 0, l);
                    }
                } else {
                    int l;
                    for (long remaining = this.length; remaining > 0L; remaining -= (long)l) {
                        int transferSize = (int)Math.min(2048L, remaining);
                        completed += (long)transferSize;
                        l = this.stream.read(buffer, 0, transferSize);
                        if (l != -1) {
                            outstream.write(buffer, 0, l);
                            this.transferProgressed(completed, this.length);
                            continue;
                        }
                        break;
                    }
                }
                this.transferSucceeded(completed);
            }
            finally {
                this.stream.close();
                this.out.println();
            }
        }

        public boolean isStreaming() {
            return true;
        }

        public void transferInitiated(String url) {
            String message = "Uploading";
            this.out.println(message + ": " + url);
        }

        public void transferProgressed(long completedSize, long totalSize) {
            StringBuilder buffer = new StringBuilder(64);
            buffer.append(this.getStatus(completedSize, totalSize)).append("  ");
            this.lastLength = buffer.length();
            buffer.append('\r');
            this.out.print(buffer);
        }

        public void transferSucceeded(long contentLength) {
            if (contentLength >= 0L) {
                String type = "Uploaded";
                String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
                String throughput = "";
                long duration = System.currentTimeMillis() - this.startTime;
                if (duration > 0L) {
                    DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                    double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                    throughput = " at " + format.format(kbPerSec) + " KB/sec";
                }
                this.out.println(type + ": " + this.url + " (" + len + throughput + ")");
            }
        }

        private String getStatus(long complete, long total) {
            if (total >= 1024L) {
                return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
            }
            if (total >= 0L) {
                return complete + "/" + total + " B ";
            }
            if (complete >= 1024L) {
                return this.toKB(complete) + " KB ";
            }
            return complete + " B ";
        }

        private long toKB(long bytes) {
            return (bytes + 1023L) / 1024L;
        }
    }
}

