/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import javax.websocket.CloseReason;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.AsyncChannelWrapper;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.ReadBufferOverflowException;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsFrameBase;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsSession;

public class WsFrameClient
extends WsFrameBase {
    private final Log log = LogFactory.getLog(WsFrameClient.class);
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private final AsyncChannelWrapper channel;
    private final CompletionHandler<Integer, Void> handler;
    private volatile ByteBuffer response;

    public WsFrameClient(ByteBuffer response, AsyncChannelWrapper channel, WsSession wsSession, Transformation transformation) {
        super(wsSession, transformation);
        this.response = response;
        this.channel = channel;
        this.handler = new WsFrameClientCompletionHandler();
    }

    void startInputProcessing() {
        try {
            this.processSocketRead();
        }
        catch (IOException e) {
            this.close(e);
        }
    }

    private void processSocketRead() throws IOException {
        while (this.response.hasRemaining()) {
            int remaining = this.response.remaining();
            int toCopy = Math.min(remaining, this.inputBuffer.length - this.writePos);
            this.response.get(this.inputBuffer, this.writePos, toCopy);
            this.writePos += toCopy;
            this.processInputBuffer();
        }
        this.response.clear();
        if (this.isOpen()) {
            this.channel.read(this.response, null, this.handler);
        }
    }

    private final void close(Throwable t) {
        CloseReason cr = t instanceof WsIOException ? ((WsIOException)t).getCloseReason() : new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, t.getMessage());
        try {
            this.wsSession.close(cr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected boolean isMasked() {
        return false;
    }

    private class WsFrameClientCompletionHandler
    implements CompletionHandler<Integer, Void> {
        private WsFrameClientCompletionHandler() {
        }

        @Override
        public void completed(Integer result, Void attachment) {
            block4: {
                if (result == -1) {
                    if (WsFrameClient.this.isOpen()) {
                        WsFrameClient.this.close(new EOFException());
                    }
                    return;
                }
                WsFrameClient.this.response.flip();
                try {
                    WsFrameClient.this.processSocketRead();
                }
                catch (IOException e) {
                    if (!WsFrameClient.this.isOpen()) break block4;
                    WsFrameClient.this.log.debug((Object)sm.getString("wsFrameClient.ioe", new Object[]{e}));
                    WsFrameClient.this.close(e);
                }
            }
        }

        @Override
        public void failed(Throwable exc, Void attachment) {
            if (exc instanceof ReadBufferOverflowException) {
                WsFrameClient.this.response = ByteBuffer.allocate(((ReadBufferOverflowException)exc).getMinBufferSize());
                WsFrameClient.this.response.flip();
                try {
                    WsFrameClient.this.processSocketRead();
                }
                catch (IOException e) {
                    WsFrameClient.this.close(e);
                }
            } else {
                WsFrameClient.this.close(exc);
            }
        }
    }
}

