/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.jsp.el;

import jakarta.el.ELClass;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ImportHandler;
import java.util.Objects;

public class ImportELResolver
extends ELResolver {
    private static final Class<?> AST_IDENTIFIER_KEY;

    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        Object result = null;
        if (base == null && property != null) {
            ImportHandler importHandler;
            Boolean value;
            boolean resolveClass = true;
            if (AST_IDENTIFIER_KEY != null && (value = (Boolean)context.getContext(AST_IDENTIFIER_KEY)) != null && value.booleanValue()) {
                resolveClass = false;
            }
            if ((importHandler = context.getImportHandler()) != null) {
                String key = property.toString();
                Class clazz = null;
                if (resolveClass && (clazz = importHandler.resolveClass(key)) != null) {
                    result = new ELClass(clazz);
                }
                if (result == null && (clazz = importHandler.resolveStatic(key)) != null) {
                    try {
                        result = clazz.getField(key).get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (result != null) {
            context.setPropertyResolved(base, property);
        }
        return result;
    }

    public Class<Object> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        Objects.requireNonNull(context);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        return false;
    }

    public Class<String> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    static {
        Class<?> key = null;
        try {
            key = Class.forName("org.apache.el.parser.AstIdentifier");
        }
        catch (Exception exception) {
            // empty catch block
        }
        AST_IDENTIFIER_KEY = key;
    }
}

