/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeMap;
import javax.management.AttributeNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.AnnotationProcessor;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContextValve;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.MessageDestination;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.TldConfig;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.DefaultAnnotationProcessor;
import org.apache.catalina.util.ExtensionValidator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.modeler.Registry;

public class StandardContext
extends ContainerBase
implements Context,
Serializable,
NotificationEmitter {
    private static transient Log log = LogFactory.getLog(StandardContext.class);
    private static final String info = "org.apache.catalina.core.StandardContext/1.0";
    protected static URLEncoder urlEncoder = new URLEncoder();
    private String altDDName = null;
    private AnnotationProcessor annotationProcessor = null;
    private String hostName;
    private boolean antiJARLocking = false;
    private boolean antiResourceLocking = false;
    private String[] applicationListeners = new String[0];
    private final Object applicationListenersLock = new Object();
    private transient Object[] applicationEventListenersObjects = new Object[0];
    private transient Object[] applicationLifecycleListenersObjects = new Object[0];
    private ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    private final Object applicationParametersLock = new Object();
    private boolean available = false;
    private NotificationBroadcasterSupport broadcaster = null;
    private transient CharsetMapper charsetMapper = null;
    private String charsetMapperClass = "org.apache.catalina.util.CharsetMapper";
    private String configFile = null;
    private boolean configured = false;
    private SecurityConstraint[] constraints = new SecurityConstraint[0];
    private final Object constraintsLock = new Object();
    protected transient ApplicationContext context = null;
    private String compilerClasspath = null;
    private boolean cookies = true;
    private boolean crossContext = false;
    private String encodedPath = null;
    private boolean delegate = false;
    private String displayName = null;
    private String defaultContextXml;
    private String defaultWebXml;
    private boolean distributable = false;
    private String docBase = null;
    private HashMap exceptionPages = new HashMap();
    private HashMap filterConfigs = new HashMap();
    private HashMap filterDefs = new HashMap();
    private FilterMap[] filterMaps = new FilterMap[0];
    private final Object filterMapsLock = new Object();
    private boolean ignoreAnnotations = false;
    private String[] instanceListeners = new String[0];
    private final Object instanceListenersLock = new Object();
    private LoginConfig loginConfig = null;
    private Mapper mapper = new Mapper();
    private transient NamingContextListener namingContextListener = null;
    private NamingResources namingResources = null;
    private HashMap messageDestinations = new HashMap();
    private HashMap mimeMappings = new HashMap();
    private ErrorPage okErrorPage = null;
    private HashMap parameters = new HashMap();
    private boolean paused = false;
    private String publicId = null;
    private boolean reloadable = false;
    private boolean unpackWAR = true;
    private boolean override = false;
    private String originalDocBase = null;
    private boolean privileged = false;
    private boolean replaceWelcomeFiles = false;
    private HashMap roleMappings = new HashMap();
    private String[] securityRoles = new String[0];
    private final Object securityRolesLock = new Object();
    private HashMap servletMappings = new HashMap();
    private final Object servletMappingsLock = new Object();
    private int sessionTimeout = 30;
    private long sequenceNumber = 0L;
    private HashMap statusPages = new HashMap();
    private boolean swallowOutput = false;
    private HashMap taglibs = new HashMap();
    private long unloadDelay = 2000L;
    private String[] watchedResources = new String[0];
    private final Object watchedResourcesLock = new Object();
    private String[] welcomeFiles = new String[0];
    private final Object welcomeFilesLock = new Object();
    private String[] wrapperLifecycles = new String[0];
    private final Object wrapperLifecyclesLock = new Object();
    private String[] wrapperListeners = new String[0];
    private final Object wrapperListenersLock = new Object();
    private String workDir = null;
    private String wrapperClassName = StandardWrapper.class.getName();
    private Class wrapperClass = null;
    private boolean useNaming = true;
    private boolean filesystemBased = false;
    private String namingContextName = null;
    private boolean cachingAllowed = true;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;
    protected int cacheMaxSize = 10240;
    protected int cacheObjectMaxSize = 512;
    protected int cacheTTL = 5000;
    private boolean lazy = true;
    private transient DirContext webappResources = null;
    private long startupTime;
    private long startTime;
    private long tldScanTime;
    private String engineName = null;
    private String j2EEApplication = "none";
    private String j2EEServer = "none";
    private boolean webXmlValidation = false;
    private boolean webXmlNamespaceAware = false;
    private boolean processTlds = true;
    private boolean tldValidation = false;
    private boolean tldNamespaceAware = false;
    private boolean saveConfig = true;
    private boolean useHttpOnly = false;
    private boolean clearReferencesStopThreads = false;
    private MBeanNotificationInfo[] notificationInfo;
    private String server = null;
    private String[] javaVMs = null;

    public StandardContext() {
        this.pipeline.setBasic(new StandardContextValve());
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    public AnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    public void setAnnotationProcessor(AnnotationProcessor annotationProcessor) {
        this.annotationProcessor = annotationProcessor;
    }

    public String getEncodedPath() {
        return this.encodedPath;
    }

    public void setName(String name) {
        super.setName(name);
        this.encodedPath = urlEncoder.encode(name);
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean isAllowLinking() {
        return this.allowLinking;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public int getCacheObjectMaxSize() {
        return this.cacheObjectMaxSize;
    }

    public void setCacheObjectMaxSize(int cacheObjectMaxSize) {
        this.cacheObjectMaxSize = cacheObjectMaxSize;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", oldDelegate, this.delegate);
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public boolean isFilesystemBased() {
        return this.filesystemBased;
    }

    public Object[] getApplicationEventListeners() {
        return this.applicationEventListenersObjects;
    }

    public void setApplicationEventListeners(Object[] listeners) {
        this.applicationEventListenersObjects = listeners;
    }

    public Object[] getApplicationLifecycleListeners() {
        return this.applicationLifecycleListenersObjects;
    }

    public void setApplicationLifecycleListeners(Object[] listeners) {
        this.applicationLifecycleListenersObjects = listeners;
    }

    public boolean getAntiJARLocking() {
        return this.antiJARLocking;
    }

    public boolean getAntiResourceLocking() {
        return this.antiResourceLocking;
    }

    public void setAntiJARLocking(boolean antiJARLocking) {
        boolean oldAntiJARLocking = this.antiJARLocking;
        this.antiJARLocking = antiJARLocking;
        this.support.firePropertyChange("antiJARLocking", oldAntiJARLocking, this.antiJARLocking);
    }

    public void setAntiResourceLocking(boolean antiResourceLocking) {
        boolean oldAntiResourceLocking = this.antiResourceLocking;
        this.antiResourceLocking = antiResourceLocking;
        this.support.firePropertyChange("antiResourceLocking", oldAntiResourceLocking, this.antiResourceLocking);
    }

    public boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        boolean oldAvailable = this.available;
        this.available = available;
        this.support.firePropertyChange("available", oldAvailable, this.available);
    }

    public CharsetMapper getCharsetMapper() {
        if (this.charsetMapper == null) {
            try {
                Class<?> clazz = Class.forName(this.charsetMapperClass);
                this.charsetMapper = (CharsetMapper)clazz.newInstance();
            }
            catch (Throwable t) {
                this.charsetMapper = new CharsetMapper();
            }
        }
        return this.charsetMapper;
    }

    public void setCharsetMapper(CharsetMapper mapper) {
        CharsetMapper oldCharsetMapper = this.charsetMapper;
        this.charsetMapper = mapper;
        if (mapper != null) {
            this.charsetMapperClass = mapper.getClass().getName();
        }
        this.support.firePropertyChange("charsetMapper", oldCharsetMapper, this.charsetMapper);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public boolean getConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean configured) {
        boolean oldConfigured = this.configured;
        this.configured = configured;
        this.support.firePropertyChange("configured", oldConfigured, this.configured);
    }

    public boolean getCookies() {
        return this.cookies;
    }

    public void setCookies(boolean cookies) {
        boolean oldCookies = this.cookies;
        this.cookies = cookies;
        this.support.firePropertyChange("cookies", oldCookies, this.cookies);
    }

    public boolean getUseHttpOnly() {
        return this.useHttpOnly;
    }

    public void setUseHttpOnly(boolean useHttpOnly) {
        boolean oldUseHttpOnly = this.useHttpOnly;
        this.useHttpOnly = useHttpOnly;
        this.support.firePropertyChange("useHttpOnly", oldUseHttpOnly, this.useHttpOnly);
    }

    public boolean getCrossContext() {
        return this.crossContext;
    }

    public void setCrossContext(boolean crossContext) {
        boolean oldCrossContext = this.crossContext;
        this.crossContext = crossContext;
        this.support.firePropertyChange("crossContext", oldCrossContext, this.crossContext);
    }

    public String getDefaultContextXml() {
        return this.defaultContextXml;
    }

    public void setDefaultContextXml(String defaultContextXml) {
        this.defaultContextXml = defaultContextXml;
    }

    public String getDefaultWebXml() {
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String defaultWebXml) {
        this.defaultWebXml = defaultWebXml;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    public long getTldScanTime() {
        return this.tldScanTime;
    }

    public void setTldScanTime(long tldScanTime) {
        this.tldScanTime = tldScanTime;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAltDDName() {
        return this.altDDName;
    }

    public void setAltDDName(String altDDName) {
        this.altDDName = altDDName;
        if (this.context != null) {
            this.context.setAttribute("org.apache.catalina.deploy.alt_dd", altDDName);
        }
    }

    public String getCompilerClasspath() {
        return this.compilerClasspath;
    }

    public void setCompilerClasspath(String compilerClasspath) {
        this.compilerClasspath = compilerClasspath;
    }

    public void setDisplayName(String displayName) {
        String oldDisplayName = this.displayName;
        this.displayName = displayName;
        this.support.firePropertyChange("displayName", oldDisplayName, this.displayName);
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", oldDistributable, this.distributable);
        if (this.getManager() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Propagating distributable=" + distributable + " to manager"));
            }
            this.getManager().setDistributable(distributable);
        }
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public String getInfo() {
        return info;
    }

    public String getEngineName() {
        if (this.engineName != null) {
            return this.engineName;
        }
        return this.domain;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getJ2EEApplication() {
        return this.j2EEApplication;
    }

    public void setJ2EEApplication(String j2EEApplication) {
        this.j2EEApplication = j2EEApplication;
    }

    public String getJ2EEServer() {
        return this.j2EEServer;
    }

    public void setJ2EEServer(String j2EEServer) {
        this.j2EEServer = j2EEServer;
    }

    public synchronized void setLoader(Loader loader) {
        super.setLoader(loader);
    }

    public boolean getIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        boolean oldIgnoreAnnotations = this.ignoreAnnotations;
        this.ignoreAnnotations = ignoreAnnotations;
        this.support.firePropertyChange("ignoreAnnotations", oldIgnoreAnnotations, this.ignoreAnnotations);
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(LoginConfig config) {
        String errorPage;
        if (config == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.required"));
        }
        String loginPage = config.getLoginPage();
        if (loginPage != null && !loginPage.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.loginConfig.loginWarning", loginPage));
                }
                config.setLoginPage("/" + loginPage);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.loginPage", loginPage));
            }
        }
        if ((errorPage = config.getErrorPage()) != null && !errorPage.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.loginConfig.errorWarning", errorPage));
                }
                config.setErrorPage("/" + errorPage);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.errorPage", errorPage));
            }
        }
        LoginConfig oldLoginConfig = this.loginConfig;
        this.loginConfig = config;
        this.support.firePropertyChange("loginConfig", oldLoginConfig, this.loginConfig);
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public NamingResources getNamingResources() {
        if (this.namingResources == null) {
            this.setNamingResources(new NamingResources());
        }
        return this.namingResources;
    }

    public void setNamingResources(NamingResources namingResources) {
        NamingResources oldNamingResources = this.namingResources;
        this.namingResources = namingResources;
        namingResources.setContainer(this);
        this.support.firePropertyChange("namingResources", oldNamingResources, this.namingResources);
    }

    public String getPath() {
        return this.getName();
    }

    public void setPath(String path) {
        this.setName(path);
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting deployment descriptor public ID to '" + publicId + "'"));
        }
        String oldPublicId = this.publicId;
        this.publicId = publicId;
        this.support.firePropertyChange("publicId", oldPublicId, publicId);
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public boolean getOverride() {
        return this.override;
    }

    public String getOriginalDocBase() {
        return this.originalDocBase;
    }

    public void setOriginalDocBase(String docBase) {
        this.originalDocBase = docBase;
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.getPrivileged()) {
            return this.getClass().getClassLoader();
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    public boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(boolean privileged) {
        boolean oldPrivileged = this.privileged;
        this.privileged = privileged;
        this.support.firePropertyChange("privileged", oldPrivileged, this.privileged);
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", oldReloadable, this.reloadable);
    }

    public void setOverride(boolean override) {
        boolean oldOverride = this.override;
        this.override = override;
        this.support.firePropertyChange("override", oldOverride, this.override);
    }

    public boolean isReplaceWelcomeFiles() {
        return this.replaceWelcomeFiles;
    }

    public void setReplaceWelcomeFiles(boolean replaceWelcomeFiles) {
        boolean oldReplaceWelcomeFiles = this.replaceWelcomeFiles;
        this.replaceWelcomeFiles = replaceWelcomeFiles;
        this.support.firePropertyChange("replaceWelcomeFiles", oldReplaceWelcomeFiles, this.replaceWelcomeFiles);
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ApplicationContext(this.getBasePath(), this);
            if (this.altDDName != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", this.altDDName);
            }
        }
        return this.context.getFacade();
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int timeout) {
        int oldSessionTimeout = this.sessionTimeout;
        this.sessionTimeout = timeout == 0 ? -1 : timeout;
        this.support.firePropertyChange("sessionTimeout", oldSessionTimeout, this.sessionTimeout);
    }

    public boolean getSwallowOutput() {
        return this.swallowOutput;
    }

    public void setSwallowOutput(boolean swallowOutput) {
        boolean oldSwallowOutput = this.swallowOutput;
        this.swallowOutput = swallowOutput;
        this.support.firePropertyChange("swallowOutput", oldSwallowOutput, this.swallowOutput);
    }

    public long getUnloadDelay() {
        return this.unloadDelay;
    }

    public void setUnloadDelay(long unloadDelay) {
        long oldUnloadDelay = this.unloadDelay;
        this.unloadDelay = unloadDelay;
        this.support.firePropertyChange("unloadDelay", oldUnloadDelay, this.unloadDelay);
    }

    public boolean getUnpackWAR() {
        return this.unpackWAR;
    }

    public void setUnpackWAR(boolean unpackWAR) {
        this.unpackWAR = unpackWAR;
    }

    public String getWrapperClass() {
        return this.wrapperClassName;
    }

    public void setWrapperClass(String wrapperClassName) {
        this.wrapperClassName = wrapperClassName;
        try {
            this.wrapperClass = Class.forName(wrapperClassName);
            if (!StandardWrapper.class.isAssignableFrom(this.wrapperClass)) {
                throw new IllegalArgumentException(sm.getString("standardContext.invalidWrapperClass", wrapperClassName));
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(cnfe.getMessage());
        }
    }

    public synchronized void setResources(DirContext resources) {
        if (this.started) {
            throw new IllegalStateException(sm.getString("standardContext.resources.started"));
        }
        DirContext oldResources = this.webappResources;
        if (oldResources == resources) {
            return;
        }
        if (resources instanceof BaseDirContext) {
            ((BaseDirContext)resources).setCached(this.isCachingAllowed());
            ((BaseDirContext)resources).setCacheTTL(this.getCacheTTL());
            ((BaseDirContext)resources).setCacheMaxSize(this.getCacheMaxSize());
            ((BaseDirContext)resources).setCacheObjectMaxSize(this.getCacheObjectMaxSize());
        }
        if (resources instanceof FileDirContext) {
            this.filesystemBased = true;
            ((FileDirContext)resources).setCaseSensitive(this.isCaseSensitive());
            ((FileDirContext)resources).setAllowLinking(this.isAllowLinking());
        }
        this.webappResources = resources;
        this.resources = null;
        this.support.firePropertyChange("resources", oldResources, this.webappResources);
    }

    public String getCharsetMapperClass() {
        return this.charsetMapperClass;
    }

    public void setCharsetMapperClass(String mapper) {
        String oldCharsetMapperClass = this.charsetMapperClass;
        this.charsetMapperClass = mapper;
        this.support.firePropertyChange("charsetMapperClass", oldCharsetMapperClass, this.charsetMapperClass);
    }

    public String getWorkPath() {
        if (this.getWorkDir() == null) {
            return null;
        }
        File workDir = new File(this.getWorkDir());
        if (!workDir.isAbsolute()) {
            File catalinaHome = this.engineBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                workDir = new File(catalinaHomePath, this.getWorkDir());
            }
            catch (IOException e) {
                log.warn((Object)("Exception obtaining work path for " + this.getPath()));
            }
        }
        return workDir.getAbsolutePath();
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
        if (this.started) {
            this.postWorkDirectory();
        }
    }

    public boolean isSaveConfig() {
        return this.saveConfig;
    }

    public void setSaveConfig(boolean saveConfig) {
        this.saveConfig = saveConfig;
    }

    public boolean getClearReferencesStopThreads() {
        return this.clearReferencesStopThreads;
    }

    public void setClearReferencesStopThreads(boolean clearReferencesStopThreads) {
        boolean oldClearReferencesStopThreads = this.clearReferencesStopThreads;
        this.clearReferencesStopThreads = clearReferencesStopThreads;
        this.support.firePropertyChange("clearReferencesStopThreads", oldClearReferencesStopThreads, this.clearReferencesStopThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(String listener) {
        Object object = this.applicationListenersLock;
        synchronized (object) {
            String[] results = new String[this.applicationListeners.length + 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (listener.equals(this.applicationListeners[i])) {
                    log.info((Object)sm.getString("standardContext.duplicateListener", listener));
                    return;
                }
                results[i] = this.applicationListeners[i];
            }
            results[this.applicationListeners.length] = listener;
            this.applicationListeners = results;
        }
        this.fireContainerEvent("addApplicationListener", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationParameter(ApplicationParameter parameter) {
        Object object = this.applicationParametersLock;
        synchronized (object) {
            String newName = parameter.getName();
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (!newName.equals(this.applicationParameters[i].getName()) || this.applicationParameters[i].getOverride()) continue;
                return;
            }
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length + 1];
            System.arraycopy(this.applicationParameters, 0, results, 0, this.applicationParameters.length);
            results[this.applicationParameters.length] = parameter;
            this.applicationParameters = results;
        }
        this.fireContainerEvent("addApplicationParameter", parameter);
    }

    public void addChild(Container child) {
        String jspFile;
        Wrapper oldJspServlet = null;
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        Wrapper wrapper = (Wrapper)child;
        boolean isJspServlet = "jsp".equals(child.getName());
        if (isJspServlet && (oldJspServlet = (Wrapper)this.findChild("jsp")) != null) {
            this.removeChild(oldJspServlet);
        }
        if ((jspFile = wrapper.getJspFile()) != null && !jspFile.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.wrapper.warning", jspFile));
                }
                wrapper.setJspFile("/" + jspFile);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.wrapper.error", jspFile));
            }
        }
        super.addChild(child);
        if (isJspServlet && oldJspServlet != null) {
            String[] jspMappings = oldJspServlet.findMappings();
            for (int i = 0; jspMappings != null && i < jspMappings.length; ++i) {
                this.addServletMapping(jspMappings[i], child.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstraint(SecurityConstraint constraint) {
        SecurityCollection[] collections = constraint.findCollections();
        for (int i = 0; i < collections.length; ++i) {
            String[] patterns = collections[i].findPatterns();
            for (int j = 0; j < patterns.length; ++j) {
                patterns[j] = this.adjustURLPattern(patterns[j]);
                if (this.validateURLPattern(patterns[j])) continue;
                throw new IllegalArgumentException(sm.getString("standardContext.securityConstraint.pattern", patterns[j]));
            }
        }
        Object object = this.constraintsLock;
        synchronized (object) {
            SecurityConstraint[] results = new SecurityConstraint[this.constraints.length + 1];
            for (int i = 0; i < this.constraints.length; ++i) {
                results[i] = this.constraints[i];
            }
            results[this.constraints.length] = constraint;
            this.constraints = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorPage(ErrorPage errorPage) {
        String exceptionType;
        if (errorPage == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.errorPage.required"));
        }
        String location = errorPage.getLocation();
        if (location != null && !location.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.errorPage.warning", location));
                }
                errorPage.setLocation("/" + location);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.errorPage.error", location));
            }
        }
        if ((exceptionType = errorPage.getExceptionType()) != null) {
            HashMap hashMap = this.exceptionPages;
            synchronized (hashMap) {
                this.exceptionPages.put(exceptionType, errorPage);
            }
        }
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            if (errorPage.getErrorCode() == 200) {
                this.okErrorPage = errorPage;
            }
            this.statusPages.put(errorPage.getErrorCode(), errorPage);
        }
        this.fireContainerEvent("addErrorPage", errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterDef(FilterDef filterDef) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.put(filterDef.getFilterName(), filterDef);
        }
        this.fireContainerEvent("addFilterDef", filterDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterMap(FilterMap filterMap) {
        String filterName = filterMap.getFilterName();
        String[] servletNames = filterMap.getServletNames();
        String[] urlPatterns = filterMap.getURLPatterns();
        if (this.findFilterDef(filterName) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.name", filterName));
        }
        if (!filterMap.getMatchAllServletNames() && !filterMap.getMatchAllUrlPatterns() && servletNames.length == 0 && urlPatterns.length == 0) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.either"));
        }
        for (int i = 0; i < urlPatterns.length; ++i) {
            if (this.validateURLPattern(urlPatterns[i])) continue;
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.pattern", urlPatterns[i]));
        }
        FilterMap[] filterMapArray = this.filterMaps;
        synchronized (this.filterMaps) {
            FilterMap[] results = new FilterMap[this.filterMaps.length + 1];
            System.arraycopy(this.filterMaps, 0, results, 0, this.filterMaps.length);
            results[this.filterMaps.length] = filterMap;
            this.filterMaps = results;
            // ** MonitorExit[var5_6] (shouldn't be in output)
            this.fireContainerEvent("addFilterMap", filterMap);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(String listener) {
        Object object = this.instanceListenersLock;
        synchronized (object) {
            String[] results = new String[this.instanceListeners.length + 1];
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                results[i] = this.instanceListeners[i];
            }
            results[this.instanceListeners.length] = listener;
            this.instanceListeners = results;
        }
        this.fireContainerEvent("addInstanceListener", listener);
    }

    public void addJspMapping(String pattern) {
        String servletName = this.findServletMapping("*.jsp");
        if (servletName == null) {
            servletName = "jsp";
        }
        if (this.findChild(servletName) != null) {
            this.addServletMapping(pattern, servletName, true);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Skiping " + pattern + " , no servlet " + servletName));
        }
    }

    public void addLocaleEncodingMappingParameter(String locale, String encoding) {
        this.getCharsetMapper().addCharsetMappingFromDeploymentDescriptor(locale, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestination(MessageDestination md) {
        HashMap hashMap = this.messageDestinations;
        synchronized (hashMap) {
            this.messageDestinations.put(md.getName(), md);
        }
        this.fireContainerEvent("addMessageDestination", md.getName());
    }

    public void addMessageDestinationRef(MessageDestinationRef mdr) {
        this.namingResources.addMessageDestinationRef(mdr);
        this.fireContainerEvent("addMessageDestinationRef", mdr.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMimeMapping(String extension, String mimeType) {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.put(extension, mimeType);
        }
        this.fireContainerEvent("addMimeMapping", extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(name) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", name));
        }
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
        this.fireContainerEvent("addParameter", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoleMapping(String role, String link) {
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            this.roleMappings.put(role, link);
        }
        this.fireContainerEvent("addRoleMapping", role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityRole(String role) {
        Object object = this.securityRolesLock;
        synchronized (object) {
            String[] results = new String[this.securityRoles.length + 1];
            for (int i = 0; i < this.securityRoles.length; ++i) {
                results[i] = this.securityRoles[i];
            }
            results[this.securityRoles.length] = role;
            this.securityRoles = results;
        }
        this.fireContainerEvent("addSecurityRole", role);
    }

    public void addServletMapping(String pattern, String name) {
        this.addServletMapping(pattern, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletMapping(String pattern, String name, boolean jspWildCard) {
        if (this.findChild(name) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.name", name));
        }
        if (!this.validateURLPattern(pattern = this.adjustURLPattern(RequestUtil.URLDecode(pattern)))) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.pattern", pattern));
        }
        Object object = this.servletMappingsLock;
        synchronized (object) {
            String name2 = (String)this.servletMappings.get(pattern);
            if (name2 != null) {
                Wrapper wrapper = (Wrapper)this.findChild(name2);
                wrapper.removeMapping(pattern);
                this.mapper.removeWrapper(pattern);
            }
            this.servletMappings.put(pattern, name);
        }
        Wrapper wrapper = (Wrapper)this.findChild(name);
        wrapper.addMapping(pattern);
        this.mapper.addWrapper(pattern, (Object)wrapper, jspWildCard);
        this.fireContainerEvent("addServletMapping", pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaglib(String uri, String location) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            this.taglibs.put(uri, location);
        }
        this.fireContainerEvent("addTaglib", uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWatchedResource(String name) {
        Object object = this.watchedResourcesLock;
        synchronized (object) {
            String[] results = new String[this.watchedResources.length + 1];
            for (int i = 0; i < this.watchedResources.length; ++i) {
                results[i] = this.watchedResources[i];
            }
            results[this.watchedResources.length] = name;
            this.watchedResources = results;
        }
        this.fireContainerEvent("addWatchedResource", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWelcomeFile(String name) {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            if (this.replaceWelcomeFiles) {
                this.welcomeFiles = new String[0];
                this.setReplaceWelcomeFiles(false);
            }
            String[] results = new String[this.welcomeFiles.length + 1];
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                results[i] = this.welcomeFiles[i];
            }
            results[this.welcomeFiles.length] = name;
            this.welcomeFiles = results;
        }
        this.postWelcomeFiles();
        this.fireContainerEvent("addWelcomeFile", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperLifecycle(String listener) {
        Object object = this.wrapperLifecyclesLock;
        synchronized (object) {
            String[] results = new String[this.wrapperLifecycles.length + 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                results[i] = this.wrapperLifecycles[i];
            }
            results[this.wrapperLifecycles.length] = listener;
            this.wrapperLifecycles = results;
        }
        this.fireContainerEvent("addWrapperLifecycle", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperListener(String listener) {
        Object object = this.wrapperListenersLock;
        synchronized (object) {
            String[] results = new String[this.wrapperListeners.length + 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                results[i] = this.wrapperListeners[i];
            }
            results[this.wrapperListeners.length] = listener;
            this.wrapperListeners = results;
        }
        this.fireContainerEvent("addWrapperListener", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wrapper createWrapper() {
        Object listener;
        Class<?> clazz;
        int i;
        Wrapper wrapper = null;
        if (this.wrapperClass != null) {
            try {
                wrapper = (Wrapper)this.wrapperClass.newInstance();
            }
            catch (Throwable t) {
                log.error((Object)"createWrapper", t);
                return null;
            }
        } else {
            wrapper = new StandardWrapper();
        }
        Object object = this.instanceListenersLock;
        synchronized (object) {
            for (i = 0; i < this.instanceListeners.length; ++i) {
                try {
                    clazz = Class.forName(this.instanceListeners[i]);
                    listener = (InstanceListener)clazz.newInstance();
                    wrapper.addInstanceListener((InstanceListener)listener);
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        object = this.wrapperLifecyclesLock;
        synchronized (object) {
            for (i = 0; i < this.wrapperLifecycles.length; ++i) {
                try {
                    clazz = Class.forName(this.wrapperLifecycles[i]);
                    listener = (LifecycleListener)clazz.newInstance();
                    if (!(wrapper instanceof Lifecycle)) continue;
                    ((Lifecycle)((Object)wrapper)).addLifecycleListener((LifecycleListener)listener);
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        object = this.wrapperListenersLock;
        synchronized (object) {
            for (i = 0; i < this.wrapperListeners.length; ++i) {
                try {
                    clazz = Class.forName(this.wrapperListeners[i]);
                    listener = (ContainerListener)clazz.newInstance();
                    wrapper.addContainerListener((ContainerListener)listener);
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        return wrapper;
    }

    public String[] findApplicationListeners() {
        return this.applicationListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationParameter[] findApplicationParameters() {
        Object object = this.applicationParametersLock;
        synchronized (object) {
            return this.applicationParameters;
        }
    }

    public SecurityConstraint[] findConstraints() {
        return this.constraints;
    }

    public ErrorPage findErrorPage(int errorCode) {
        if (errorCode == 200) {
            return this.okErrorPage;
        }
        return (ErrorPage)this.statusPages.get(new Integer(errorCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorPage findErrorPage(String exceptionType) {
        HashMap hashMap = this.exceptionPages;
        synchronized (hashMap) {
            return (ErrorPage)this.exceptionPages.get(exceptionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorPage[] findErrorPages() {
        HashMap hashMap = this.exceptionPages;
        synchronized (hashMap) {
            HashMap hashMap2 = this.statusPages;
            synchronized (hashMap2) {
                int i;
                ErrorPage[] results1 = new ErrorPage[this.exceptionPages.size()];
                results1 = this.exceptionPages.values().toArray(results1);
                ErrorPage[] results2 = new ErrorPage[this.statusPages.size()];
                results2 = this.statusPages.values().toArray(results2);
                ErrorPage[] results = new ErrorPage[results1.length + results2.length];
                for (i = 0; i < results1.length; ++i) {
                    results[i] = results1[i];
                }
                for (i = results1.length; i < results.length; ++i) {
                    results[i] = results2[i - results1.length];
                }
                return results;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterDef findFilterDef(String filterName) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            return (FilterDef)this.filterDefs.get(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterDef[] findFilterDefs() {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            FilterDef[] results = new FilterDef[this.filterDefs.size()];
            return this.filterDefs.values().toArray(results);
        }
    }

    public FilterMap[] findFilterMaps() {
        return this.filterMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findInstanceListeners() {
        Object object = this.instanceListenersLock;
        synchronized (object) {
            return this.instanceListeners;
        }
    }

    public Context findMappingObject() {
        return (Context)this.getMappingObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination findMessageDestination(String name) {
        HashMap hashMap = this.messageDestinations;
        synchronized (hashMap) {
            return (MessageDestination)this.messageDestinations.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination[] findMessageDestinations() {
        HashMap hashMap = this.messageDestinations;
        synchronized (hashMap) {
            MessageDestination[] results = new MessageDestination[this.messageDestinations.size()];
            return this.messageDestinations.values().toArray(results);
        }
    }

    public MessageDestinationRef findMessageDestinationRef(String name) {
        return this.namingResources.findMessageDestinationRef(name);
    }

    public MessageDestinationRef[] findMessageDestinationRefs() {
        return this.namingResources.findMessageDestinationRefs();
    }

    public String findMimeMapping(String extension) {
        return (String)this.mimeMappings.get(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findMimeMappings() {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            String[] results = new String[this.mimeMappings.size()];
            return this.mimeMappings.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findRoleMapping(String role) {
        String realRole = null;
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            realRole = (String)this.roleMappings.get(role);
        }
        if (realRole != null) {
            return realRole;
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findSecurityRole(String role) {
        Object object = this.securityRolesLock;
        synchronized (object) {
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (!role.equals(this.securityRoles[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findSecurityRoles() {
        Object object = this.securityRolesLock;
        synchronized (object) {
            return this.securityRoles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findServletMapping(String pattern) {
        Object object = this.servletMappingsLock;
        synchronized (object) {
            return (String)this.servletMappings.get(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findServletMappings() {
        Object object = this.servletMappingsLock;
        synchronized (object) {
            String[] results = new String[this.servletMappings.size()];
            return this.servletMappings.keySet().toArray(results);
        }
    }

    public String findStatusPage(int status) {
        ErrorPage errorPage = (ErrorPage)this.statusPages.get(new Integer(status));
        if (errorPage != null) {
            return errorPage.getLocation();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findStatusPages() {
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            int[] results = new int[this.statusPages.size()];
            Iterator elements = this.statusPages.keySet().iterator();
            int i = 0;
            while (elements.hasNext()) {
                results[i++] = (Integer)elements.next();
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findTaglib(String uri) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            return (String)this.taglibs.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findTaglibs() {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            String[] results = new String[this.taglibs.size()];
            return this.taglibs.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findWelcomeFile(String name) {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (!name.equals(this.welcomeFiles[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findWatchedResources() {
        Object object = this.watchedResourcesLock;
        synchronized (object) {
            return this.watchedResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findWelcomeFiles() {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            return this.welcomeFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findWrapperLifecycles() {
        Object object = this.wrapperLifecyclesLock;
        synchronized (object) {
            return this.wrapperLifecycles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findWrapperListeners() {
        Object object = this.wrapperListenersLock;
        synchronized (object) {
            return this.wrapperListeners;
        }
    }

    public synchronized void reload() {
        if (!this.started) {
            throw new IllegalStateException(sm.getString("containerBase.notStarted", this.logName()));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardContext.reloadingStarted"));
        }
        this.setPaused(true);
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)sm.getString("standardContext.stoppingContext"), (Throwable)e);
        }
        try {
            this.start();
        }
        catch (LifecycleException e) {
            log.error((Object)sm.getString("standardContext.startingContext"), (Throwable)e);
        }
        this.setPaused(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(String listener) {
        Object object = this.applicationListenersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (!this.applicationListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.applicationListeners.length - 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.applicationListeners[i];
            }
            this.applicationListeners = results;
        }
        this.fireContainerEvent("removeApplicationListener", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationParameter(String name) {
        Object object = this.applicationParametersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (!name.equals(this.applicationParameters[i].getName())) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length - 1];
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (i == n) continue;
                results[j++] = this.applicationParameters[i];
            }
            this.applicationParameters = results;
        }
        this.fireContainerEvent("removeApplicationParameter", name);
    }

    public void removeChild(Container child) {
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        super.removeChild(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConstraint(SecurityConstraint constraint) {
        Object object = this.constraintsLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.constraints.length; ++i) {
                if (!this.constraints[i].equals(constraint)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            SecurityConstraint[] results = new SecurityConstraint[this.constraints.length - 1];
            for (int i = 0; i < this.constraints.length; ++i) {
                if (i == n) continue;
                results[j++] = this.constraints[i];
            }
            this.constraints = results;
        }
        this.fireContainerEvent("removeConstraint", constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorPage(ErrorPage errorPage) {
        String exceptionType = errorPage.getExceptionType();
        if (exceptionType != null) {
            HashMap hashMap = this.exceptionPages;
            synchronized (hashMap) {
                this.exceptionPages.remove(exceptionType);
            }
        }
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            if (errorPage.getErrorCode() == 200) {
                this.okErrorPage = null;
            }
            this.statusPages.remove(errorPage.getErrorCode());
        }
        this.fireContainerEvent("removeErrorPage", errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterDef(FilterDef filterDef) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.remove(filterDef.getFilterName());
        }
        this.fireContainerEvent("removeFilterDef", filterDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterMap(FilterMap filterMap) {
        Object object = this.filterMapsLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.filterMaps.length; ++i) {
                if (this.filterMaps[i] != filterMap) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            FilterMap[] results = new FilterMap[this.filterMaps.length - 1];
            System.arraycopy(this.filterMaps, 0, results, 0, n);
            System.arraycopy(this.filterMaps, n + 1, results, n, this.filterMaps.length - 1 - n);
            this.filterMaps = results;
        }
        this.fireContainerEvent("removeFilterMap", filterMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(String listener) {
        Object object = this.instanceListenersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                if (!this.instanceListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.instanceListeners.length - 1];
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.instanceListeners[i];
            }
            this.instanceListeners = results;
        }
        this.fireContainerEvent("removeInstanceListener", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestination(String name) {
        HashMap hashMap = this.messageDestinations;
        synchronized (hashMap) {
            this.messageDestinations.remove(name);
        }
        this.fireContainerEvent("removeMessageDestination", name);
    }

    public void removeMessageDestinationRef(String name) {
        this.namingResources.removeMessageDestinationRef(name);
        this.fireContainerEvent("removeMessageDestinationRef", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMimeMapping(String extension) {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.remove(extension);
        }
        this.fireContainerEvent("removeMimeMapping", extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
        this.fireContainerEvent("removeParameter", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoleMapping(String role) {
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            this.roleMappings.remove(role);
        }
        this.fireContainerEvent("removeRoleMapping", role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityRole(String role) {
        Object object = this.securityRolesLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (!role.equals(this.securityRoles[i])) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.securityRoles.length - 1];
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.securityRoles[i];
            }
            this.securityRoles = results;
        }
        this.fireContainerEvent("removeSecurityRole", role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServletMapping(String pattern) {
        String name = null;
        Object object = this.servletMappingsLock;
        synchronized (object) {
            name = (String)this.servletMappings.remove(pattern);
        }
        Wrapper wrapper = (Wrapper)this.findChild(name);
        if (wrapper != null) {
            wrapper.removeMapping(pattern);
        }
        this.mapper.removeWrapper(pattern);
        this.fireContainerEvent("removeServletMapping", pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaglib(String uri) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            this.taglibs.remove(uri);
        }
        this.fireContainerEvent("removeTaglib", uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWatchedResource(String name) {
        Object object = this.watchedResourcesLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.watchedResources.length; ++i) {
                if (!this.watchedResources[i].equals(name)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.watchedResources.length - 1];
            for (int i = 0; i < this.watchedResources.length; ++i) {
                if (i == n) continue;
                results[j++] = this.watchedResources[i];
            }
            this.watchedResources = results;
        }
        this.fireContainerEvent("removeWatchedResource", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWelcomeFile(String name) {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (!this.welcomeFiles[i].equals(name)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.welcomeFiles.length - 1];
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.welcomeFiles[i];
            }
            this.welcomeFiles = results;
        }
        this.postWelcomeFiles();
        this.fireContainerEvent("removeWelcomeFile", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperLifecycle(String listener) {
        Object object = this.wrapperLifecyclesLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                if (!this.wrapperLifecycles[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperLifecycles.length - 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.wrapperLifecycles[i];
            }
            this.wrapperLifecycles = results;
        }
        this.fireContainerEvent("removeWrapperLifecycle", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperListener(String listener) {
        Object object = this.wrapperListenersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                if (!this.wrapperListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperListeners.length - 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.wrapperListeners[i];
            }
            this.wrapperListeners = results;
        }
        this.fireContainerEvent("removeWrapperListener", listener);
    }

    public long getProcessingTime() {
        long result = 0L;
        Container[] children = this.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                result += ((StandardWrapper)children[i]).getProcessingTime();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStart() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Starting filters");
        }
        boolean ok = true;
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            this.filterConfigs.clear();
            for (String name : this.filterDefs.keySet()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(" Starting filter '" + name + "'"));
                }
                ApplicationFilterConfig filterConfig = null;
                try {
                    filterConfig = new ApplicationFilterConfig(this, (FilterDef)this.filterDefs.get(name));
                    this.filterConfigs.put(name, filterConfig);
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)sm.getString("standardContext.filterStart", name), t);
                    ok = false;
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStop() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Stopping filters");
        }
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            for (String name : this.filterConfigs.keySet()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(" Stopping filter '" + name + "'"));
                }
                ApplicationFilterConfig filterConfig = (ApplicationFilterConfig)this.filterConfigs.get(name);
                filterConfig.release();
            }
            this.filterConfigs.clear();
        }
        return true;
    }

    public FilterConfig findFilterConfig(String name) {
        return (FilterConfig)this.filterConfigs.get(name);
    }

    public boolean listenerStart() {
        Object[] instances;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring application event listeners");
        }
        ClassLoader loader = this.getLoader().getClassLoader();
        String[] listeners = this.findApplicationListeners();
        Object[] results = new Object[listeners.length];
        boolean ok = true;
        for (int i = 0; i < results.length; ++i) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(" Configuring event listener class '" + listeners[i] + "'"));
            }
            try {
                Class<?> clazz = loader.loadClass(listeners[i]);
                results[i] = clazz.newInstance();
                if (this.getIgnoreAnnotations()) continue;
                this.getAnnotationProcessor().processAnnotations(results[i]);
                this.getAnnotationProcessor().postConstruct(results[i]);
                continue;
            }
            catch (Throwable t) {
                this.getLogger().error((Object)sm.getString("standardContext.applicationListener", listeners[i]), t);
                ok = false;
            }
        }
        if (!ok) {
            this.getLogger().error((Object)sm.getString("standardContext.applicationSkipped"));
            return false;
        }
        ArrayList<Object> eventListeners = new ArrayList<Object>();
        ArrayList<Object> lifecycleListeners = new ArrayList<Object>();
        for (int i = 0; i < results.length; ++i) {
            if (results[i] instanceof ServletContextAttributeListener || results[i] instanceof ServletRequestAttributeListener || results[i] instanceof ServletRequestListener || results[i] instanceof HttpSessionAttributeListener) {
                eventListeners.add(results[i]);
            }
            if (!(results[i] instanceof ServletContextListener) && !(results[i] instanceof HttpSessionListener)) continue;
            lifecycleListeners.add(results[i]);
        }
        this.setApplicationEventListeners(eventListeners.toArray());
        this.setApplicationLifecycleListeners(lifecycleListeners.toArray());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Sending application start events");
        }
        if ((instances = this.getApplicationLifecycleListeners()) == null) {
            return ok;
        }
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        for (int i = 0; i < instances.length; ++i) {
            if (instances[i] == null || !(instances[i] instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)instances[i];
            try {
                this.fireContainerEvent("beforeContextInitialized", listener);
                listener.contextInitialized(event);
                this.fireContainerEvent("afterContextInitialized", listener);
                continue;
            }
            catch (Throwable t) {
                this.fireContainerEvent("afterContextInitialized", listener);
                this.getLogger().error((Object)sm.getString("standardContext.listenerStart", instances[i].getClass().getName()), t);
                ok = false;
            }
        }
        return ok;
    }

    public boolean listenerStop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending application stop events");
        }
        boolean ok = true;
        Object[] listeners = this.getApplicationLifecycleListeners();
        if (listeners != null) {
            ServletContextEvent event = new ServletContextEvent(this.getServletContext());
            for (int i = 0; i < listeners.length; ++i) {
                int j = listeners.length - 1 - i;
                if (listeners[j] == null) continue;
                if (listeners[j] instanceof ServletContextListener) {
                    ServletContextListener listener = (ServletContextListener)listeners[j];
                    try {
                        this.fireContainerEvent("beforeContextDestroyed", listener);
                        listener.contextDestroyed(event);
                        this.fireContainerEvent("afterContextDestroyed", listener);
                    }
                    catch (Throwable t) {
                        this.fireContainerEvent("afterContextDestroyed", listener);
                        this.getLogger().error((Object)sm.getString("standardContext.listenerStop", listeners[j].getClass().getName()), t);
                        ok = false;
                    }
                }
                if (this.getIgnoreAnnotations()) continue;
                try {
                    this.getAnnotationProcessor().preDestroy(listeners[j]);
                    continue;
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)sm.getString("standardContext.listenerStop", listeners[j].getClass().getName()), t);
                    ok = false;
                }
            }
        }
        listeners = this.getApplicationEventListeners();
        if (!this.getIgnoreAnnotations() && listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                int j = listeners.length - 1 - i;
                if (listeners[j] == null) continue;
                try {
                    this.getAnnotationProcessor().preDestroy(listeners[j]);
                    continue;
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)sm.getString("standardContext.listenerStop", listeners[j].getClass().getName()), t);
                    ok = false;
                }
            }
        }
        this.setApplicationEventListeners(null);
        this.setApplicationLifecycleListeners(null);
        return ok;
    }

    public boolean resourcesStart() {
        boolean ok = true;
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        try {
            ProxyDirContext proxyDirContext = new ProxyDirContext(env, this.webappResources);
            if (this.webappResources instanceof FileDirContext) {
                this.filesystemBased = true;
                ((FileDirContext)this.webappResources).setCaseSensitive(this.isCaseSensitive());
                ((FileDirContext)this.webappResources).setAllowLinking(this.isAllowLinking());
            }
            if (this.webappResources instanceof BaseDirContext) {
                ((BaseDirContext)this.webappResources).setDocBase(this.getBasePath());
                ((BaseDirContext)this.webappResources).setCached(this.isCachingAllowed());
                ((BaseDirContext)this.webappResources).setCacheTTL(this.getCacheTTL());
                ((BaseDirContext)this.webappResources).setCacheMaxSize(this.getCacheMaxSize());
                ((BaseDirContext)this.webappResources).allocate();
            }
            if (this.isCachingAllowed()) {
                ObjectName resourcesName = new ObjectName(this.getDomain() + ":type=Cache,host=" + this.getHostname() + ",path=" + ("".equals(this.getPath()) ? "/" : this.getPath()));
                Registry.getRegistry(null, null).registerComponent((Object)proxyDirContext.getCache(), resourcesName, null);
            }
            this.resources = proxyDirContext;
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("standardContext.resourcesStart"), t);
            ok = false;
        }
        return ok;
    }

    public boolean resourcesStop() {
        boolean ok = true;
        try {
            if (this.resources != null) {
                if (this.resources instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.resources)).stop();
                }
                if (this.webappResources instanceof BaseDirContext) {
                    ((BaseDirContext)this.webappResources).release();
                }
                if (this.isCachingAllowed()) {
                    ObjectName resourcesName = new ObjectName(this.getDomain() + ":type=Cache,host=" + this.getHostname() + ",path=" + ("".equals(this.getPath()) ? "/" : this.getPath()));
                    Registry.getRegistry(null, null).unregisterComponent(resourcesName);
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("standardContext.resourcesStop"), t);
            ok = false;
        }
        this.resources = null;
        return ok;
    }

    public void loadOnStartup(Container[] children) {
        TreeMap<Integer, ArrayList<Wrapper>> map = new TreeMap<Integer, ArrayList<Wrapper>>();
        for (int i = 0; i < children.length; ++i) {
            Wrapper wrapper = (Wrapper)children[i];
            int loadOnStartup = wrapper.getLoadOnStartup();
            if (loadOnStartup < 0) continue;
            Integer key = loadOnStartup;
            ArrayList<Wrapper> list = (ArrayList<Wrapper>)map.get(key);
            if (list == null) {
                list = new ArrayList<Wrapper>();
                map.put(key, list);
            }
            list.add(wrapper);
        }
        for (Integer key : map.keySet()) {
            ArrayList list = (ArrayList)map.get(key);
            for (Wrapper wrapper : list) {
                try {
                    wrapper.load();
                }
                catch (ServletException e) {
                    this.getLogger().error((Object)sm.getString("standardWrapper.loadException", this.getName()), StandardWrapper.getRootCause(e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws LifecycleException {
        String useNamingProperty;
        boolean ok;
        block67: {
            if (this.started) {
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString("containerBase.alreadyStarted", this.logName()));
                }
                return;
            }
            if (!this.initialized) {
                try {
                    this.init();
                }
                catch (Exception ex) {
                    throw new LifecycleException("Error initializaing ", ex);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting " + ("".equals(this.getName()) ? "ROOT" : this.getName())));
            }
            this.preRegisterJMX();
            if (this.oname != null && Registry.getRegistry(null, null).getMBeanServer().isRegistered(this.oname)) {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            this.lifecycle.fireLifecycleEvent("before_start", null);
            this.setAvailable(false);
            this.setConfigured(false);
            ok = true;
            if (this.webappResources == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Configuring default Resources");
                }
                try {
                    if (this.docBase != null && this.docBase.endsWith(".war") && !new File(this.getBasePath()).isDirectory()) {
                        this.setResources(new WARDirContext());
                    } else {
                        this.setResources(new FileDirContext());
                    }
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Error initializing resources: " + e.getMessage()));
                    ok = false;
                }
            }
            if (ok && !this.resourcesStart()) {
                log.error((Object)"Error in resourceStart()");
                ok = false;
            }
            if (this.realm == null && this.mserver != null) {
                ObjectName realmName = null;
                try {
                    realmName = new ObjectName(this.getEngineName() + ":type=Realm,host=" + this.getHostname() + ",path=" + this.getPath());
                    if (this.mserver.isRegistered(realmName)) {
                        this.mserver.invoke(realmName, "init", new Object[0], new String[0]);
                    }
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block67;
                    log.debug((Object)("No realm for this host " + realmName));
                }
            }
        }
        if (this.getLoader() == null) {
            WebappLoader webappLoader = new WebappLoader(this.getParentClassLoader());
            webappLoader.setDelegate(this.getDelegate());
            this.setLoader(webappLoader);
        }
        this.getCharsetMapper();
        this.postWorkDirectory();
        boolean dependencyCheck = true;
        try {
            dependencyCheck = ExtensionValidator.validateApplication(this.getResources(), this);
        }
        catch (IOException ioe) {
            log.error((Object)"Error in dependencyCheck", (Throwable)ioe);
            dependencyCheck = false;
        }
        if (!dependencyCheck) {
            ok = false;
        }
        if ((useNamingProperty = System.getProperty("catalina.useNaming")) != null && useNamingProperty.equals("false")) {
            this.useNaming = false;
        }
        if (ok && this.isUseNaming() && this.namingContextListener == null) {
            this.namingContextListener = new NamingContextListener();
            this.namingContextListener.setName(this.getNamingContextName());
            this.addLifecycleListener(this.namingContextListener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing standard container startup");
        }
        ClassLoader oldCCL = this.bindThread();
        boolean mainOk = false;
        try {
            if (ok) {
                this.started = true;
                if (this.loader != null && this.loader instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.loader)).start();
                }
                this.unbindThread(oldCCL);
                oldCCL = this.bindThread();
                this.logger = null;
                this.getLogger();
                if (this.logger != null && this.logger instanceof Lifecycle) {
                    ((Lifecycle)this.logger).start();
                }
                if (this.cluster != null && this.cluster instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.cluster)).start();
                }
                if (this.realm != null && this.realm instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.realm)).start();
                }
                if (this.resources != null && this.resources instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.resources)).start();
                }
                Container[] children = this.findChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (!(children[i] instanceof Lifecycle)) continue;
                    ((Lifecycle)((Object)children[i])).start();
                }
                if (this.pipeline instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.pipeline)).start();
                }
                this.lifecycle.fireLifecycleEvent("start", null);
                Manager contextManager = null;
                if (this.manager == null) {
                    if (this.getCluster() != null && this.distributable) {
                        try {
                            contextManager = this.getCluster().createManager(this.getName());
                        }
                        catch (Exception ex) {
                            log.error((Object)"standardContext.clusterFail", (Throwable)ex);
                            ok = false;
                        }
                    } else {
                        contextManager = new StandardManager();
                    }
                }
                if (contextManager != null) {
                    this.setManager(contextManager);
                }
                if (this.manager != null && this.getCluster() != null && this.distributable) {
                    this.getCluster().registerManager(this.manager);
                }
                mainOk = true;
            }
        }
        finally {
            this.unbindThread(oldCCL);
            if (!mainOk) {
                this.registerJMX();
            }
        }
        if (!this.getConfigured()) {
            log.error((Object)"Error getConfigured");
            ok = false;
        }
        if (ok) {
            this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
        }
        this.mapper.setContext(this.getPath(), this.welcomeFiles, (javax.naming.Context)this.resources);
        oldCCL = this.bindThread();
        if (ok && !this.getIgnoreAnnotations()) {
            if (this.annotationProcessor == null) {
                this.annotationProcessor = this.isUseNaming() && this.namingContextListener != null ? new DefaultAnnotationProcessor(this.namingContextListener.getEnvContext()) : new DefaultAnnotationProcessor(null);
            }
            this.getServletContext().setAttribute(AnnotationProcessor.class.getName(), (Object)this.annotationProcessor);
        }
        try {
            if (ok) {
                this.postWelcomeFiles();
            }
            if (ok) {
                this.lifecycle.fireLifecycleEvent("after_start", null);
            }
            if (ok && !this.listenerStart()) {
                log.error((Object)"Error listenerStart");
                ok = false;
            }
            try {
                if (this.manager != null && this.manager instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.getManager())).start();
                }
                super.threadStart();
            }
            catch (Exception e) {
                log.error((Object)"Error manager.start()", (Throwable)e);
                ok = false;
            }
            if (ok && !this.filterStart()) {
                log.error((Object)"Error filterStart");
                ok = false;
            }
            if (ok) {
                this.loadOnStartup(this.findChildren());
            }
        }
        finally {
            this.unbindThread(oldCCL);
        }
        if (ok) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting completed");
            }
            this.setAvailable(true);
        } else {
            log.error((Object)sm.getString("standardContext.startFailed", this.getName()));
            try {
                this.stop();
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("standardContext.startCleanup"), t);
            }
            this.setAvailable(false);
        }
        this.registerJMX();
        this.startTime = System.currentTimeMillis();
        if (ok && this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        if (this.getLoader() instanceof WebappLoader) {
            ((WebappLoader)this.getLoader()).closeJARs(true);
        }
        if (!ok && this.started) {
            this.stop();
        }
    }

    private void cacheContext() {
        block2: {
            try {
                File workDir = new File(this.getWorkPath());
                File ctxSer = new File(workDir, "_tomcat_context.ser");
                FileOutputStream fos = new FileOutputStream(ctxSer);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this);
                oos.close();
                fos.close();
            }
            catch (Throwable t) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)"Error saving context.ser ", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("containerBase.notStarted", this.logName()));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        this.setAvailable(false);
        ClassLoader oldCCL = this.bindThread();
        try {
            Container[] children = this.findChildren();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)children[i])).stop();
            }
            this.filterStop();
            super.threadStop();
            if (this.manager != null && this.manager instanceof Lifecycle) {
                ((Lifecycle)((Object)this.manager)).stop();
            }
            this.listenerStop();
            this.setCharsetMapper(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processing standard container shutdown");
            }
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.started = false;
            if (this.pipeline instanceof Lifecycle) {
                ((Lifecycle)((Object)this.pipeline)).stop();
            }
            if (this.context != null) {
                this.context.clearAttributes();
            }
            this.resourcesStop();
            if (this.realm != null && this.realm instanceof Lifecycle) {
                ((Lifecycle)((Object)this.realm)).stop();
            }
            if (this.cluster != null && this.cluster instanceof Lifecycle) {
                ((Lifecycle)((Object)this.cluster)).stop();
            }
            if (this.logger != null && this.logger instanceof Lifecycle) {
                ((Lifecycle)this.logger).stop();
            }
            if (this.loader != null && this.loader instanceof Lifecycle) {
                ((Lifecycle)((Object)this.loader)).stop();
            }
        }
        finally {
            this.unbindThread(oldCCL);
        }
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        this.context = null;
        try {
            this.resetContext();
        }
        catch (Exception ex) {
            log.error((Object)("Error reseting context " + this + " " + ex), (Throwable)ex);
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (this.oname != null) {
            Notification notification = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        super.destroy();
        this.lifecycle.fireLifecycleEvent("destroy", null);
        Object object = this.instanceListenersLock;
        synchronized (object) {
            this.instanceListeners = new String[0];
        }
    }

    private void resetContext() throws Exception, MBeanRegistrationException {
        this.children = new HashMap();
        this.startupTime = 0L;
        this.startTime = 0L;
        this.tldScanTime = 0L;
        this.distributable = false;
        this.applicationListeners = new String[0];
        this.applicationEventListenersObjects = new Object[0];
        this.applicationLifecycleListenersObjects = new Object[0];
        this.taglibs = new HashMap();
        this.annotationProcessor = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("resetContext " + this.oname));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardContext[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    protected String adjustURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return urlPattern;
        }
        if (urlPattern.startsWith("/") || urlPattern.startsWith("*.")) {
            return urlPattern;
        }
        if (!this.isServlet22()) {
            return urlPattern;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("standardContext.urlPattern.patternWarning", urlPattern));
        }
        return "/" + urlPattern;
    }

    protected boolean isServlet22() {
        if (this.publicId == null) {
            return false;
        }
        return this.publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
    }

    protected File engineBase() {
        String base = System.getProperty("catalina.base");
        if (base == null) {
            StandardEngine eng = (StandardEngine)this.getParent().getParent();
            base = eng.getBaseDir();
        }
        return new File(base);
    }

    private ClassLoader bindThread() {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.getResources() == null) {
            return oldContextClassLoader;
        }
        if (this.getLoader().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
        }
        DirContextURLStreamHandler.bind(this.getResources());
        if (this.isUseNaming()) {
            try {
                ContextBindings.bindThread(this, this);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return oldContextClassLoader;
    }

    private void unbindThread(ClassLoader oldContextClassLoader) {
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        oldContextClassLoader = null;
        if (this.isUseNaming()) {
            ContextBindings.unbindThread(this, this);
        }
        DirContextURLStreamHandler.unbind();
    }

    protected String getBasePath() {
        Container container;
        String docBase = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        File file = new File(this.getDocBase());
        if (!file.isAbsolute()) {
            if (container == null) {
                docBase = new File(this.engineBase(), this.getDocBase()).getPath();
            } else {
                String appBase = ((Host)container).getAppBase();
                file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(), appBase);
                }
                docBase = new File(file, this.getDocBase()).getPath();
            }
        } else {
            docBase = file.getPath();
        }
        return docBase;
    }

    protected String getAppBase() {
        Container container;
        String appBase = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        if (container != null) {
            appBase = ((Host)container).getAppBase();
        }
        return appBase;
    }

    public File getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        if (!configBase.exists()) {
            return null;
        }
        StandardContext host = null;
        Container engine = null;
        for (Container container = this; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            configBase = new File(configBase, engine.getName());
        }
        if (host != null) {
            configBase = new File(configBase, host.getName());
        }
        if (this.saveConfig) {
            configBase.mkdirs();
        }
        return configBase;
    }

    protected String getDefaultConfigFile() {
        String basename = null;
        String path = this.getPath();
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename + ".xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(File src, File dest) {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int len;
            is = new FileInputStream(src);
            os = new FileOutputStream(dest);
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {}
        }
        return true;
    }

    private String getNamingContextName() {
        if (this.namingContextName == null) {
            Container parent = this.getParent();
            if (parent == null) {
                this.namingContextName = this.getName();
            } else {
                Stack<String> stk = new Stack<String>();
                StringBuffer buff = new StringBuffer();
                while (parent != null) {
                    stk.push(parent.getName());
                    parent = parent.getParent();
                }
                while (!stk.empty()) {
                    buff.append("/" + stk.pop());
                }
                buff.append(this.getName());
                this.namingContextName = buff.toString();
            }
        }
        return this.namingContextName;
    }

    public NamingContextListener getNamingContextListener() {
        return this.namingContextListener;
    }

    public void setNamingContextListener(NamingContextListener namingContextListener) {
        this.namingContextListener = namingContextListener;
    }

    public boolean getPaused() {
        return this.paused;
    }

    private void postResources() {
        this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
    }

    private void postWelcomeFiles() {
        this.getServletContext().setAttribute("org.apache.catalina.WELCOME_FILES", (Object)this.welcomeFiles);
    }

    public String getHostname() {
        Container parentHost = this.getParent();
        if (parentHost != null) {
            this.hostName = parentHost.getName();
        }
        if (this.hostName == null || this.hostName.length() < 1) {
            this.hostName = "_";
        }
        return this.hostName;
    }

    private void postWorkDirectory() {
        File dir;
        String workDir = this.getWorkDir();
        if (workDir == null || workDir.length() == 0) {
            String temp;
            String hostName = null;
            String engineName = null;
            String hostWorkDir = null;
            Container parentHost = this.getParent();
            if (parentHost != null) {
                Container parentEngine;
                hostName = parentHost.getName();
                if (parentHost instanceof StandardHost) {
                    hostWorkDir = ((StandardHost)parentHost).getWorkDir();
                }
                if ((parentEngine = parentHost.getParent()) != null) {
                    engineName = parentEngine.getName();
                }
            }
            if (hostName == null || hostName.length() < 1) {
                hostName = "_";
            }
            if (engineName == null || engineName.length() < 1) {
                engineName = "_";
            }
            if ((temp = this.getPath()).startsWith("/")) {
                temp = temp.substring(1);
            }
            temp = temp.replace('/', '_');
            if ((temp = temp.replace('\\', '_')).length() < 1) {
                temp = "_";
            }
            workDir = hostWorkDir != null ? hostWorkDir + File.separator + temp : "work" + File.separator + engineName + File.separator + hostName + File.separator + temp;
            this.setWorkDir(workDir);
        }
        if (!(dir = new File(workDir)).isAbsolute()) {
            File catalinaHome = this.engineBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                dir = new File(catalinaHomePath, workDir);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        dir.mkdirs();
        this.getServletContext().setAttribute("javax.servlet.context.tempdir", (Object)dir);
        if (this.getServletContext() instanceof ApplicationContext) {
            ((ApplicationContext)this.getServletContext()).setAttributeReadOnly("javax.servlet.context.tempdir");
        }
    }

    private void setPaused(boolean paused) {
        this.paused = paused;
    }

    private boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.indexOf(10) >= 0 || urlPattern.indexOf(13) >= 0) {
            return false;
        }
        if (urlPattern.startsWith("*.")) {
            if (urlPattern.indexOf(47) < 0) {
                this.checkUnusualURLPattern(urlPattern);
                return true;
            }
            return false;
        }
        if (urlPattern.startsWith("/") && urlPattern.indexOf("*.") < 0) {
            this.checkUnusualURLPattern(urlPattern);
            return true;
        }
        return false;
    }

    private void checkUnusualURLPattern(String urlPattern) {
        if (log.isInfoEnabled() && urlPattern.endsWith("*") && (urlPattern.length() < 2 || urlPattern.charAt(urlPattern.length() - 2) != '/')) {
            log.info((Object)("Suspicious url pattern: \"" + urlPattern + "\"" + " in context [" + this.getName() + "] - see" + " section SRV.11.2 of the Servlet specification"));
        }
    }

    public String getDeploymentDescriptor() {
        InputStream stream = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        }
        if (stream == null) {
            return "";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuffer sb = new StringBuffer();
        String strRead = "";
        try {
            while (strRead != null) {
                sb.append(strRead);
                strRead = br.readLine();
            }
        }
        catch (IOException e) {
            return "";
        }
        return sb.toString();
    }

    public String[] getServlets() {
        String[] result = null;
        Container[] children = this.findChildren();
        if (children != null) {
            result = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                result[i] = ((StandardWrapper)children[i]).getObjectName();
            }
        }
        return result;
    }

    public ObjectName createObjectName(String hostDomain, ObjectName parentName) throws MalformedObjectNameException {
        StandardHost hst = (StandardHost)this.getParent();
        String pathName = this.getName();
        String hostName = this.getParent().getName();
        String name = "//" + (hostName == null ? "DEFAULT" : hostName) + ("".equals(pathName) ? "/" : pathName);
        String suffix = ",J2EEApplication=" + this.getJ2EEApplication() + ",J2EEServer=" + this.getJ2EEServer();
        String onameStr = "j2eeType=WebModule,name=" + name + suffix;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering " + onameStr + " for " + this.oname));
        }
        if (this.getDomain() == null) {
            this.domain = hst.getDomain();
        }
        ObjectName oname = new ObjectName(this.getDomain() + ":" + onameStr);
        return oname;
    }

    private void preRegisterJMX() {
        block3: {
            try {
                StandardHost host = (StandardHost)this.getParent();
                if (this.oname == null || this.oname.getKeyProperty("j2eeType") == null) {
                    this.controller = this.oname = this.createObjectName(host.getDomain(), host.getJmxName());
                }
            }
            catch (Exception ex) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)("Error registering ctx with jmx " + this + " " + this.oname + " " + ex.toString()), (Throwable)ex);
            }
        }
    }

    private void registerJMX() {
        block6: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking for " + this.oname));
                }
                if (!Registry.getRegistry(null, null).getMBeanServer().isRegistered(this.oname)) {
                    this.controller = this.oname;
                    Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                    if (this.getObjectName() != null) {
                        Notification notification = new Notification("j2ee.object.created", this.getObjectName(), this.sequenceNumber++);
                        this.broadcaster.sendNotification(notification);
                    }
                }
                Container[] children = this.findChildren();
                for (int i = 0; children != null && i < children.length; ++i) {
                    ((StandardWrapper)children[i]).registerJMX(this);
                }
            }
            catch (Exception ex) {
                if (!log.isInfoEnabled()) break block6;
                log.info((Object)("Error registering wrapper with jmx " + this + " " + this.oname + " " + ex.toString()), (Throwable)ex);
            }
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.oname != null) {
            return name;
        }
        ObjectName result = super.preRegister(server, name);
        return name;
    }

    public void preDeregister() throws Exception {
        if (this.started) {
            try {
                this.stop();
            }
            catch (Exception ex) {
                log.error((Object)"error stopping ", (Throwable)ex);
            }
        }
    }

    public void init() throws Exception {
        if (this.getParent() == null) {
            ObjectName parentName = this.getParentName();
            if (!this.mserver.isRegistered(parentName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No host, creating one " + parentName));
                }
                StandardHost host = new StandardHost();
                host.setName(this.hostName);
                host.setAutoDeploy(false);
                Registry.getRegistry(null, null).registerComponent((Object)host, parentName, null);
                host.init();
            }
            LifecycleListener config = null;
            try {
                String configClassName = null;
                try {
                    configClassName = String.valueOf(this.mserver.getAttribute(parentName, "configClass"));
                }
                catch (AttributeNotFoundException e) {
                    // empty catch block
                }
                if (configClassName != null) {
                    Class<?> clazz = Class.forName(configClassName);
                    config = (LifecycleListener)clazz.newInstance();
                } else {
                    config = new ContextConfig();
                }
            }
            catch (Exception e) {
                log.warn((Object)("Error creating ContextConfig for " + parentName), (Throwable)e);
                throw e;
            }
            this.addLifecycleListener(config);
            if (log.isDebugEnabled()) {
                log.debug((Object)("AddChild " + parentName + " " + this));
            }
            try {
                this.mserver.invoke(parentName, "addChild", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
            }
            catch (Exception e) {
                this.destroy();
                throw e;
            }
            if (this.initialized) {
                return;
            }
        }
        if (this.processTlds) {
            this.addLifecycleListener(new TldConfig());
        }
        super.init();
        this.lifecycle.fireLifecycleEvent("init", null);
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
    }

    public ObjectName getParentName() throws MalformedObjectNameException {
        String path = this.oname.getKeyProperty("name");
        if (path == null) {
            log.error((Object)("No name attribute " + this.name));
            return null;
        }
        if (!path.startsWith("//")) {
            log.error((Object)("Invalid name " + this.name));
        }
        path = path.substring(2);
        int delim = path.indexOf("/");
        this.hostName = "localhost";
        if (delim > 0) {
            this.hostName = path.substring(0, delim);
            if ((path = path.substring(delim)).equals("/")) {
                this.setName("");
            } else {
                this.setName(path);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting path " + path));
            }
            this.setName(path);
        }
        String parentDomain = this.getEngineName();
        if (parentDomain == null) {
            parentDomain = this.domain;
        }
        ObjectName parentName = new ObjectName(parentDomain + ":" + "type=Host,host=" + this.hostName);
        return parentName;
    }

    public void create() throws Exception {
        this.init();
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, object);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notificationInfo == null) {
            this.notificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"j2ee.object.created"}, Notification.class.getName(), "web application is created"), new MBeanNotificationInfo(new String[]{"j2ee.state.starting"}, Notification.class.getName(), "change web application is starting"), new MBeanNotificationInfo(new String[]{"j2ee.state.running"}, Notification.class.getName(), "web application is running"), new MBeanNotificationInfo(new String[]{"j2ee.state.stopped"}, Notification.class.getName(), "web application start to stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.stopped"}, Notification.class.getName(), "web application is stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.deleted"}, Notification.class.getName(), "web application is deleted")};
        }
        return this.notificationInfo;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, object);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    public DirContext getStaticResources() {
        return this.getResources();
    }

    public DirContext findStaticResources() {
        return this.getResources();
    }

    public String[] getWelcomeFiles() {
        return this.findWelcomeFiles();
    }

    public void setXmlValidation(boolean webXmlValidation) {
        this.webXmlValidation = webXmlValidation;
    }

    public boolean getXmlValidation() {
        return this.webXmlValidation;
    }

    public boolean getXmlNamespaceAware() {
        return this.webXmlNamespaceAware;
    }

    public void setXmlNamespaceAware(boolean webXmlNamespaceAware) {
        this.webXmlNamespaceAware = webXmlNamespaceAware;
    }

    public void setTldValidation(boolean tldValidation) {
        this.tldValidation = tldValidation;
    }

    public boolean getTldValidation() {
        return this.tldValidation;
    }

    public void setProcessTlds(boolean newProcessTlds) {
        this.processTlds = newProcessTlds;
    }

    public boolean getProcessTlds() {
        return this.processTlds;
    }

    public boolean getTldNamespaceAware() {
        return this.tldNamespaceAware;
    }

    public void setTldNamespaceAware(boolean tldNamespaceAware) {
        this.tldNamespaceAware = tldNamespaceAware;
    }

    public boolean isStateManageable() {
        return true;
    }

    public void startRecursive() throws LifecycleException {
        this.start();
    }

    public int getState() {
        if (this.started) {
            return 1;
        }
        if (this.initialized) {
            return 0;
        }
        if (!this.available) {
            return 4;
        }
        return 3;
    }

    public String getServer() {
        return this.server;
    }

    public String setServer(String server) {
        this.server = server;
        return this.server;
    }

    public String[] getJavaVMs() {
        return this.javaVMs;
    }

    public String[] setJavaVMs(String[] javaVMs) {
        this.javaVMs = javaVMs;
        return javaVMs;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    static {
        urlEncoder.addSafeCharacter('~');
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
    }
}

