/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.Placeholder;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFComments;
import org.apache.poi.xslf.usermodel.XSLFGroupShape;
import org.apache.poi.xslf.usermodel.XSLFNotes;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.poi.xslf.usermodel.XSLFTableRow;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTComment;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFPowerPointExtractorDecorator
extends AbstractOOXMLExtractor {
    public XSLFPowerPointExtractorDecorator(ParseContext context, XSLFPowerPointExtractor extractor) {
        super(context, extractor);
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, IOException {
        XSLFSlide[] slides;
        XMLSlideShow slideShow = (XMLSlideShow)this.extractor.getDocument();
        for (XSLFSlide slide : slides = slideShow.getSlides()) {
            XSLFComments comments;
            this.extractContent(slide.getShapes(), false, xhtml);
            XSLFSlideLayout slideLayout = slide.getMasterSheet();
            this.extractContent(slideLayout.getShapes(), true, xhtml);
            XSLFSheet slideMaster = ((XSLFSheet)slideLayout).getMasterSheet();
            this.extractContent(slideMaster.getShapes(), true, xhtml);
            XSLFNotes slideNotes = slide.getNotes();
            if (slideNotes != null) {
                this.extractContent(slideNotes.getShapes(), false, xhtml);
                XSLFSheet notesMaster = ((XSLFSheet)slideNotes).getMasterSheet();
                this.extractContent(notesMaster.getShapes(), true, xhtml);
            }
            if ((comments = slide.getComments()) == null) continue;
            for (CTComment comment : comments.getCTCommentsList().getCmList()) {
                xhtml.element("p", comment.getText());
            }
        }
    }

    private void extractContent(XSLFShape[] shapes, boolean skipPlaceholders, XHTMLContentHandler xhtml) throws SAXException {
        for (XSLFShape sh : shapes) {
            if (sh instanceof XSLFTextShape) {
                XSLFTextShape txt = (XSLFTextShape)sh;
                Placeholder ph = txt.getTextType();
                if (skipPlaceholders && ph != null) continue;
                xhtml.element("p", txt.getText());
                continue;
            }
            if (sh instanceof XSLFGroupShape) {
                XSLFGroupShape group = (XSLFGroupShape)sh;
                this.extractContent(group.getShapes(), skipPlaceholders, xhtml);
                continue;
            }
            if (!(sh instanceof XSLFTable)) continue;
            XSLFTable tbl = (XSLFTable)sh;
            for (XSLFTableRow row : tbl) {
                List<XSLFTableCell> cells = row.getCells();
                this.extractContent(cells.toArray(new XSLFTableCell[cells.size()]), skipPlaceholders, xhtml);
            }
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() throws TikaException {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        XMLSlideShow slideShow = (XMLSlideShow)this.extractor.getDocument();
        XSLFSlideShow document = null;
        try {
            document = slideShow._getXSLFSlideShow();
        }
        catch (Exception e) {
            throw new TikaException(e.getMessage());
        }
        for (CTSlideIdListEntry ctSlide : document.getSlideReferences().getSldIdList()) {
            PackagePart slidePart;
            try {
                slidePart = document.getSlidePart(ctSlide);
            }
            catch (IOException e) {
                throw new TikaException("Broken OOXML file", e);
            }
            catch (XmlException xe) {
                throw new TikaException("Broken OOXML file", xe);
            }
            parts.add(slidePart);
            try {
                for (PackageRelationship rel : slidePart.getRelationshipsByType(XSLFRelation.VML_DRAWING.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    PackagePartName relName = PackagingURIHelper.createPartName(rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
            }
            catch (InvalidFormatException e) {
                throw new TikaException("Broken OOXML file", e);
            }
        }
        return parts;
    }
}

