/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoBufferWrapper;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Descriptor(tags={3})
public class ESDescriptor
extends BaseDescriptor {
    private static Logger log = Logger.getLogger(ESDescriptor.class.getName());
    int esId;
    int streamDependenceFlag;
    int URLFlag;
    int oCRstreamFlag;
    int streamPriority;
    int URLLength = 0;
    String URLString;
    int remoteODFlag;
    int dependsOnEsId;
    int oCREsId;
    DecoderConfigDescriptor decoderConfigDescriptor;
    SLConfigDescriptor slConfigDescriptor;
    List<BaseDescriptor> otherDescriptors = new ArrayList<BaseDescriptor>();

    @Override
    public void parse(int tag, IsoBufferWrapper in, int maxLength) throws IOException {
        int size;
        long read;
        BaseDescriptor descriptor;
        super.parse(tag, in, maxLength);
        this.esId = in.readUInt16();
        int data = in.readUInt8();
        this.streamDependenceFlag = data >>> 7;
        this.URLFlag = data >>> 6 & 1;
        this.oCRstreamFlag = data >>> 5 & 1;
        this.streamPriority = data & 0x1F;
        if (this.streamDependenceFlag == 1) {
            this.dependsOnEsId = in.readUInt16();
        }
        if (this.URLFlag == 1) {
            this.URLLength = in.readUInt8();
            this.URLString = new String(in.read(this.URLLength));
        }
        if (this.oCRstreamFlag == 1) {
            this.oCREsId = in.readUInt16();
        }
        int baseSize = 1 + this.getSizeBytes() + 2 + 1 + (this.streamDependenceFlag == 1 ? 2 : 0) + (this.URLFlag == 1 ? 1 + this.URLLength : 0) + (this.oCRstreamFlag == 1 ? 2 : 0);
        long begin = in.position();
        if (this.getSize() > baseSize + 2) {
            descriptor = ObjectDescriptorFactory.createFrom(-1, in, this.getSize() - baseSize);
            read = in.position() - begin;
            log.finer(descriptor + " - ESDescriptor1 read: " + read + ", size: " + (descriptor != null ? Integer.valueOf(descriptor.getSize()) : null));
            if (descriptor != null) {
                size = descriptor.getSize();
                in.position(begin + (long)size);
                baseSize += size;
            } else {
                baseSize = (int)((long)baseSize + read);
            }
            if (descriptor instanceof DecoderConfigDescriptor) {
                this.decoderConfigDescriptor = (DecoderConfigDescriptor)descriptor;
            }
        }
        begin = in.position();
        if (this.getSize() > baseSize + 2) {
            descriptor = ObjectDescriptorFactory.createFrom(-1, in, this.getSize() - baseSize);
            read = in.position() - begin;
            log.finer(descriptor + " - ESDescriptor2 read: " + read + ", size: " + (descriptor != null ? Integer.valueOf(descriptor.getSize()) : null));
            if (descriptor != null) {
                size = descriptor.getSize();
                in.position(begin + (long)size);
                baseSize += size;
            } else {
                baseSize = (int)((long)baseSize + read);
            }
            if (descriptor instanceof SLConfigDescriptor) {
                this.slConfigDescriptor = (SLConfigDescriptor)descriptor;
            }
        } else {
            log.warning("SLConfigDescriptor is missing!");
        }
        while (this.getSize() - baseSize > 2) {
            begin = in.position();
            descriptor = ObjectDescriptorFactory.createFrom(-1, in, this.getSize() - baseSize);
            read = in.position() - begin;
            log.finer(descriptor + " - ESDescriptor3 read: " + read + ", size: " + (descriptor != null ? Integer.valueOf(descriptor.getSize()) : null));
            if (descriptor != null) {
                size = descriptor.getSize();
                in.position(begin + (long)size);
                baseSize += size;
            } else {
                baseSize = (int)((long)baseSize + read);
            }
            this.otherDescriptors.add(descriptor);
        }
    }

    public DecoderConfigDescriptor getDecoderConfigDescriptor() {
        return this.decoderConfigDescriptor;
    }

    public SLConfigDescriptor getSlConfigDescriptor() {
        return this.slConfigDescriptor;
    }

    public List<BaseDescriptor> getOtherDescriptors() {
        return this.otherDescriptors;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ESDescriptor");
        sb.append("{esId=").append(this.esId);
        sb.append(", streamDependenceFlag=").append(this.streamDependenceFlag);
        sb.append(", URLFlag=").append(this.URLFlag);
        sb.append(", oCRstreamFlag=").append(this.oCRstreamFlag);
        sb.append(", streamPriority=").append(this.streamPriority);
        sb.append(", URLLength=").append(this.URLLength);
        sb.append(", URLString='").append(this.URLString).append('\'');
        sb.append(", remoteODFlag=").append(this.remoteODFlag);
        sb.append(", dependsOnEsId=").append(this.dependsOnEsId);
        sb.append(", oCREsId=").append(this.oCREsId);
        sb.append(", decoderConfigDescriptor=").append(this.decoderConfigDescriptor);
        sb.append(", slConfigDescriptor=").append(this.slConfigDescriptor);
        sb.append('}');
        return sb.toString();
    }
}

