/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class OmaDrmContentObjectBox
extends AbstractFullBox {
    private long omaDrmDataLength;
    private byte[] omaDrmData;
    public static final String TYPE = "odda";

    public byte[] getHeader() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IsoOutputStream ios = new IsoOutputStream(baos);
            ios.writeUInt32(1L);
            ios.write(this.getType());
            ios.writeUInt64(this.getSize());
            ios.writeUInt8(this.getVersion());
            ios.writeUInt24(this.getFlags());
            assert ((long)baos.size() == this.getHeaderSize());
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected long getHeaderSize() {
        return 20L;
    }

    public OmaDrmContentObjectBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public long getOmaDrmDataLength() {
        return this.omaDrmDataLength;
    }

    public byte[] getOmaDrmData() {
        return this.omaDrmData;
    }

    protected long getContentSize() {
        return 8L + this.omaDrmDataLength;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.omaDrmDataLength = in.readUInt64();
        this.omaDrmData = in.read((int)this.omaDrmDataLength);
        assert (size == 12L + this.omaDrmDataLength);
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt64(this.omaDrmDataLength);
        os.write(this.omaDrmData);
    }

    public String toString() {
        return "OmaDrmContentObjectBox[omaDrmDataLength=" + this.getOmaDrmDataLength() + "]";
    }
}

