/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTypeBox
extends AbstractBox {
    public static final String TYPE = "ftyp";
    private String majorBrand;
    private long minorVersion;
    private List<String> compatibleBrands;

    public FileTypeBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public FileTypeBox(String majorBrand, long minorVersion, List<String> compatibleBrands) {
        super(IsoFile.fourCCtoBytes(TYPE));
        this.majorBrand = majorBrand;
        this.minorVersion = minorVersion;
        this.compatibleBrands = compatibleBrands;
    }

    @Override
    protected long getContentSize() {
        return 8 + this.compatibleBrands.size() * 4;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.majorBrand = IsoFile.bytesToFourCC(in.read(4));
        this.minorVersion = in.readUInt32();
        int compatibleBrandsCount = (int)((size - 8L) / 4L);
        this.compatibleBrands = new LinkedList<String>();
        for (int i = 0; i < compatibleBrandsCount; ++i) {
            this.compatibleBrands.add(IsoFile.bytesToFourCC(in.read(4)));
        }
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(IsoFile.fourCCtoBytes(this.majorBrand));
        isos.writeUInt32(this.minorVersion);
        for (String compatibleBrand : this.compatibleBrands) {
            isos.write(IsoFile.fourCCtoBytes(compatibleBrand));
        }
    }

    public String getMajorBrand() {
        return this.majorBrand;
    }

    public void setMajorBrand(String majorBrand) {
        this.majorBrand = majorBrand;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public long getMinorVersion() {
        return this.minorVersion;
    }

    public List<String> getCompatibleBrands() {
        return this.compatibleBrands;
    }

    public void setCompatibleBrands(List<String> compatibleBrands) {
        this.compatibleBrands = compatibleBrands;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("FileTypeBox[");
        result.append("majorBrand=").append(this.getMajorBrand());
        result.append(";");
        result.append("minorVersion=").append(this.getMinorVersion());
        for (String compatibleBrand : this.compatibleBrands) {
            result.append(";");
            result.append("compatibleBrand=").append(compatibleBrand);
        }
        result.append("]");
        return result.toString();
    }
}

