/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.yuicompressor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.management.RuntimeErrorException;
import org.apache.tapestry5.internal.IOOperation;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.internal.services.assets.StreamableResourceImpl;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.ResourceMinimizer;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.slf4j.Logger;

public abstract class AbstractMinimizer
implements ResourceMinimizer {
    private static final double NANOS_TO_MILLIS = 1.0E-6;
    private final Logger logger;
    private final OperationTracker tracker;
    private final String resourceType;

    public AbstractMinimizer(Logger logger, OperationTracker tracker, String resourceType) {
        this.logger = logger;
        this.tracker = tracker;
        this.resourceType = resourceType;
    }

    public StreamableResource minimize(final StreamableResource input) throws IOException {
        long startNanos = System.nanoTime();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
        final OutputStreamWriter writer = new OutputStreamWriter(bos);
        TapestryInternalUtils.performIO((OperationTracker)this.tracker, (String)("Minimizing " + this.resourceType), (IOOperation)new IOOperation(){

            public void perform() throws IOException {
                try {
                    AbstractMinimizer.this.doMinimize(input, writer);
                }
                catch (RuntimeErrorException ex) {
                    throw new RuntimeException(String.format("Unable to minimize %s: %s", AbstractMinimizer.this.resourceType, InternalUtils.toMessage((Throwable)ex)), ex);
                }
            }
        });
        ((Writer)writer).close();
        StreamableResourceImpl output = new StreamableResourceImpl("minimized " + input.getDescription(), input.getContentType(), CompressionStatus.COMPRESSABLE, input.getLastModified(), new BytestreamCache(bos));
        long elapsedNanos = System.nanoTime() - startNanos;
        if (this.logger.isDebugEnabled()) {
            double elapsedMillis = (double)elapsedNanos * 1.0E-6;
            this.logger.debug(String.format("Minimized %s (%,d input bytes of %s to %,d output bytes in %.2f ms)", input.getDescription(), input.getSize(), this.resourceType, output.getSize(), elapsedMillis));
        }
        return output;
    }

    protected Reader toReader(StreamableResource input) throws IOException {
        InputStream is = input.openStream();
        return new InputStreamReader(is, "UTF-8");
    }

    protected abstract void doMinimize(StreamableResource var1, Writer var2) throws IOException;
}

