/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import java.io.File;
import org.apache.tapestry5.test.TapestryTestConstants;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;

public class Jetty7Runner {
    private final Server jettyServer;
    private final String description;
    private final int port;
    private final int sslPort;

    public Jetty7Runner(String webappFolder, String contextPath, int port, int sslPort) throws Exception {
        this.port = port;
        this.sslPort = sslPort;
        String expandedPath = this.expand(webappFolder);
        this.description = String.format("<Jetty7Runner: %s:%s/%s (%s)", contextPath, port, sslPort, expandedPath);
        this.jettyServer = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath(contextPath);
        webapp.setWar(expandedPath);
        File keystoreFile = new File(TapestryTestConstants.MODULE_BASE_DIR, "src/test/conf/keystore");
        if (keystoreFile.exists()) {
            SslSelectChannelConnector sslConnector = new SslSelectChannelConnector();
            sslConnector.setPort(sslPort);
            sslConnector.setKeystore(keystoreFile.getPath());
            sslConnector.setPassword("tapestry");
            sslConnector.setKeyPassword("tapestry");
            this.jettyServer.addConnector((Connector)sslConnector);
        }
        this.jettyServer.setHandler((Handler)webapp);
        this.jettyServer.start();
    }

    public void stop() {
        System.out.printf("Stopping Jetty instance on port %d/%d\n", this.port, this.sslPort);
        try {
            this.jettyServer.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error stopping Jetty instance: " + ex.toString(), ex);
        }
        System.out.println("Jetty instance has stopped.");
    }

    public String toString() {
        return this.description;
    }

    protected String expand(String moduleLocalPath) {
        File path = new File(moduleLocalPath);
        if (path.isAbsolute() && path.isDirectory()) {
            return moduleLocalPath;
        }
        return new File(TapestryTestConstants.MODULE_BASE_DIR, moduleLocalPath).getPath();
    }
}

