/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.HttpCommandProcessor;
import com.thoughtworks.selenium.Selenium;
import org.apache.tapestry5.test.ErrorReporterImpl;
import org.apache.tapestry5.test.ErrorReportingCommandProcessor;
import org.apache.tapestry5.test.JettyRunner;
import org.apache.tapestry5.test.TapestryTestConstants;
import org.openqa.selenium.server.SeleniumServer;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class AbstractIntegrationTestSuite
extends Assert
implements Selenium {
    public static final String DEFAULT_WEB_APP_ROOT = "src/main/webapp";
    public static final String DEFAULT_WEB_BROWSER_COMMAND = "*firefox";
    public static final String PAGE_LOAD_TIMEOUT = "15000";
    public static final int JETTY_PORT = 9999;
    public static final String BASE_URL = String.format("http://localhost:%d/", 9999);
    public static final String SUBMIT = "//input[@type='submit']";
    private String webappRoot;
    private final String seleniumBrowserCommand;
    private JettyRunner jettyRunner;
    private Selenium selenium;
    private SeleniumServer server;
    private String[] virtualHosts;

    public AbstractIntegrationTestSuite() {
        this(DEFAULT_WEB_APP_ROOT, DEFAULT_WEB_BROWSER_COMMAND, new String[0]);
    }

    protected AbstractIntegrationTestSuite(String webAppRoot) {
        this(webAppRoot, DEFAULT_WEB_BROWSER_COMMAND, new String[0]);
    }

    protected AbstractIntegrationTestSuite(String webAppRoot, String browserCommand, String ... virtualHosts) {
        this.webappRoot = webAppRoot;
        this.seleniumBrowserCommand = browserCommand;
        this.virtualHosts = virtualHosts;
    }

    protected final void assertSourcePresent(String ... expected) {
        String source = this.selenium.getHtmlSource();
        for (String snippet : expected) {
            if (source.contains(snippet)) continue;
            System.err.printf("Source content '%s' not found in:\n%s\n\n", snippet, source);
            throw new AssertionError((Object)("Page did not contain source '" + snippet + "'."));
        }
    }

    protected final void assertAttribute(String locator, String expected) {
        String actual = null;
        try {
            actual = this.getAttribute(locator);
        }
        catch (RuntimeException ex) {
            System.err.printf("Error accessing %s: %s, in:\n\n%s\n\n", locator, ex.getMessage(), this.selenium.getHtmlSource());
            throw ex;
        }
        if (actual.equals(expected)) {
            return;
        }
        System.err.printf("Text for attribute %s should be '%s' but is '%s', in:\n\n%s\n\n", locator, expected, actual, this.getHtmlSource());
        throw new AssertionError((Object)String.format("%s was '%s' not '%s'", locator, actual, expected));
    }

    protected final void assertText(String locator, String expected) {
        String actual = null;
        try {
            actual = this.getText(locator);
        }
        catch (RuntimeException ex) {
            System.err.printf("Error accessing %s: %s, in:\n\n%s\n\n", locator, ex.getMessage(), this.selenium.getHtmlSource());
            throw ex;
        }
        if (actual.equals(expected)) {
            return;
        }
        System.err.printf("Text for %s should be '%s' but is '%s', in:\n\n%s\n\n", locator, expected, actual, this.getHtmlSource());
        throw new AssertionError((Object)String.format("%s was '%s' not '%s'", locator, actual, expected));
    }

    protected final void assertTextPresent(String ... text) {
        for (String item : text) {
            if (this.isTextPresent(item)) continue;
            System.err.printf("Text pattern '%s' not found in:\n%s\n\n", item, this.selenium.getHtmlSource());
            throw new AssertionError((Object)("Page did not contain '" + item + "'."));
        }
    }

    protected final void assertFieldValue(String locator, String expected) {
        try {
            AbstractIntegrationTestSuite.assertEquals((String)this.getValue(locator), (String)expected);
        }
        catch (AssertionError ex) {
            System.err.printf("%s:\n%s\n\n", ((Throwable)((Object)ex)).getMessage(), this.selenium.getHtmlSource());
            throw ex;
        }
    }

    protected final void clickAndWait(String link) {
        this.click(link);
        this.waitForPageToLoad(PAGE_LOAD_TIMEOUT);
    }

    protected final void assertTextSeries(String idFormat, int startIndex, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            String id = String.format(idFormat, startIndex + i);
            this.assertText(id, values[i]);
        }
    }

    protected final void assertAttributeSeries(String idFormat, int startIndex, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            String id = String.format(idFormat, startIndex + i);
            this.assertAttribute(id, values[i]);
        }
    }

    protected final void assertFieldValueSeries(String idFormat, int startIndex, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            String id = String.format(idFormat, startIndex + i);
            this.assertFieldValue(id, values[i]);
        }
    }

    protected void waitForCSSSelectedElementToAppear(String cssRule) {
        String condition = String.format("selenium.browserbot.getCurrentWindow().$$(\"%s\").size() > 0", cssRule);
        this.waitForCondition(condition, PAGE_LOAD_TIMEOUT);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        if (this.selenium != null) {
            this.selenium.stop();
            this.selenium = null;
        }
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        if (this.jettyRunner != null) {
            this.jettyRunner.stop();
            this.jettyRunner = null;
        }
    }

    @BeforeClass(alwaysRun=true)
    public void setup(ITestContext testContext) throws Exception {
        this.jettyRunner = new JettyRunner(TapestryTestConstants.MODULE_BASE_DIR, "/", 9999, this.webappRoot, this.virtualHosts);
        this.server = new SeleniumServer();
        this.server.start();
        HttpCommandProcessor cp = new HttpCommandProcessor("localhost", 4444, this.seleniumBrowserCommand, BASE_URL);
        ErrorReporterImpl errorReporter = new ErrorReporterImpl((CommandProcessor)cp, testContext);
        this.selenium = new DefaultSelenium((CommandProcessor)new ErrorReportingCommandProcessor((CommandProcessor)cp, errorReporter));
        this.selenium.start();
    }

    public void start() {
        this.selenium.start();
    }

    public void stop() {
        this.selenium.stop();
    }

    public void click(String locator) {
        this.selenium.click(locator);
    }

    public void doubleClick(String locator) {
        this.selenium.doubleClick(locator);
    }

    public void contextMenu(String locator) {
        this.selenium.contextMenu(locator);
    }

    public void clickAt(String locator, String coordString) {
        this.selenium.clickAt(locator, coordString);
    }

    public void doubleClickAt(String locator, String coordString) {
        this.selenium.doubleClickAt(locator, coordString);
    }

    public void contextMenuAt(String locator, String coordString) {
        this.selenium.contextMenuAt(locator, coordString);
    }

    public void fireEvent(String locator, String eventName) {
        this.selenium.fireEvent(locator, eventName);
    }

    public void focus(String locator) {
        this.selenium.focus(locator);
    }

    public void keyPress(String locator, String keySequence) {
        this.selenium.keyPress(locator, keySequence);
    }

    public void shiftKeyDown() {
        this.selenium.shiftKeyDown();
    }

    public void shiftKeyUp() {
        this.selenium.shiftKeyUp();
    }

    public void metaKeyDown() {
        this.selenium.metaKeyDown();
    }

    public void metaKeyUp() {
        this.selenium.metaKeyUp();
    }

    public void altKeyDown() {
        this.selenium.altKeyDown();
    }

    public void altKeyUp() {
        this.selenium.altKeyUp();
    }

    public void controlKeyDown() {
        this.selenium.controlKeyDown();
    }

    public void controlKeyUp() {
        this.selenium.controlKeyUp();
    }

    public void keyDown(String locator, String keySequence) {
        this.selenium.keyDown(locator, keySequence);
    }

    public void keyUp(String locator, String keySequence) {
        this.selenium.keyUp(locator, keySequence);
    }

    public void mouseOver(String locator) {
        this.selenium.mouseOver(locator);
    }

    public void mouseOut(String locator) {
        this.selenium.mouseOut(locator);
    }

    public void mouseDown(String locator) {
        this.selenium.mouseDown(locator);
    }

    public void mouseDownAt(String locator, String coordString) {
        this.selenium.mouseDownAt(locator, coordString);
    }

    public void mouseUp(String locator) {
        this.selenium.mouseUp(locator);
    }

    public void mouseUpAt(String locator, String coordString) {
        this.selenium.mouseUpAt(locator, coordString);
    }

    public void mouseMove(String locator) {
        this.selenium.mouseMove(locator);
    }

    public void mouseMoveAt(String locator, String coordString) {
        this.selenium.mouseMoveAt(locator, coordString);
    }

    public void type(String locator, String value) {
        this.selenium.type(locator, value);
    }

    public void typeKeys(String locator, String value) {
        this.selenium.typeKeys(locator, value);
    }

    public void setSpeed(String value) {
        this.selenium.setSpeed(value);
    }

    public String getSpeed() {
        return this.selenium.getSpeed();
    }

    public void check(String locator) {
        this.selenium.check(locator);
    }

    public void uncheck(String locator) {
        this.selenium.uncheck(locator);
    }

    public void select(String selectLocator, String optionLocator) {
        this.selenium.select(selectLocator, optionLocator);
    }

    public void addSelection(String locator, String optionLocator) {
        this.selenium.addSelection(locator, optionLocator);
    }

    public void removeSelection(String locator, String optionLocator) {
        this.selenium.removeSelection(locator, optionLocator);
    }

    public void removeAllSelections(String locator) {
        this.selenium.removeAllSelections(locator);
    }

    public void submit(String formLocator) {
        this.selenium.submit(formLocator);
    }

    public void open(String url) {
        this.selenium.open(url, "true");
    }

    public void openWindow(String url, String windowID) {
        this.selenium.openWindow(url, windowID);
    }

    public void selectWindow(String windowID) {
        this.selenium.selectWindow(windowID);
    }

    public void selectFrame(String locator) {
        this.selenium.selectFrame(locator);
    }

    public boolean getWhetherThisFrameMatchFrameExpression(String currentFrameString, String target) {
        return this.selenium.getWhetherThisFrameMatchFrameExpression(currentFrameString, target);
    }

    public boolean getWhetherThisWindowMatchWindowExpression(String currentWindowString, String target) {
        return this.selenium.getWhetherThisWindowMatchWindowExpression(currentWindowString, target);
    }

    public void waitForPageToLoad() {
        this.waitForPageToLoad(PAGE_LOAD_TIMEOUT);
    }

    public void waitForPopUp(String windowID, String timeout) {
        this.selenium.waitForPopUp(windowID, timeout);
    }

    public void chooseCancelOnNextConfirmation() {
        this.selenium.chooseCancelOnNextConfirmation();
    }

    public void chooseOkOnNextConfirmation() {
        this.selenium.chooseOkOnNextConfirmation();
    }

    public void answerOnNextPrompt(String answer) {
        this.selenium.answerOnNextPrompt(answer);
    }

    public void goBack() {
        this.selenium.goBack();
    }

    public void refresh() {
        this.selenium.refresh();
    }

    public void close() {
        this.selenium.close();
    }

    public boolean isAlertPresent() {
        return this.selenium.isAlertPresent();
    }

    public boolean isPromptPresent() {
        return this.selenium.isPromptPresent();
    }

    public boolean isConfirmationPresent() {
        return this.selenium.isConfirmationPresent();
    }

    public String getAlert() {
        return this.selenium.getAlert();
    }

    public String getConfirmation() {
        return this.selenium.getConfirmation();
    }

    public String getPrompt() {
        return this.selenium.getPrompt();
    }

    public String getLocation() {
        return this.selenium.getLocation();
    }

    public String getTitle() {
        return this.selenium.getTitle();
    }

    public String getBodyText() {
        return this.selenium.getBodyText();
    }

    public String getValue(String locator) {
        return this.selenium.getValue(locator);
    }

    public String getText(String locator) {
        return this.selenium.getText(locator);
    }

    public void highlight(String locator) {
        this.selenium.highlight(locator);
    }

    public String getEval(String script) {
        return this.selenium.getEval(script);
    }

    public boolean isChecked(String locator) {
        return this.selenium.isChecked(locator);
    }

    public String getTable(String tableCellAddress) {
        return this.selenium.getTable(tableCellAddress);
    }

    public String[] getSelectedLabels(String selectLocator) {
        return this.selenium.getSelectedLabels(selectLocator);
    }

    public String getSelectedLabel(String selectLocator) {
        return this.selenium.getSelectedLabel(selectLocator);
    }

    public String[] getSelectedValues(String selectLocator) {
        return this.selenium.getSelectedValues(selectLocator);
    }

    public String getSelectedValue(String selectLocator) {
        return this.selenium.getSelectedValue(selectLocator);
    }

    public String[] getSelectedIndexes(String selectLocator) {
        return this.selenium.getSelectedIndexes(selectLocator);
    }

    public String getSelectedIndex(String selectLocator) {
        return this.selenium.getSelectedIndex(selectLocator);
    }

    public String[] getSelectedIds(String selectLocator) {
        return this.selenium.getSelectedIds(selectLocator);
    }

    public String getSelectedId(String selectLocator) {
        return this.selenium.getSelectedId(selectLocator);
    }

    public boolean isSomethingSelected(String selectLocator) {
        return this.selenium.isSomethingSelected(selectLocator);
    }

    public String[] getSelectOptions(String selectLocator) {
        return this.selenium.getSelectOptions(selectLocator);
    }

    public String getAttribute(String attributeLocator) {
        return this.selenium.getAttribute(attributeLocator);
    }

    public boolean isTextPresent(String pattern) {
        return this.selenium.isTextPresent(pattern);
    }

    public boolean isElementPresent(String locator) {
        return this.selenium.isElementPresent(locator);
    }

    public boolean isVisible(String locator) {
        return this.selenium.isVisible(locator);
    }

    public boolean isEditable(String locator) {
        return this.selenium.isEditable(locator);
    }

    public String[] getAllButtons() {
        return this.selenium.getAllButtons();
    }

    public String[] getAllLinks() {
        return this.selenium.getAllLinks();
    }

    public String[] getAllFields() {
        return this.selenium.getAllFields();
    }

    public String[] getAttributeFromAllWindows(String attributeName) {
        return this.selenium.getAttributeFromAllWindows(attributeName);
    }

    public void dragdrop(String locator, String movementsString) {
        this.selenium.dragdrop(locator, movementsString);
    }

    public void setMouseSpeed(String pixels) {
        this.selenium.setMouseSpeed(pixels);
    }

    public Number getMouseSpeed() {
        return this.selenium.getMouseSpeed();
    }

    public void dragAndDrop(String locator, String movementsString) {
        this.selenium.dragAndDrop(locator, movementsString);
    }

    public void dragAndDropToObject(String locatorOfObjectToBeDragged, String locatorOfDragDestinationObject) {
        this.selenium.dragAndDropToObject(locatorOfObjectToBeDragged, locatorOfDragDestinationObject);
    }

    public void windowFocus() {
        this.selenium.windowFocus();
    }

    public void windowMaximize() {
        this.selenium.windowMaximize();
    }

    public String[] getAllWindowIds() {
        return this.selenium.getAllWindowIds();
    }

    public String[] getAllWindowNames() {
        return this.selenium.getAllWindowNames();
    }

    public String[] getAllWindowTitles() {
        return this.selenium.getAllWindowTitles();
    }

    public String getHtmlSource() {
        return this.selenium.getHtmlSource();
    }

    public void setCursorPosition(String locator, String position) {
        this.selenium.setCursorPosition(locator, position);
    }

    public Number getElementIndex(String locator) {
        return this.selenium.getElementIndex(locator);
    }

    public boolean isOrdered(String locator1, String locator2) {
        return this.selenium.isOrdered(locator1, locator2);
    }

    public Number getElementPositionLeft(String locator) {
        return this.selenium.getElementPositionLeft(locator);
    }

    public Number getElementPositionTop(String locator) {
        return this.selenium.getElementPositionTop(locator);
    }

    public Number getElementWidth(String locator) {
        return this.selenium.getElementWidth(locator);
    }

    public Number getElementHeight(String locator) {
        return this.selenium.getElementHeight(locator);
    }

    public Number getCursorPosition(String locator) {
        return this.selenium.getCursorPosition(locator);
    }

    public String getExpression(String expression) {
        return this.selenium.getExpression(expression);
    }

    public Number getXpathCount(String xpath) {
        return this.selenium.getXpathCount(xpath);
    }

    public void assignId(String locator, String identifier) {
        this.selenium.assignId(locator, identifier);
    }

    public void allowNativeXpath(String allow) {
        this.selenium.allowNativeXpath(allow);
    }

    public void ignoreAttributesWithoutValue(String ignore) {
        this.selenium.ignoreAttributesWithoutValue(ignore);
    }

    public void waitForCondition(String script, String timeout) {
        this.selenium.waitForCondition(script, timeout);
    }

    public void setTimeout(String timeout) {
        this.selenium.setTimeout(timeout);
    }

    public void waitForPageToLoad(String timeout) {
        this.selenium.waitForPageToLoad(timeout);
    }

    public void waitForFrameToLoad(String frameAddress, String timeout) {
        this.selenium.waitForFrameToLoad(frameAddress, timeout);
    }

    public String getCookie() {
        return this.selenium.getCookie();
    }

    public String getCookieByName(String name) {
        return this.selenium.getCookieByName(name);
    }

    public boolean isCookiePresent(String name) {
        return this.selenium.isCookiePresent(name);
    }

    public void createCookie(String nameValuePair, String optionsString) {
        this.selenium.createCookie(nameValuePair, optionsString);
    }

    public void deleteCookie(String name, String optionsString) {
        this.selenium.deleteCookie(name, optionsString);
    }

    public void deleteAllVisibleCookies() {
        this.selenium.deleteAllVisibleCookies();
    }

    public void setBrowserLogLevel(String logLevel) {
        this.selenium.setBrowserLogLevel(logLevel);
    }

    public void runScript(String script) {
        this.selenium.runScript(script);
    }

    public void addLocationStrategy(String strategyName, String functionDefinition) {
        this.selenium.addLocationStrategy(strategyName, functionDefinition);
    }

    public void setContext(String context) {
        this.selenium.setContext(context);
    }

    public void attachFile(String fieldLocator, String fileLocator) {
        this.selenium.attachFile(fieldLocator, fileLocator);
    }

    public void captureScreenshot(String filename) {
        this.selenium.captureScreenshot(filename);
    }

    public void shutDownSeleniumServer() {
        this.selenium.shutDownSeleniumServer();
    }

    public void keyDownNative(String keycode) {
        this.selenium.keyDownNative(keycode);
    }

    public void keyUpNative(String keycode) {
        this.selenium.keyUpNative(keycode);
    }

    public void keyPressNative(String keycode) {
        this.selenium.keyPressNative(keycode);
    }

    protected final void start(String ... linkText) {
        this.open(BASE_URL);
        for (String s : linkText) {
            this.clickAndWait(String.format("link=%s", s));
        }
    }

    public String getWebappRoot() {
        return this.webappRoot;
    }

    public void setWebappRoot(String webappRoot) {
        this.webappRoot = webappRoot;
    }

    public void setExtensionJs(String extensionJs) {
        this.selenium.setExtensionJs(extensionJs);
    }

    public void start(Object optionsObject) {
        this.selenium.start(optionsObject);
    }

    public void showContextualBanner() {
        this.selenium.showContextualBanner();
    }

    public void showContextualBanner(String className, String methodName) {
        this.selenium.showContextualBanner(className, methodName);
    }

    public void mouseDownRight(String locator) {
        this.selenium.mouseDownRight(locator);
    }

    public void mouseDownRightAt(String locator, String coordString) {
        this.selenium.mouseDownRightAt(locator, coordString);
    }

    public void captureEntirePageScreenshot(String filename, String kwargs) {
        this.selenium.captureEntirePageScreenshot(filename, kwargs);
    }

    public void rollup(String rollupName, String kwargs) {
        this.selenium.rollup(rollupName, kwargs);
    }

    public void addScript(String scriptContent, String scriptTagId) {
        this.selenium.addScript(scriptContent, scriptTagId);
    }

    public void removeScript(String scriptTagId) {
        this.selenium.removeScript(scriptTagId);
    }

    public void useXpathLibrary(String libraryName) {
        this.selenium.useXpathLibrary(libraryName);
    }

    public String captureScreenshotToString() {
        return this.selenium.captureScreenshotToString();
    }

    public String captureEntirePageScreenshotToString(String kwargs) {
        return this.selenium.captureEntirePageScreenshotToString(kwargs);
    }

    public String retrieveLastRemoteControlLogs() {
        return this.selenium.retrieveLastRemoteControlLogs();
    }

    public void mouseUpRight(String locator) {
        this.selenium.mouseUpRight(locator);
    }

    public void mouseUpRightAt(String locator, String coordString) {
        this.selenium.mouseUpRightAt(locator, coordString);
    }

    public void start(String linkText) {
        this.start(new String[]{linkText});
    }

    public void addCustomRequestHeader(String key, String value) {
        this.selenium.addCustomRequestHeader(key, value);
    }

    public String captureNetworkTraffic(String type) {
        return this.selenium.captureNetworkTraffic(type);
    }

    public void deselectPopUp() {
        this.selenium.deselectPopUp();
    }

    public void selectPopUp(String windowID) {
        this.selenium.selectPopUp(windowID);
    }

    public String getLog() {
        return this.selenium.getLog();
    }

    public void open(String url, String ignoreResponseCode) {
        this.selenium.open(url, ignoreResponseCode);
    }
}

