/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.apache.tapestry5.ioc.AnnotationAccess;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.MethodAdvice;
import org.apache.tapestry5.ioc.internal.services.AbtractAspectInterceptorBuilder;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformation;
import org.apache.tapestry5.plastic.PlasticField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectInterceptorBuilderImpl<T>
extends AbtractAspectInterceptorBuilder<T> {
    private final Class<T> serviceInterface;
    private final Set<Method> allMethods = CollectionFactory.newSet();
    private final PlasticClassTransformation transformation;
    private final PlasticClass plasticClass;

    public AspectInterceptorBuilderImpl(AnnotationAccess annotationAccess, PlasticProxyFactory plasticProxyFactory, Class<T> serviceInterface, T delegate, String description) {
        super(annotationAccess);
        this.serviceInterface = serviceInterface;
        this.transformation = plasticProxyFactory.createProxyTransformation(serviceInterface);
        this.plasticClass = this.transformation.getPlasticClass();
        this.plasticClass.addToString(description);
        this.allMethods.addAll(Arrays.asList(serviceInterface.getMethods()));
        PlasticField delegateField = this.plasticClass.introduceField(serviceInterface, "delegate").inject(delegate);
        for (Method method : this.allMethods) {
            this.plasticClass.introduceMethod(method).delegateTo(delegateField);
        }
    }

    @Override
    public void adviseMethod(Method method, MethodAdvice advice) {
        assert (method != null);
        assert (advice != null);
        AnnotationProvider methodAnnotationProvider = this.getMethodAnnotationProvider(method.getName(), method.getParameterTypes());
        this.adviseMethod(method, InternalUtils.toPlasticMethodAdvice(advice, methodAnnotationProvider));
    }

    @Override
    public void adviseAllMethods(MethodAdvice advice) {
        for (Method m : this.serviceInterface.getMethods()) {
            this.adviseMethod(m, advice);
        }
    }

    @Override
    public void adviseMethod(Method method, org.apache.tapestry5.plastic.MethodAdvice advice) {
        assert (method != null);
        assert (advice != null);
        if (!this.allMethods.contains(method)) {
            throw new IllegalArgumentException(String.format("Method %s is not defined for interface %s.", method, this.serviceInterface));
        }
        this.plasticClass.introduceMethod(method).addAdvice(advice);
    }

    @Override
    public void adviseAllMethods(org.apache.tapestry5.plastic.MethodAdvice advice) {
        for (Method m : this.serviceInterface.getMethods()) {
            this.adviseMethod(m, advice);
        }
    }

    @Override
    public Class getInterface() {
        return this.serviceInterface;
    }

    @Override
    public T build() {
        return (T)this.transformation.createInstantiator().newInstance();
    }
}

